/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.actions;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.timeseriesanalysis.CMDLWizard;
import uk.ac.ed.inf.pepa.sba.SBAtoISBJava;

public class CMDLActionDelegate
implements IObjectActionDelegate {
    Shell cachedShell = null;
    IFile cmdl = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.cachedShell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        if (this.cmdl != null) {
            SBAtoISBJava model = null;
            StringBuilder sb = null;
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(this.cmdl.getContents()));
                sb = new StringBuilder();
                String s = br.readLine();
                while (s != null) {
                    sb.append(s).append("\n");
                    s = br.readLine();
                }
                model = SBAtoISBJava.generateModel((String)sb.toString());
            }
            catch (Throwable t) {
                MessageDialog.openError((Shell)this.cachedShell, (String)"Error loading cmdl file", (String)t.getMessage());
                return;
            }
            CMDLWizard wizard = new CMDLWizard((IResource)this.cmdl, model);
            WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
            dialog.open();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        StructuredSelection ss = (StructuredSelection)selection;
        this.cmdl = (IFile)ss.getFirstElement();
    }
}

