/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.console;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.MessageConsoleStream;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraModelChangedListener;
import uk.ac.ed.inf.pepa.eclipse.core.ProcessAlgebraModelChangedEvent;
import uk.ac.ed.inf.pepa.eclipse.ui.console.IPepaConsoleWriter;
import uk.ac.ed.inf.pepa.eclipse.ui.view.statespaceexplorer.ProcessAlgebraModelPage;

public class ConsoleWriter
implements IProcessAlgebraModelChangedListener,
IPepaConsoleWriter {
    private static final String MODEL_ADDED = "Model added.";
    private static final String MODEL_SOLVED = "Model solved.";
    private static final String MODEL_DERIVED = "Model derived.";
    private static final String MODEL_PARSED = "Model parsed.";
    private static final String MODEL_ANALYSED = "Model analysed.";
    private static final String SHOW_STATE_SPACE = "Click to show state space";
    private static final String SHOW_RESULTS = "Click to show results";
    private static final String STATE_SPACE_VIEW_ID = "uk.ac.ed.inf.pepa.eclipse.ui.stateSpaceView";
    private static final String KRONECKER_DERIVED = "Kronecker state space derived.";
    private static final String MODEL_CHECKING_INFO = "<Model Checker> ";
    private MessageConsoleStream stream;
    private IDocument console;
    private final IHyperlink showStateSpace;
    private final IHyperlink showGraphs;
    private ConsoleLinker listener;
    private IPepaModel pepaModel;
    private String modelName;
    private DateFormat dateFormat;

    public ConsoleWriter(MessageConsoleStream stream, IPepaModel model) {
        this.stream = stream;
        this.console = stream.getConsole().getDocument();
        this.showStateSpace = new IHyperlink(){

            public void linkActivated() {
                ProcessAlgebraModelPage.revealStateSpace();
            }

            public void linkEntered() {
            }

            public void linkExited() {
            }
        };
        this.showGraphs = new IHyperlink(){

            public void linkActivated() {
                try {
                    IWorkbenchWindow dw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    dw.getActivePage().showView("uk.ac.ed.inf.common.ui.plotview.views.PlotView");
                }
                catch (Exception exception) {}
            }

            public void linkEntered() {
            }

            public void linkExited() {
            }
        };
        this.listener = new ConsoleLinker();
        this.console.addDocumentListener((IDocumentListener)this.listener);
        this.pepaModel = model;
        this.modelName = this.pepaModel.getUnderlyingResource().getName();
        this.dateFormat = DateFormat.getTimeInstance();
        this.append(MODEL_ADDED);
    }

    public void processAlgebraModelChanged(ProcessAlgebraModelChangedEvent event) {
        switch (event.getType()) {
            case 0: {
                if (((IPepaModel)event.getProcessAlgebraModel()).getAST() == null) break;
                this.notify(MODEL_PARSED);
                break;
            }
            case 1: {
                if (event.getProcessAlgebraModel().getStateSpace() == null || event.getException() != null) break;
                this.notify("Model derived. Elapsed time: " + event.getElapsedTimeMillis() + " ms. " + SHOW_STATE_SPACE);
                this.listener.linkWhenReady(SHOW_STATE_SPACE, this.showStateSpace, STATE_SPACE_VIEW_ID);
                break;
            }
            case 2: {
                if (event.getProcessAlgebraModel().getStateSpace() == null || !event.getProcessAlgebraModel().getStateSpace().isSolutionAvailable() || event.getException() != null) break;
                this.notify("Model solved. Elapsed time: " + event.getElapsedTimeMillis() + " ms. " + SHOW_RESULTS);
                this.listener.linkWhenReady(SHOW_RESULTS, this.showStateSpace, STATE_SPACE_VIEW_ID);
                break;
            }
            case 4: {
                if (((IPepaModel)event.getProcessAlgebraModel()).getTimeSeries() == null || event.getException() != null) break;
                this.notify("Model analysed.Elapsed time:" + event.getElapsedTimeMillis() + " ms. " + SHOW_RESULTS);
                this.listener.linkWhenReady(SHOW_RESULTS, this.showGraphs, null);
                break;
            }
            case 5: {
                if (event.getException() != null) {
                    this.notify("Warning: " + event.getException().getMessage());
                    break;
                }
                if (((IPepaModel)event.getProcessAlgebraModel()).getDisplayModel() == null) break;
                this.notify("Kronecker state space derived. Elapsed time: " + event.getElapsedTimeMillis() + " ms. ");
                break;
            }
            case 6: {
                if (event.getException() == null) {
                    this.notify("Property \"" + event.getInformation() + "\" was checked in " + event.getElapsedTimeMillis() + " ms. ");
                    break;
                }
                this.notify("An error occurred: " + event.getException().getMessage());
                break;
            }
            case 7: {
                if (event.getException() != null) break;
                this.notify(MODEL_CHECKING_INFO + event.getInformation());
                break;
            }
        }
    }

    @Override
    public void append(String message) {
        this.stream.println(String.valueOf(this.dateFormat.format(new Date())) + " [" + this.modelName + "] " + message);
    }

    private void notify(String basicMessage) {
        this.append(basicMessage);
    }

    private class ConsoleLinker
    implements IDocumentListener {
        String string;
        String pageID;
        IHyperlink linkToAdd = null;

        private ConsoleLinker() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            if (this.linkToAdd != null) {
                try {
                    try {
                        ConsoleWriter.this.stream.getConsole().addHyperlink(this.linkToAdd, ConsoleWriter.this.console.get().lastIndexOf(this.string), this.string.length());
                    }
                    catch (BadLocationException badLocationException) {
                        this.linkToAdd = null;
                        return;
                    }
                }
                finally {
                    this.linkToAdd = null;
                }
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (this.pageID != null && !page.isPartVisible((IWorkbenchPart)page.findView(this.pageID)) && page.getPerspective().getId().equals("uk.ac.ed.inf.pepa.eclipse.ui.PepaPerspective")) {
                    ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)ConsoleWriter.this.stream.getConsole());
                }
            }
        }

        public void linkWhenReady(String string, IHyperlink link, String pageID) {
            this.string = string;
            this.linkToAdd = link;
            this.pageID = pageID;
        }
    }
}

