/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.console;

import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraManagerListener;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraModel;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraModelChangedListener;
import uk.ac.ed.inf.pepa.eclipse.core.PepaCore;
import uk.ac.ed.inf.pepa.eclipse.ui.console.ConsoleWriter;
import uk.ac.ed.inf.pepa.eclipse.ui.console.IPepaConsoleWriter;

public class PepaConsole {
    private static final PepaConsole SINGLETON = new PepaConsole();
    private HashMap<IPepaModel, ConsoleWriter> map = new HashMap();

    public static PepaConsole getDefault() {
        return SINGLETON;
    }

    private PepaConsole() {
        MessageConsole console = new MessageConsole("PEPA", null);
        final MessageConsoleStream stream = console.newMessageStream();
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        manager.addConsoles(new IConsole[]{console});
        PepaCore.getDefault().getPepaManager().addListener(new IProcessAlgebraManagerListener(){

            public void modelAdded(IProcessAlgebraModel model) {
                ConsoleWriter writer = new ConsoleWriter(stream, (IPepaModel)model);
                model.addModelChangedListener((IProcessAlgebraModelChangedListener)writer);
                PepaConsole.this.map.put((IPepaModel)model, writer);
            }

            public void modelRemoved(IProcessAlgebraModel model) {
                ConsoleWriter writer = (ConsoleWriter)PepaConsole.this.map.get(model);
                Assert.isNotNull((Object)writer);
                model.removeModelChangedListener((IProcessAlgebraModelChangedListener)writer);
                PepaConsole.this.map.remove(model);
            }
        });
    }

    public IPepaConsoleWriter getPepaConsoleWriter(IPepaModel model) {
        Assert.isNotNull((Object)model);
        return this.map.get(model);
    }
}

