/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.eclipse.ui.dialogs.ConfigurationWidget;
import uk.ac.ed.inf.pepa.eclipse.ui.dialogs.IValidationCallback;

public abstract class AbstractConfigurationWizardPage
extends WizardPage
implements IValidationCallback {
    protected final List<ConfigurationWidget> configurationWidgets = new ArrayList<ConfigurationWidget>();
    protected Composite settingPanel;
    protected int textStyle = 133120;
    protected int labelStyle = 131072;
    protected int gridDataStyle = 768;

    protected AbstractConfigurationWizardPage(String pageName) {
        super(pageName);
    }

    public void setWizard(IWizard wizard) {
        super.setWizard(wizard);
        this.createConfigurationWidgets();
    }

    public final void createControl(Composite parent) {
        this.settingPanel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.settingPanel.setLayout((Layout)layout);
        this.setControl((Control)this.settingPanel);
        this.fillSettingPanel();
        Button reset = new Button(this.settingPanel, 0);
        reset.setText("Reset to defaults");
        GridData resetData = new GridData();
        resetData.horizontalSpan = 2;
        resetData.verticalSpan = 1;
        resetData.horizontalAlignment = 131072;
        reset.setLayoutData((Object)resetData);
        reset.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AbstractConfigurationWizardPage.this.resetToDefaults();
            }
        });
        this.validate();
    }

    protected void resetToDefaults() {
        for (ConfigurationWidget widget : this.configurationWidgets) {
            widget.resetToDefault();
            widget.updateControl();
        }
    }

    protected abstract void fillSettingPanel();

    protected abstract void createConfigurationWidgets();

    public void setOptions(OptionMap map) {
        for (ConfigurationWidget widget : this.configurationWidgets) {
            map.put((Object)widget.getProperty(), widget.getValue());
        }
    }

    @Override
    public void validate() {
        this.setPageComplete(false);
        this.setErrorMessage(null);
        boolean validation = true;
        for (ConfigurationWidget widget : this.configurationWidgets) {
            validation = widget.isValid();
            if (validation) continue;
            this.setErrorMessage("Value not allowed");
            break;
        }
        this.setPageComplete(validation);
    }
}

