/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.editor;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.core.PepaCore;
import uk.ac.ed.inf.pepa.eclipse.ui.Activator;
import uk.ac.ed.inf.pepa.eclipse.ui.editor.ColorManager;
import uk.ac.ed.inf.pepa.eclipse.ui.editor.IProcessAlgebraEditor;
import uk.ac.ed.inf.pepa.eclipse.ui.editor.PepaDocumentProvider;
import uk.ac.ed.inf.pepa.eclipse.ui.editor.PepaViewerConfiguration;

public class PEPAEditor
extends TextEditor
implements IProcessAlgebraEditor {
    private IPepaModel fModel;
    private ColorManager fColorManager = new ColorManager();

    public PEPAEditor() {
        this.setSourceViewerConfiguration(new PepaViewerConfiguration(this.fColorManager));
        this.setDocumentProvider((IDocumentProvider)new PepaDocumentProvider());
    }

    public void dispose() {
        this.fColorManager.dispose();
        super.dispose();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.fModel = this.getIResource(input);
        if (this.fModel == null) {
            throw new PartInitException("Model not available for EditorInput:" + input.getName());
        }
        PEPAEditor.checkPerspective(site.getPage());
    }

    public static void checkPerspective(IWorkbenchPage page) {
        boolean result;
        IPerspectiveDescriptor descriptor = page.getPerspective();
        if (descriptor == null) {
            return;
        }
        String currentPerspective = descriptor.getId();
        if (!currentPerspective.equals("uk.ac.ed.inf.pepa.eclipse.ui.PepaPerspective") && (result = MessageDialog.openQuestion((Shell)page.getWorkbenchWindow().getShell(), (String)"Switch to PEPA Perspective", (String)"This resource is associated to PEPA perspective. Would you like to switch to PEPA Perspective now?"))) {
            IWorkbench workbench = Activator.getDefault().getWorkbench();
            page.setPerspective(workbench.getPerspectiveRegistry().findPerspectiveWithId("uk.ac.ed.inf.pepa.eclipse.ui.PepaPerspective"));
        }
    }

    public IPepaModel getProcessAlgebraModel() {
        return this.fModel;
    }

    private IPepaModel getIResource(IEditorInput input) {
        IResource resource = (IResource)input.getAdapter(IResource.class);
        return PepaCore.getDefault().getPepaManager().getModel(resource);
    }
}

