/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.editor;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import uk.ac.ed.inf.pepa.eclipse.ui.editor.ColorManager;
import uk.ac.ed.inf.pepa.eclipse.ui.editor.IPepaColorConstants;
import uk.ac.ed.inf.pepa.eclipse.ui.editor.PepaWhitespaceDetector;
import uk.ac.ed.inf.pepa.eclipse.ui.editor.PepaWordDetector;

public class PepaScanner
extends RuleBasedScanner {
    public PepaScanner(ColorManager manager) {
        new Token((Object)new TextAttribute(manager.getColor(IPepaColorConstants.DEFAULT)));
        Token keyword = new Token((Object)new TextAttribute(manager.getColor(IPepaColorConstants.KEYWORD)));
        Token quotedName = new Token((Object)new TextAttribute(manager.getColor(IPepaColorConstants.QUOTED_NAME)));
        Token processName = new Token((Object)new TextAttribute(manager.getColor(IPepaColorConstants.PROCESS_NAME)));
        Token lowerCaseName = new Token((Object)new TextAttribute(manager.getColor(IPepaColorConstants.LOWER_NAME)));
        Token symbolName = new Token((Object)new TextAttribute(manager.getColor(IPepaColorConstants.SYMBOL)));
        Token numberLiteral = new Token((Object)new TextAttribute(manager.getColor(IPepaColorConstants.NUMBER)));
        IRule[] rules = new IRule[6];
        WordRule wordRule = new WordRule((IWordDetector)new PepaWordDetector(), (IToken)lowerCaseName);
        wordRule.addWord("tau", (IToken)keyword);
        wordRule.addWord("infty", (IToken)keyword);
        WordRule numberLiteralRule = new WordRule(new IWordDetector(){

            public boolean isWordStart(char c) {
                return Character.isDigit(c);
            }

            public boolean isWordPart(char c) {
                return Character.isDigit(c) || c == '.';
            }
        }, (IToken)numberLiteral);
        WordRule symbolRule = new WordRule(new IWordDetector(){

            public boolean isWordPart(char c) {
                return false;
            }

            public boolean isWordStart(char c) {
                return c == '<' || c == '>' || c == '|' || c == ',' || c == ';' || c == '=' || c == '.' || c == '(' || c == ')' || c == '+';
            }
        }, (IToken)symbolName);
        WordRule processRule = new WordRule(new IWordDetector(){

            public boolean isWordStart(char c) {
                return Character.isUpperCase(c);
            }

            public boolean isWordPart(char c) {
                return Character.isJavaIdentifierPart(c);
            }
        }, (IToken)processName);
        rules[0] = processRule;
        rules[1] = wordRule;
        rules[2] = symbolRule;
        rules[3] = numberLiteralRule;
        rules[4] = new SingleLineRule("\"", "\"", (IToken)quotedName);
        rules[5] = new WhitespaceRule((IWhitespaceDetector)new PepaWhitespaceDetector());
        this.setRules(rules);
    }
}

