/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.editor;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import uk.ac.ed.inf.pepa.eclipse.ui.editor.ColorManager;
import uk.ac.ed.inf.pepa.eclipse.ui.editor.IPepaColorConstants;
import uk.ac.ed.inf.pepa.eclipse.ui.editor.NonRuleBasedDamagerRepairer;
import uk.ac.ed.inf.pepa.eclipse.ui.editor.PepaScanner;

public class PepaViewerConfiguration
extends SourceViewerConfiguration {
    private PepaScanner scanner;
    private ColorManager colorManager;

    public PepaViewerConfiguration(ColorManager colorManager) {
        this.colorManager = colorManager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__srmc_comment"};
    }

    protected PepaScanner getSrmcScanner() {
        if (this.scanner == null) {
            this.scanner = new PepaScanner(this.colorManager);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IPepaColorConstants.DEFAULT))));
        }
        return this.scanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getSrmcScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        NonRuleBasedDamagerRepairer ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(this.colorManager.getColor(IPepaColorConstants.SRMC_COMMENT)));
        reconciler.setDamager((IPresentationDamager)ndr, "__srmc_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__srmc_comment");
        return reconciler;
    }
}

