/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.internal;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import uk.ac.ed.inf.pepa.ctmc.derivation.FilterFactory;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpaceFilter;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraModel;
import uk.ac.ed.inf.pepa.eclipse.ui.internal.AbstractConfigurableStateSpaceFilter;
import uk.ac.ed.inf.pepa.eclipse.ui.internal.IFilterValidatorListener;

public abstract class ActionFilter
extends AbstractConfigurableStateSpaceFilter {
    private String AFFIRMED = null;
    private String NEGATED = null;
    private String TAG_ACTION_FILTER = null;
    private String TAG_ACTION_NAME = null;
    private String TAG_NEGATION = "negation";
    private String fActionName = null;
    private boolean fIncoming;
    private IFilterValidatorListener fListener = new IFilterValidatorListener(){

        @Override
        public void filterValidated(String message) {
        }
    };

    public ActionFilter(IProcessAlgebraModel model, boolean incoming) {
        super(model);
        this.fIncoming = incoming;
        String tagPrefix = incoming ? "incoming" : "outgoing";
        this.TAG_ACTION_FILTER = String.valueOf(tagPrefix) + "ActionFilter";
        this.TAG_ACTION_NAME = String.valueOf(tagPrefix) + "ActionName";
        this.AFFIRMED = "with " + tagPrefix + " action";
        this.NEGATED = "without " + tagPrefix + " action";
    }

    @Override
    public void createGUI(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(1808));
        Label label = new Label(main, 0);
        label.setText("States");
        label.setLayoutData((Object)new GridData());
        Combo negationCombo = this.createNegationCombo(main);
        negationCombo.setLayoutData((Object)new GridData(768));
        final Text text = new Text(main, 2048);
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ActionFilter.this.fActionName = text.getText();
                ActionFilter.this.validate();
            }
        });
        if (this.fActionName != null) {
            text.setText(this.fActionName);
        }
    }

    @Override
    protected IStateSpaceFilter doCreateFilter() {
        return FilterFactory.createActionFilter((String)this.fActionName, (boolean)this.fIncoming);
    }

    @Override
    protected String getAffirmedString() {
        return this.AFFIRMED;
    }

    @Override
    public String getLabel() {
        return "States " + this.getDescription() + " " + this.getParameter();
    }

    @Override
    protected void getMemento(IMemento memento) {
        IMemento mem = memento.createChild(this.TAG_ACTION_FILTER);
        mem.putString(this.TAG_ACTION_NAME, this.fActionName);
        mem.putString(this.TAG_NEGATION, Boolean.toString(this.negation));
    }

    @Override
    protected String getNegatedString() {
        return this.NEGATED;
    }

    @Override
    protected String getParameter() {
        return this.fActionName;
    }

    @Override
    public void setFilterValidatorListener(IFilterValidatorListener listener) {
        this.fListener = listener;
        this.validate();
    }

    @Override
    protected void setMemento(IMemento memento) {
        IMemento mem = memento.getChild(this.TAG_ACTION_FILTER);
        this.fActionName = mem.getString(this.TAG_ACTION_NAME);
        this.negation = Boolean.parseBoolean(mem.getString(this.TAG_NEGATION));
    }

    private void validate() {
        String message = null;
        if (this.fActionName == null || this.fActionName.length() == 0) {
            message = "Please insert action name";
        }
        this.fListener.filterValidated(message);
    }
}

