/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraModel;
import uk.ac.ed.inf.pepa.eclipse.core.PepaLog;
import uk.ac.ed.inf.pepa.eclipse.ui.IFilterManager;
import uk.ac.ed.inf.pepa.eclipse.ui.IFilterModel;
import uk.ac.ed.inf.pepa.eclipse.ui.internal.FilterModel;

public class FilterManager
implements IFilterManager {
    private IProcessAlgebraModel pepaModel;
    List<FilterModel> filterModels;
    private static final String TAG_CONFIGURATIONS = "configurations";
    private static final String TAG_CONFIGURATION = "configuration";

    public FilterManager(IProcessAlgebraModel pepaModel) {
        this.pepaModel = pepaModel;
        this.initConfigurations();
    }

    @Override
    public IProcessAlgebraModel getProcessAlgebraModel() {
        return this.pepaModel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initConfigurations() {
        this.filterModels = new ArrayList<FilterModel>();
        FileReader reader = null;
        try {
            try {
                reader = new FileReader(this.getStorageFile());
                this.loadConfigurations(XMLMemento.createReadRoot((Reader)reader));
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException e) {
                    PepaLog.logError((Throwable)e);
                }
                return;
            }
            catch (WorkbenchException e) {
                PepaLog.logError((Throwable)e);
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException e2) {
                    PepaLog.logError((Throwable)e2);
                }
                return;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    PepaLog.logError((Throwable)e);
                }
            }
        }
    }

    private void loadConfigurations(XMLMemento memento) {
        IMemento[] children;
        IMemento[] iMementoArray = children = memento.getChildren(TAG_CONFIGURATION);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento child = iMementoArray[n2];
            FilterModel model = new FilterModel(this.pepaModel);
            model.setMemento(child);
            this.filterModels.add(model);
            ++n2;
        }
    }

    File getStorageFile() {
        return this.pepaModel.getUnderlyingResource().getLocation().addFileExtension("filters").toFile();
    }

    void saveConfigurations() {
        block12: {
            XMLMemento memento = XMLMemento.createWriteRoot((String)TAG_CONFIGURATIONS);
            this.saveConfigurations(memento);
            FileWriter writer = null;
            try {
                try {
                    writer = new FileWriter(this.getStorageFile());
                    memento.save((Writer)writer);
                }
                catch (IOException e) {
                    PepaLog.logError((Throwable)e);
                    if (writer == null) break block12;
                    try {
                        writer.close();
                    }
                    catch (IOException e2) {
                        PepaLog.logError((Throwable)e2);
                    }
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        PepaLog.logError((Throwable)e);
                    }
                }
            }
        }
    }

    private void saveConfigurations(XMLMemento memento) {
        for (FilterModel configuration : this.filterModels) {
            IMemento child = memento.createChild(TAG_CONFIGURATION);
            configuration.getMemento(child);
        }
    }

    @Override
    public IFilterModel[] getFilterModels() {
        return this.filterModels.toArray(new IFilterModel[this.filterModels.size()]);
    }
}

