/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraManager;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraManagerListener;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraModel;
import uk.ac.ed.inf.pepa.eclipse.core.PepaCore;
import uk.ac.ed.inf.pepa.eclipse.core.PepaLog;
import uk.ac.ed.inf.pepa.eclipse.ui.Activator;
import uk.ac.ed.inf.pepa.eclipse.ui.IFilterManagerProvider;
import uk.ac.ed.inf.pepa.eclipse.ui.internal.FilterManager;

public class FilterManagerProvider
implements IFilterManagerProvider {
    private static final String TAG_MODELS = "filters";
    private static final String TAG_MODEL = "model";
    private static final String TAG_MODEL_PATH = "modelpath";
    private static final String TAG_FILTER = "filter";
    private IProcessAlgebraManagerListener fListener = new IProcessAlgebraManagerListener(){

        public void modelAdded(IProcessAlgebraModel model) {
        }

        public void modelRemoved(IProcessAlgebraModel model) {
            FilterManagerProvider.this.checkModelRemoved(model);
        }
    };
    private HashMap<IProcessAlgebraModel, FilterManager> fMap = new HashMap();

    public FilterManagerProvider(IProcessAlgebraManager processAlgebraManager) {
        this.checkExistence();
        processAlgebraManager.addListener(this.fListener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkExistence() {
        FileReader reader = null;
        try {
            try {
                reader = new FileReader(this.getStorageFile());
                this.doCheckExistence(XMLMemento.createReadRoot((Reader)reader));
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException e) {
                    PepaLog.logError((Throwable)e);
                }
                return;
            }
            catch (WorkbenchException e) {
                PepaLog.logError((Throwable)e);
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException e2) {
                    PepaLog.logError((Throwable)e2);
                }
                return;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    PepaLog.logError((Throwable)e);
                }
            }
        }
    }

    private void doCheckExistence(XMLMemento memento) {
        IMemento[] children;
        IMemento[] iMementoArray = children = memento.getChildren(TAG_MODEL);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento child = iMementoArray[n2];
            String pepaModelString = child.getString(TAG_MODEL_PATH);
            IPath pepaModelPath = Path.fromPortableString((String)pepaModelString);
            IFile resource = ResourcesPlugin.getWorkspace().getRoot().getFile(pepaModelPath);
            try {
                String filterStorage;
                File file;
                resource.refreshLocal(0, null);
                if (resource.getProject().isOpen() && !resource.exists() && (file = new File(filterStorage = child.getString(TAG_FILTER))).exists()) {
                    this.tryDeleting(file);
                }
            }
            catch (CoreException e) {
                PepaLog.logError((Throwable)e);
            }
            ++n2;
        }
    }

    @Override
    public FilterManager getFilterManager(IProcessAlgebraModel model) {
        FilterManager manager = this.fMap.get(model);
        if (manager == null) {
            manager = new FilterManager(model);
            this.fMap.put(model, manager);
        }
        return manager;
    }

    public void shutdown() {
        PepaCore.getDefault().getPepaManager().removeListener(this.fListener);
        this.saveMappings();
    }

    private void saveMappings() {
        block12: {
            XMLMemento memento = XMLMemento.createWriteRoot((String)TAG_MODELS);
            this.saveModels((IMemento)memento);
            FileWriter writer = null;
            try {
                try {
                    writer = new FileWriter(this.getStorageFile());
                    memento.save((Writer)writer);
                }
                catch (IOException e) {
                    PepaLog.logError((Throwable)e);
                    if (writer == null) break block12;
                    try {
                        writer.close();
                    }
                    catch (IOException e2) {
                        PepaLog.logError((Throwable)e2);
                    }
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        PepaLog.logError((Throwable)e);
                    }
                }
            }
        }
    }

    private File getStorageFile() {
        return Activator.getDefault().getStateLocation().append("filter_manager.xml").toFile();
    }

    private void saveModels(IMemento memento) {
        for (Map.Entry<IProcessAlgebraModel, FilterManager> mapping : this.fMap.entrySet()) {
            IMemento child = memento.createChild(TAG_MODEL);
            child.putString(TAG_FILTER, mapping.getValue().getStorageFile().getAbsolutePath());
            child.putString(TAG_MODEL_PATH, mapping.getKey().getUnderlyingResource().getFullPath().toPortableString());
        }
    }

    private void checkModelRemoved(IProcessAlgebraModel model) {
        FilterManager mng = this.fMap.get(model);
        if (mng == null) {
            return;
        }
        this.tryDeleting(mng.getStorageFile());
    }

    private void tryDeleting(File toBeDeleted) {
        if (toBeDeleted.exists()) {
            toBeDeleted.delete();
        }
    }
}

