/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpaceFilter;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraModel;
import uk.ac.ed.inf.pepa.eclipse.core.PepaLog;
import uk.ac.ed.inf.pepa.eclipse.ui.Activator;
import uk.ac.ed.inf.pepa.eclipse.ui.IFilterModel;
import uk.ac.ed.inf.pepa.eclipse.ui.internal.AbstractConfigurableStateSpaceFilter;
import uk.ac.ed.inf.pepa.eclipse.ui.internal.FilterFactory;
import uk.ac.ed.inf.pepa.eclipse.ui.internal.IFilterValidatorListener;
import uk.ac.ed.inf.pepa.eclipse.ui.view.statespaceexplorer.RuleLabelProvider;

public class FilterModel
implements IFilterModel {
    private static final String TAG_FILTERS = "filters";
    private static final String TAG_NAME = "name";
    private static final String TAG_ORED = "or";
    private static final String TAG_FILTER = "filter";
    private static final String TAG_TYPE = "filterType";
    private static final String TAG_SPECIFIC_MEMENTO = "specificMemento";
    private IProcessAlgebraModel model;
    private final List<AbstractConfigurableStateSpaceFilter> filters = new ArrayList<AbstractConfigurableStateSpaceFilter>();
    private boolean orFilters = false;
    private boolean calledProgrammatically = false;
    private String name = "";

    public FilterModel(IProcessAlgebraModel model) {
        this.model = model;
    }

    public Dialog createDialogControl(Shell shell, IInputValidator textTalidator) {
        return new FilterDialog(shell, textTalidator);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IStateSpaceFilter[] getFilters() {
        IStateSpaceFilter[] filterArray = new IStateSpaceFilter[this.filters.size()];
        int i = 0;
        for (AbstractConfigurableStateSpaceFilter f : this.filters) {
            filterArray[i++] = f.getFilter();
        }
        if (filterArray.length != 0 && this.orFilters) {
            return new IStateSpaceFilter[]{uk.ac.ed.inf.pepa.ctmc.derivation.FilterFactory.createOr((IStateSpaceFilter[])filterArray)};
        }
        return filterArray;
    }

    public void setMemento(IMemento memento) {
        this.filters.clear();
        IMemento filtersMemento = memento.getChild(TAG_FILTERS);
        this.name = filtersMemento.getString(TAG_NAME);
        this.orFilters = Boolean.parseBoolean(filtersMemento.getString(TAG_ORED));
        IMemento[] iMementoArray = filtersMemento.getChildren(TAG_FILTER);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento filterMemento = iMementoArray[n2];
            AbstractConfigurableStateSpaceFilter filter = FilterFactory.createFilter(this.model, filterMemento.getString(TAG_TYPE));
            filter.setMemento(filterMemento.getChild(TAG_SPECIFIC_MEMENTO));
            this.filters.add(filter);
            ++n2;
        }
    }

    public void getMemento(IMemento memento) {
        IMemento filtersMemento = memento.createChild(TAG_FILTERS);
        filtersMemento.putString(TAG_ORED, "" + this.orFilters);
        filtersMemento.putString(TAG_NAME, this.name);
        for (AbstractConfigurableStateSpaceFilter filter : this.filters) {
            IMemento filterMemento = filtersMemento.createChild(TAG_FILTER);
            filterMemento.putString(TAG_TYPE, FilterFactory.getTagForClass(filter));
            IMemento specificMemento = filterMemento.createChild(TAG_SPECIFIC_MEMENTO);
            filter.getMemento(specificMemento);
        }
    }

    class FilterDialog
    extends TitleAreaDialog {
        private Map<String, String> tagToDescription;
        private static final String DIALOG_SETTINGS_NAME = "FILTER_MODEL_DIALOG";
        private Button buttonMatchAny;
        private Button buttonMatchAll;
        private Button buttonRemoveRule;
        private NewRuleAction newRuleAction;
        private EditRuleAction editRuleAction;
        private RemoveRuleAction removeRuleAction;
        private ListViewer ruleListViewer;
        private ArrayList<AbstractConfigurableStateSpaceFilter> rules;
        private IInputValidator textValidator;
        private Text nameText;
        private Listener listener;

        private void fillHashMap() {
            this.tagToDescription.put("sequentialComponent", "Sequential components");
            this.tagToDescription.put("steadyStateProbability", "State whose steady-state probability");
            this.tagToDescription.put("patternMatching", "Pattern matching");
            this.tagToDescription.put("unnamedProcess", "Unnamed processes");
            this.tagToDescription.put("incomingActionFilter", "Incoming transitions");
            this.tagToDescription.put("outgoingActionFilter", "Outgoing transitions");
        }

        protected FilterDialog(Shell parentShell, IInputValidator validator) {
            super(parentShell);
            this.tagToDescription = new HashMap<String, String>();
            this.listener = new Listener(){

                public void handleEvent(Event event) {
                    if (FilterModel.this.calledProgrammatically) {
                        return;
                    }
                    FilterModel.this.orFilters = FilterDialog.this.buttonMatchAny.getSelection();
                }
            };
            this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
            this.textValidator = validator;
            this.fillHashMap();
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText("Filter Rules");
        }

        protected void okPressed() {
            this.updateFilters();
            super.okPressed();
        }

        private void updateFilters() {
            FilterModel.this.filters.clear();
            for (AbstractConfigurableStateSpaceFilter filter : this.rules) {
                FilterModel.this.filters.add(filter);
            }
        }

        protected IDialogSettings getDialogBoundsSettings() {
            IDialogSettings settings = Activator.getDefault().getDialogSettings();
            IDialogSettings section = settings.getSection(DIALOG_SETTINGS_NAME);
            if (section == null) {
                section = settings.addNewSection(DIALOG_SETTINGS_NAME);
            }
            return section;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            this.setTitle("Configure Filter Rules");
            GridLayout layout = new GridLayout();
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            Composite nameComp = new Composite(composite, 0);
            nameComp.setLayoutData((Object)new GridData(768));
            GridLayout nameLayout = new GridLayout();
            nameLayout.numColumns = 2;
            nameComp.setLayout((Layout)nameLayout);
            Label nameLabel = new Label(nameComp, 0);
            nameLabel.setText("Filter rule name:");
            nameLabel.setLayoutData((Object)new GridData());
            this.nameText = new Text(nameComp, 2048);
            this.nameText.setText(FilterModel.this.name);
            this.nameText.setLayoutData((Object)new GridData(768));
            Group orGroup = new Group(composite, 32);
            GridLayout orLayout = new GridLayout();
            orLayout.numColumns = 2;
            orLayout.makeColumnsEqualWidth = true;
            orGroup.setLayout((Layout)orLayout);
            GridData orData = new GridData(768);
            orGroup.setLayoutData((Object)orData);
            this.buttonMatchAll = new Button((Composite)orGroup, 16);
            this.buttonMatchAll.setText("Match all of the following");
            GridData allData = new GridData(768);
            allData.horizontalAlignment = 16384;
            this.buttonMatchAll.setLayoutData((Object)allData);
            this.buttonMatchAny = new Button((Composite)orGroup, 16);
            this.buttonMatchAny.setText("Match any of the following");
            GridData anyData = new GridData(768);
            anyData.horizontalAlignment = 131072;
            this.buttonMatchAny.setLayoutData((Object)anyData);
            Composite filterComposite = new Composite(composite, 0);
            filterComposite.setLayoutData((Object)new GridData(1808));
            GridLayout filterCompositeLayout = new GridLayout();
            filterCompositeLayout.numColumns = 2;
            filterCompositeLayout.marginWidth = 0;
            filterComposite.setLayout((Layout)filterCompositeLayout);
            org.eclipse.swt.widgets.List filterList = new org.eclipse.swt.widgets.List(filterComposite, 2052);
            filterList.setLayoutData((Object)new GridData(1808));
            this.ruleListViewer = new ListViewer(filterList);
            this.ruleListViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    List list = (List)inputElement;
                    return list.toArray(new AbstractConfigurableStateSpaceFilter[list.size()]);
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            this.ruleListViewer.setLabelProvider((IBaseLabelProvider)new RuleLabelProvider());
            this.ruleListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                    if (!sel.isEmpty()) {
                        FilterDialog.this.buttonRemoveRule.setEnabled(true);
                    } else {
                        FilterDialog.this.buttonRemoveRule.setEnabled(false);
                    }
                }
            });
            this.ruleListViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                    if (sel.isEmpty()) {
                        return;
                    }
                    AbstractConfigurableStateSpaceFilter rule = (AbstractConfigurableStateSpaceFilter)sel.getFirstElement();
                    FilterDialog.this.editRule(rule);
                }
            });
            this.reconcileTableWithModel();
            this.createActions();
            this.createContextMenu();
            Composite filterTableButtons = new Composite(filterComposite, 0);
            filterTableButtons.setLayoutData((Object)new GridData(1040));
            RowLayout compLayout = new RowLayout(512);
            compLayout.fill = true;
            filterTableButtons.setLayout((Layout)compLayout);
            this.buttonRemoveRule = new Button(filterTableButtons, 8);
            this.buttonRemoveRule.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    FilterDialog.this.performRemoveRule();
                }
            });
            this.buttonRemoveRule.setText("-");
            this.buttonRemoveRule.setToolTipText("Remove this rule");
            this.reconcileButtonStatusWithModel();
            this.buttonMatchAll.addListener(13, this.listener);
            this.buttonMatchAny.addListener(13, this.listener);
            return composite;
        }

        private void editRule(AbstractConfigurableStateSpaceFilter rule) {
            FilterSettingDialog dialog = new FilterSettingDialog(this.getShell(), rule);
            if (dialog.open() == 0) {
                this.ruleListViewer.refresh();
            }
        }

        private void createActions() {
            this.newRuleAction = new NewRuleAction();
            this.editRuleAction = new EditRuleAction();
            this.removeRuleAction = new RemoveRuleAction();
        }

        private void createContextMenu() {
            MenuManager manager = new MenuManager();
            Menu menu = manager.createContextMenu(this.ruleListViewer.getControl());
            this.ruleListViewer.getControl().setMenu(menu);
            manager.setRemoveAllWhenShown(true);
            manager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    manager.add((IAction)FilterDialog.this.newRuleAction);
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)FilterDialog.this.editRuleAction);
                    FilterDialog.this.editRuleAction.setEnabled(!FilterDialog.this.ruleListViewer.getSelection().isEmpty());
                    manager.add((IAction)FilterDialog.this.removeRuleAction);
                    FilterDialog.this.removeRuleAction.setEnabled(FilterDialog.this.editRuleAction.isEnabled());
                }
            });
        }

        protected Control createContents(Composite parent) {
            Control control = super.createContents(parent);
            this.nameText.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    FilterDialog.this.handleTextModified();
                }
            });
            this.handleTextModified();
            return control;
        }

        private void handleTextModified() {
            Button okButton = this.getButton(0);
            String newText = this.nameText.getText().trim();
            String message = this.textValidator.isValid(newText);
            if (message == null) {
                FilterModel.this.name = this.nameText.getText();
                okButton.setEnabled(true);
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(message);
                okButton.setEnabled(false);
            }
        }

        private void reconcileTableWithModel() {
            this.rules = new ArrayList();
            int i = 0;
            while (i < FilterModel.this.filters.size()) {
                this.rules.add((AbstractConfigurableStateSpaceFilter)FilterModel.this.filters.get(i));
                ++i;
            }
            this.ruleListViewer.setInput(this.rules);
        }

        private void performRemoveRule() {
            IStructuredSelection sel = (IStructuredSelection)this.ruleListViewer.getSelection();
            Assert.isTrue((sel.size() == 1 ? 1 : 0) != 0);
            AbstractConfigurableStateSpaceFilter selectedRule = (AbstractConfigurableStateSpaceFilter)sel.getFirstElement();
            this.ruleListViewer.remove((Object)selectedRule);
            this.rules.remove(selectedRule);
        }

        private void reconcileButtonStatusWithModel() {
            this.buttonMatchAny.setSelection(FilterModel.this.orFilters);
            this.buttonMatchAll.setSelection(!FilterModel.this.orFilters);
            this.buttonRemoveRule.setEnabled(!this.ruleListViewer.getSelection().isEmpty());
        }

        class EditRuleAction
        extends Action {
            public EditRuleAction() {
                this.setText("Edit");
            }

            public void run() {
                IStructuredSelection sel = (IStructuredSelection)FilterDialog.this.ruleListViewer.getSelection();
                if (sel.isEmpty()) {
                    return;
                }
                FilterDialog.this.editRule((AbstractConfigurableStateSpaceFilter)sel.getFirstElement());
            }
        }

        class FilterSettingDialog
        extends TitleAreaDialog {
            private AbstractConfigurableStateSpaceFilter filter;
            private IFilterValidatorListener listener;

            protected FilterSettingDialog(Shell parentShell, AbstractConfigurableStateSpaceFilter filter) {
                super(parentShell);
                this.listener = new IFilterValidatorListener(){

                    @Override
                    public void filterValidated(String message) {
                        FilterSettingDialog.this.getButton(0).setEnabled(message == null);
                        FilterSettingDialog.this.setErrorMessage(message);
                    }
                };
                this.filter = filter;
            }

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
                newShell.setText("Filter Settings");
            }

            protected Control createContents(Composite parent) {
                Control control = super.createContents(parent);
                this.setTitle("Configure Filter Settings");
                this.filter.setFilterValidatorListener(this.listener);
                return control;
            }

            protected Control createDialogArea(Composite parent) {
                Composite composite = new Composite(parent, 0);
                GridLayout layout = new GridLayout();
                composite.setLayout((Layout)layout);
                composite.setLayoutData((Object)new GridData(1808));
                this.filter.createGUI(composite);
                return composite;
            }
        }

        class NewRuleAction
        extends Action
        implements IMenuCreator {
            private Menu menu;

            public NewRuleAction() {
                super("", 4);
                this.setText("New");
                this.setMenuCreator(this);
            }

            public void dispose() {
                if (this.menu != null) {
                    this.menu.dispose();
                }
            }

            public Menu getMenu(Control parent) {
                return null;
            }

            public Menu getMenu(Menu parent) {
                if (this.menu != null) {
                    this.menu.dispose();
                }
                this.menu = new Menu(parent);
                for (Map.Entry entry : FilterDialog.this.tagToDescription.entrySet()) {
                    ActionContributionItem item = new ActionContributionItem((IAction)new AddAction((String)entry.getKey(), (String)entry.getValue()));
                    item.fill(this.menu, -1);
                }
                return this.menu;
            }

            private class AddAction
            extends Action {
                private String tag;

                AddAction(String tag, String description) {
                    this.tag = tag;
                    this.setText(description);
                }

                public void run() {
                    AbstractConfigurableStateSpaceFilter filter = FilterFactory.createFilter(FilterModel.this.model, this.tag);
                    if (filter == null) {
                        PepaLog.logError((Throwable)new IllegalArgumentException("Tag " + this.tag + " not recognised as filter"));
                        return;
                    }
                    FilterSettingDialog dialog = new FilterSettingDialog(FilterDialog.this.getShell(), filter);
                    if (dialog.open() == 0) {
                        FilterDialog.this.rules.add(filter);
                        FilterDialog.this.ruleListViewer.refresh();
                    }
                }
            }
        }

        class RemoveRuleAction
        extends Action {
            public RemoveRuleAction() {
                this.setText("Delete");
            }

            public void run() {
                IStructuredSelection sel = (IStructuredSelection)FilterDialog.this.ruleListViewer.getSelection();
                if (sel.isEmpty()) {
                    return;
                }
                FilterDialog.this.performRemoveRule();
            }
        }
    }
}

