/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.internal;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import uk.ac.ed.inf.pepa.eclipse.ui.Activator;
import uk.ac.ed.inf.pepa.eclipse.ui.IFilterModel;
import uk.ac.ed.inf.pepa.eclipse.ui.internal.FilterManager;
import uk.ac.ed.inf.pepa.eclipse.ui.internal.FilterModel;

public class ManagerDialog
extends Dialog {
    private ConfigurationNameValidator validator = new ConfigurationNameValidator();
    private static final String DIALOG_SETTINGS_NAME = "FILTER_MANAGER_DIALOG";
    private CheckboxTableViewer checkBoxViewer;
    private Button createButton;
    private Button editButton;
    private Button removeButton;
    private Button okButton;
    private FilterManager fFilterManager;
    private IFilterModel currentConfiguration = null;

    public ManagerDialog(FilterManager filterManager, Shell shell, IFilterModel selected) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.fFilterManager = filterManager;
        this.currentConfiguration = selected;
    }

    public IFilterModel getSelectedConfiguration() {
        return this.currentConfiguration;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("State Space Filters");
    }

    protected void okPressed() {
        this.fFilterManager.saveConfigurations();
        Object[] checkedElements = this.checkBoxViewer.getCheckedElements();
        this.currentConfiguration = checkedElements.length == 0 ? null : (IFilterModel)checkedElements[0];
        super.okPressed();
    }

    protected void cancelPressed() {
        this.fFilterManager.saveConfigurations();
        super.cancelPressed();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_NAME);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS_NAME);
        }
        return section;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        Composite main = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(1808));
        this.checkBoxViewer = CheckboxTableViewer.newCheckList((Composite)main, (int)2052);
        class CheckBoxLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            CheckBoxLabelProvider() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    FilterModel configuration = (FilterModel)element;
                    return configuration.getName();
                }
                return null;
            }
        }
        this.checkBoxViewer.setLabelProvider((IBaseLabelProvider)new CheckBoxLabelProvider());
        this.checkBoxViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.checkBoxViewer.setInput(this.fFilterManager.filterModels);
        this.checkBoxViewer.getTable().setLayoutData((Object)new GridData(1808));
        Composite buttonComposite = new Composite(main, 0);
        buttonComposite.setLayoutData((Object)new GridData(1040));
        RowLayout compLayout = new RowLayout(512);
        compLayout.fill = true;
        buttonComposite.setLayout((Layout)compLayout);
        this.createButton = new Button(buttonComposite, 8);
        this.createButton.setText("New...");
        this.createButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FilterModel config = ManagerDialog.this.performCreateConfiguration();
                ManagerDialog.this.updateControls();
                if (config != null) {
                    ManagerDialog.this.checkBoxViewer.setSelection((ISelection)new StructuredSelection((Object)config));
                }
            }
        });
        this.createButton.setToolTipText("Save the current configuration");
        this.editButton = new Button(buttonComposite, 8);
        this.editButton.setText("Edit...");
        this.editButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FilterModel old = ManagerDialog.this.getCurrentConfiguration();
                boolean wasChecked = ManagerDialog.this.checkBoxViewer.getChecked((Object)old);
                FilterModel config = ManagerDialog.this.performEditConfiguration(old);
                ManagerDialog.this.updateControls();
                ManagerDialog.this.checkBoxViewer.setSelection((ISelection)new StructuredSelection((Object)config));
                ManagerDialog.this.checkBoxViewer.setChecked((Object)config, wasChecked);
            }
        });
        this.editButton.setToolTipText("Update this configuration with the current settings");
        this.removeButton = new Button(buttonComposite, 8);
        this.removeButton.setText("Delete");
        this.removeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ManagerDialog.this.performRemoveConfiguration();
                ManagerDialog.this.updateControls();
            }
        });
        this.removeButton.setToolTipText("Delete the selected configuration");
        this.checkBoxViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ManagerDialog.this.changeButtonStatus(selection);
            }
        });
        this.checkBoxViewer.addCheckStateListener(new ICheckStateListener(){
            private boolean ignore = false;

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (this.ignore) {
                    return;
                }
                Object element = event.getElement();
                if (event.getChecked()) {
                    this.ignore = true;
                    ManagerDialog.this.checkBoxViewer.setAllChecked(false);
                    ManagerDialog.this.checkBoxViewer.setChecked(element, true);
                    this.ignore = false;
                }
                ManagerDialog.this.checkBoxViewer.setSelection((ISelection)new StructuredSelection(element));
            }
        });
        if (this.currentConfiguration != null) {
            this.checkBoxViewer.setChecked((Object)this.currentConfiguration, true);
        }
        return main;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.okButton = this.getButton(0);
        this.okButton.setText("Run");
        return control;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.changeButtonStatus((IStructuredSelection)this.checkBoxViewer.getSelection());
        return control;
    }

    private void changeButtonStatus(IStructuredSelection selection) {
        this.removeButton.setEnabled(!selection.isEmpty());
        this.editButton.setEnabled(!selection.isEmpty());
    }

    private FilterModel performCreateConfiguration() {
        FilterModel filterModel = new FilterModel(this.fFilterManager.getProcessAlgebraModel());
        this.validator.isEditing = false;
        Dialog filterModelDialog = filterModel.createDialogControl(this.getShell(), this.validator);
        if (filterModelDialog.open() == 0) {
            this.fFilterManager.filterModels.add(filterModel);
            return filterModel;
        }
        return null;
    }

    private void performRemoveConfiguration() {
        FilterModel current = this.getCurrentConfiguration();
        Assert.isNotNull((Object)current, (String)"Configuration cannot be null inside performRemoveConfiguration");
        this.fFilterManager.filterModels.remove(current);
    }

    private FilterModel performEditConfiguration(FilterModel current) {
        Assert.isNotNull((Object)current, (String)"Configuration cannot be null inside performEditConfiguration");
        FilterModel filterModel = new FilterModel(this.fFilterManager.getProcessAlgebraModel());
        XMLMemento memento = XMLMemento.createWriteRoot((String)"BASE");
        current.getMemento((IMemento)memento);
        filterModel.setMemento((IMemento)memento);
        this.validator.isEditing = true;
        Dialog filterModelDialog = filterModel.createDialogControl(this.getShell(), this.validator);
        if (filterModelDialog.open() == 0) {
            this.fFilterManager.filterModels.set(this.fFilterManager.filterModels.indexOf(current), filterModel);
            return filterModel;
        }
        return current;
    }

    private FilterModel getCurrentConfiguration() {
        IStructuredSelection selection = (IStructuredSelection)this.checkBoxViewer.getSelection();
        FilterModel configuration = (FilterModel)selection.getFirstElement();
        return configuration;
    }

    private void updateControls() {
        this.checkBoxViewer.refresh();
    }

    private class ConfigurationNameValidator
    implements IInputValidator {
        boolean isEditing;

        private ConfigurationNameValidator() {
        }

        public String isValid(String newText) {
            if (newText == null || newText.trim().equals("")) {
                return "Filter name cannot be empty";
            }
            if (!this.isEditing) {
                for (IFilterModel iFilterModel : ((ManagerDialog)ManagerDialog.this).fFilterManager.filterModels) {
                    if (!iFilterModel.getName().equals(newText)) continue;
                    return "Filter name already existing";
                }
            }
            return null;
        }
    }
}

