/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.internal;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import uk.ac.ed.inf.pepa.ctmc.derivation.FilterFactory;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpaceFilter;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraModel;
import uk.ac.ed.inf.pepa.eclipse.ui.internal.AbstractConfigurableStateSpaceFilter;
import uk.ac.ed.inf.pepa.eclipse.ui.internal.IFilterValidatorListener;

public class PatternMatchingFilter
extends AbstractConfigurableStateSpaceFilter {
    private static final String LABEL = "States ";
    private static final String AFFIRMED = "which match";
    private static final String NEGATED = "which do not match";
    private static final String TAG_PATTERN_MATCHING = "patternMatchingFilter";
    private static final String TAG_PATTERN = "pattern";
    private static final String TAG_NEGATION = "negation";
    private String pattern;
    private IFilterValidatorListener validator;

    public PatternMatchingFilter(IProcessAlgebraModel model) {
        super(model);
    }

    @Override
    public void createGUI(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(1808));
        Label label = new Label(main, 0);
        label.setText(LABEL);
        label.setLayoutData((Object)new GridData());
        Combo negationCombo = this.createNegationCombo(main);
        negationCombo.setLayoutData((Object)new GridData(768));
        Label stateSelection = new Label(main, 0);
        stateSelection.setText("Insert pattern:");
        stateSelection.setLayoutData((Object)new GridData());
        final Text text = new Text(main, 2048);
        text.setText(this.pattern == null ? "" : this.pattern);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PatternMatchingFilter.this.pattern = text.getText();
                PatternMatchingFilter.this.validate();
            }
        });
        text.setLayoutData((Object)new GridData(768));
    }

    private void validate() {
        String message = null;
        if (this.pattern == null || this.pattern.equals("")) {
            message = "Insert pattern";
        } else {
            String[] componentNames = this.fModel.getStateSpace().getComponentNames();
            String[] individualComponents = this.pattern.split(":");
            int i = 0;
            while (i < individualComponents.length) {
                String comp = individualComponents[i].trim();
                if (!comp.equals("*")) {
                    boolean found = false;
                    String[] stringArray = componentNames;
                    int n = componentNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String name = stringArray[n2];
                        if (name.equals(comp)) {
                            found = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!found) {
                        message = "Component " + comp + " does not exist";
                        break;
                    }
                }
                ++i;
            }
        }
        this.validator.filterValidated(message);
    }

    @Override
    protected String getAffirmedString() {
        return AFFIRMED;
    }

    @Override
    public String getLabel() {
        return LABEL + this.getDescription() + " " + this.getParameter();
    }

    @Override
    protected void getMemento(IMemento memento) {
        IMemento mem = memento.createChild(TAG_PATTERN_MATCHING);
        mem.putString(TAG_PATTERN, this.pattern);
        mem.putString(TAG_NEGATION, "" + this.negation);
    }

    @Override
    protected String getNegatedString() {
        return NEGATED;
    }

    @Override
    protected String getParameter() {
        return this.pattern;
    }

    @Override
    protected void setMemento(IMemento memento) {
        IMemento mem = memento.getChild(TAG_PATTERN_MATCHING);
        this.pattern = mem.getString(TAG_PATTERN);
        this.negation = Boolean.parseBoolean(mem.getString(TAG_NEGATION));
    }

    @Override
    public void setFilterValidatorListener(IFilterValidatorListener listener) {
        this.validator = listener;
        this.validate();
    }

    @Override
    protected IStateSpaceFilter doCreateFilter() {
        return FilterFactory.createPatternMatchingFilter((String)this.pattern);
    }
}

