/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.internal;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import uk.ac.ed.inf.pepa.ctmc.derivation.FilterFactory;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpaceFilter;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraModel;
import uk.ac.ed.inf.pepa.eclipse.ui.internal.AbstractConfigurableStateSpaceFilter;
import uk.ac.ed.inf.pepa.eclipse.ui.internal.IFilterValidatorListener;

public class SequentialComponentFilter
extends AbstractConfigurableStateSpaceFilter {
    private static final String AFFIRMED = "which are in state";
    private static final String NEGATED = "which are not in state";
    private static final String TAG_SEQUENTIAL_COMPONENT = "sequentialComponentFilter";
    private static final String TAG_NAME = "processName";
    private static final String TAG_NEGATION = "negation";
    private static final String TAG_NUMBER_OF_COPIES = "numberOfCopies";
    private static final String TAG_OPERATOR = "operator";
    private String topLevelComponentName;
    private String numberOfCopies = "1";
    private FilterFactory.Operator operator = FilterFactory.Operator.EQ;
    private Combo combo;
    private IFilterValidatorListener validator;
    private Combo operatorCombo;
    private Text numberOfCopiesText;

    public SequentialComponentFilter(IProcessAlgebraModel model) {
        super(model);
    }

    @Override
    protected void getMemento(IMemento memento) {
        IMemento mem = memento.createChild(TAG_SEQUENTIAL_COMPONENT);
        mem.putString(TAG_NAME, this.topLevelComponentName);
        mem.putString(TAG_NEGATION, "" + this.negation);
        mem.putString(TAG_NUMBER_OF_COPIES, this.numberOfCopies);
        mem.putString(TAG_OPERATOR, this.operator.name());
    }

    @Override
    protected void setMemento(IMemento memento) {
        IMemento mem = memento.getChild(TAG_SEQUENTIAL_COMPONENT);
        this.topLevelComponentName = mem.getString(TAG_NAME);
        this.negation = Boolean.parseBoolean(mem.getString(TAG_NEGATION));
        this.operator = FilterFactory.Operator.valueOf((String)mem.getString(TAG_OPERATOR));
        this.numberOfCopies = mem.getString(TAG_NUMBER_OF_COPIES);
    }

    @Override
    public void createGUI(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(1808));
        Label label = new Label(main, 0);
        label.setText("Sequential components");
        label.setLayoutData((Object)new GridData());
        Combo negationCombo = this.createNegationCombo(main);
        negationCombo.setLayoutData((Object)new GridData(768));
        Label stateSelection = new Label(main, 0);
        stateSelection.setText("Select state:");
        stateSelection.setLayoutData((Object)new GridData());
        Control other = this.createControl(main);
        other.setLayoutData((Object)new GridData(768));
        Label expressionSelection = new Label(main, 0);
        expressionSelection.setText("Number of copies:");
        expressionSelection.setLayoutData((Object)new GridData());
        Composite expressionComposite = new Composite(main, 0);
        expressionComposite.setLayoutData((Object)new GridData(768));
        GridLayout expressionLayout = new GridLayout();
        expressionLayout.numColumns = 2;
        expressionLayout.makeColumnsEqualWidth = false;
        expressionLayout.marginWidth = 0;
        expressionLayout.marginHeight = 0;
        expressionComposite.setLayout((Layout)expressionLayout);
        this.operatorCombo = new Combo(expressionComposite, 8);
        this.operatorCombo.setLayoutData((Object)new GridData());
        FilterFactory.Operator[] operatorArray = FilterFactory.Operator.values();
        int n = operatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            FilterFactory.Operator o = operatorArray[n2];
            this.operatorCombo.add(o.toString());
            this.operatorCombo.setData(o.toString(), (Object)o);
            ++n2;
        }
        this.operatorCombo.setText(this.operator.toString());
        this.operatorCombo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                SequentialComponentFilter.this.operator = (FilterFactory.Operator)SequentialComponentFilter.this.operatorCombo.getData(SequentialComponentFilter.this.operatorCombo.getText());
                SequentialComponentFilter.this.validate();
            }
        });
        this.numberOfCopiesText = new Text(expressionComposite, 133120);
        this.numberOfCopiesText.setLayoutData((Object)new GridData(768));
        this.numberOfCopiesText.setText(this.numberOfCopies);
        this.numberOfCopiesText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                SequentialComponentFilter.this.numberOfCopies = SequentialComponentFilter.this.numberOfCopiesText.getText();
                SequentialComponentFilter.this.validate();
            }
        });
    }

    private void validate() {
        if (this.topLevelComponentName == null) {
            this.validator.filterValidated("Choose local state");
            return;
        }
        int copies = 0;
        try {
            copies = Integer.parseInt(this.numberOfCopies);
        }
        catch (Exception exception) {
            this.validator.filterValidated("Insert a correct number of copies");
            return;
        }
        if (copies < 0) {
            this.validator.filterValidated("Number of copies cannot be negative");
            return;
        }
        this.validator.filterValidated(null);
    }

    protected Control createControl(Composite parent) {
        this.combo = new Combo(parent, 8);
        this.fillCombo(this.combo);
        if (this.topLevelComponentName != null) {
            this.combo.setText(this.topLevelComponentName);
        }
        this.combo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                SequentialComponentFilter.this.topLevelComponentName = SequentialComponentFilter.this.combo.getText();
                SequentialComponentFilter.this.validate();
            }
        });
        return this.combo;
    }

    private void fillCombo(Combo combo) {
        String[] stringArray = this.fModel.getStateSpace().getComponentNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            combo.add(s);
            ++n2;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append("negation:" + this.negation + ",");
        buf.append("reference:" + this.topLevelComponentName);
        buf.append("copies" + this.numberOfCopies);
        buf.append("operator:" + this.operator);
        return buf.toString();
    }

    @Override
    protected void dispose() {
        super.dispose();
        if (this.combo != null && !this.combo.isDisposed()) {
            this.combo.dispose();
        }
    }

    @Override
    protected String getAffirmedString() {
        return AFFIRMED;
    }

    @Override
    protected String getNegatedString() {
        return NEGATED;
    }

    @Override
    public String getParameter() {
        return this.topLevelComponentName;
    }

    @Override
    public String getLabel() {
        return "Sequential components " + this.getDescription() + " " + this.getParameter() + " (" + this.operator + " " + this.numberOfCopies + ")";
    }

    @Override
    public void setFilterValidatorListener(IFilterValidatorListener listener) {
        this.validator = listener;
        this.validate();
    }

    @Override
    protected IStateSpaceFilter doCreateFilter() {
        try {
            return FilterFactory.createSequentialComponentFilter((String)this.topLevelComponentName, (FilterFactory.Operator)this.operator, (int)Integer.parseInt(this.numberOfCopies));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

