/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.internal;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import uk.ac.ed.inf.pepa.ctmc.derivation.FilterFactory;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpaceFilter;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraModel;
import uk.ac.ed.inf.pepa.eclipse.ui.internal.AbstractConfigurableStateSpaceFilter;
import uk.ac.ed.inf.pepa.eclipse.ui.internal.IFilterValidatorListener;

public class SteadyStateProbabilityFilter
extends AbstractConfigurableStateSpaceFilter {
    private static final String AFFIRMED = "is greater than";
    private static final String NEGATED = "is less or equal than";
    private static final String TAG_THRESHOLD_FILTER = "thresholdFilter";
    private static final String TAG_NEGATION = "negation";
    private static final String TAG_THRESHOLD_VALUE = "threshold";
    private Text thresholdText;
    private double thresholdValue = 0.0;
    private IFilterValidatorListener validatorListener;

    public SteadyStateProbabilityFilter(IProcessAlgebraModel model) {
        super(model);
    }

    @Override
    public void createGUI(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(1808));
        Label label = new Label(main, 0);
        label.setText("States whose steady-state probability");
        label.setLayoutData((Object)new GridData());
        Combo negationCombo = this.createNegationCombo(main);
        negationCombo.setLayoutData((Object)new GridData(768));
        Label stateSelection = new Label(main, 0);
        stateSelection.setText("Enter steady-state probability:");
        stateSelection.setLayoutData((Object)new GridData());
        Control other = this.createControl(main);
        other.setLayoutData((Object)new GridData(768));
    }

    protected Control createControl(Composite parent) {
        if (this.thresholdText == null || this.thresholdText.isDisposed()) {
            this.thresholdText = this._createThresholdText(parent);
        }
        return this.thresholdText;
    }

    private Text _createThresholdText(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setText("" + this.thresholdValue);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SteadyStateProbabilityFilter.this.validate();
            }
        });
        return text;
    }

    private void validate() {
        String message = null;
        try {
            this.thresholdValue = Double.parseDouble(this.thresholdText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            message = "Insert a valid number";
        }
        if (this.thresholdValue < 0.0) {
            message = "Negative values not allowed";
        }
        if (this.thresholdValue > 1.0) {
            message = "Values greater than 1 not allowed";
        }
        this.validatorListener.filterValidated(message);
    }

    @Override
    protected String getAffirmedString() {
        return AFFIRMED;
    }

    @Override
    protected void getMemento(IMemento memento) {
        IMemento mem = memento.createChild(TAG_THRESHOLD_FILTER);
        mem.putString(TAG_THRESHOLD_VALUE, "" + this.thresholdValue);
        mem.putString(TAG_NEGATION, "" + this.negation);
    }

    @Override
    protected String getNegatedString() {
        return NEGATED;
    }

    @Override
    protected void setMemento(IMemento memento) {
        IMemento mem = memento.getChild(TAG_THRESHOLD_FILTER);
        try {
            this.thresholdValue = Double.parseDouble(mem.getString(TAG_THRESHOLD_VALUE));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalStateException("Threshold value error when recovering from a memento");
        }
        this.negation = Boolean.parseBoolean(mem.getString(TAG_NEGATION));
    }

    @Override
    public String getParameter() {
        return String.valueOf(this.thresholdValue);
    }

    @Override
    public String getLabel() {
        return "States whose steady-state probability " + this.getDescription() + " " + this.getParameter();
    }

    @Override
    public void setFilterValidatorListener(IFilterValidatorListener listener) {
        this.validatorListener = listener;
        this.validate();
    }

    @Override
    protected IStateSpaceFilter doCreateFilter() {
        return FilterFactory.createSteadyStateThreshold((FilterFactory.Operator)FilterFactory.Operator.GT, (double)this.thresholdValue);
    }
}

