/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.internal;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import uk.ac.ed.inf.pepa.ctmc.derivation.FilterFactory;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpaceFilter;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraModel;
import uk.ac.ed.inf.pepa.eclipse.ui.internal.AbstractConfigurableStateSpaceFilter;
import uk.ac.ed.inf.pepa.eclipse.ui.internal.IFilterValidatorListener;

public class UnnamedProcessesFilter
extends AbstractConfigurableStateSpaceFilter {
    private static final String LABEL = "States ";
    private static final String AFFIRMED = "which contain unnamed processes";
    private static final String NEGATED = "which do not contain unnamed processes";
    private static final String TAG_UNNAMED = "unnamedProcessesFilter";
    private static final String TAG_NEGATION = "negation";

    public UnnamedProcessesFilter(IProcessAlgebraModel model) {
        super(model);
    }

    @Override
    public void createGUI(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(1808));
        Label label = new Label(main, 0);
        label.setText(LABEL);
        label.setLayoutData((Object)new GridData());
        Combo negationCombo = this.createNegationCombo(main);
        negationCombo.setLayoutData((Object)new GridData(768));
    }

    @Override
    protected String getAffirmedString() {
        return AFFIRMED;
    }

    @Override
    public String getLabel() {
        return LABEL + this.getDescription();
    }

    @Override
    protected void getMemento(IMemento memento) {
        IMemento mem = memento.createChild(TAG_UNNAMED);
        mem.putString(TAG_NEGATION, "" + this.negation);
    }

    @Override
    protected String getNegatedString() {
        return NEGATED;
    }

    @Override
    protected String getParameter() {
        return "";
    }

    @Override
    protected void setMemento(IMemento memento) {
        IMemento mem = memento.getChild(TAG_UNNAMED);
        this.negation = Boolean.parseBoolean(mem.getString(TAG_NEGATION));
    }

    @Override
    public void setFilterValidatorListener(IFilterValidatorListener listener) {
        listener.filterValidated(null);
    }

    @Override
    protected IStateSpaceFilter doCreateFilter() {
        return FilterFactory.createUnnamedStatesFilter();
    }
}

