/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.internal;

import uk.ac.ed.inf.common.ui.plotting.data.InfoWithAxes;
import uk.ac.ed.inf.common.ui.plotting.data.InfoWithoutAxes;
import uk.ac.ed.inf.common.ui.plotting.data.Series;
import uk.ac.ed.inf.pepa.ctmc.LocalState;
import uk.ac.ed.inf.pepa.ctmc.PopulationLevelResult;
import uk.ac.ed.inf.pepa.ctmc.SequentialComponent;
import uk.ac.ed.inf.pepa.ctmc.ThroughputResult;

public class Utilities {
    public static InfoWithoutAxes createGraphData(SequentialComponent utilisation) {
        InfoWithoutAxes info = new InfoWithoutAxes();
        info.setGraphTitle(utilisation.getName());
        info.setHas3DEffect(true);
        LocalState[] states = utilisation.getLocalStates();
        String[] categories = new String[states.length];
        double[] values = new double[states.length];
        int i = 0;
        while (i < states.length) {
            categories[i] = states[i].getName();
            values[i] = states[i].getUtilisation();
            ++i;
        }
        info.setCategories(categories);
        info.setValues(values);
        info.setShowLegend(true);
        return info;
    }

    public static InfoWithAxes createGraphData(ThroughputResult[] throughput) {
        InfoWithAxes info = new InfoWithAxes();
        info.setGraphTitle("Throughput");
        info.setHas3DEffect(true);
        String[] categories = new String[throughput.length];
        double[] values = new double[throughput.length];
        int i = 0;
        while (i < throughput.length) {
            categories[i] = throughput[i].getActionType();
            values[i] = throughput[i].getThroughput();
            ++i;
        }
        info.setCategories(categories);
        info.setXSeries(Series.create((double[])new double[0], (String)"Action type"));
        info.getYSeries().add(Series.create((double[])values, (String)""));
        return info;
    }

    public static InfoWithAxes createGraphData(PopulationLevelResult[] population) {
        InfoWithAxes info = new InfoWithAxes();
        info.setGraphTitle("Population");
        info.setHas3DEffect(true);
        String[] categories = new String[population.length];
        double[] values = new double[population.length];
        int i = 0;
        while (i < population.length) {
            categories[i] = population[i].getName();
            values[i] = population[i].getMean();
            ++i;
        }
        info.setCategories(categories);
        info.setXSeries(Series.create((double[])new double[0], (String)"Population"));
        info.getYSeries().add(Series.create((double[])values, (String)""));
        return info;
    }
}

