/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.largescale;

import java.util.Formatter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.eclipse.core.PepatoProgressMonitorAdapter;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.AnalysisJob;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.DisplayAction;
import uk.ac.ed.inf.pepa.largescale.IParametricDerivationGraph;
import uk.ac.ed.inf.pepa.largescale.IPointEstimator;
import uk.ac.ed.inf.pepa.largescale.simulation.IStatisticsCollector;
import uk.ac.ed.inf.pepa.ode.DifferentialAnalysisException;
import uk.ac.ed.inf.pepa.ode.SteadyStateRoutine;

public class AnalysisJobFluidSteadyState
extends AnalysisJob {
    private double[] results = null;
    private SteadyStateRoutine routine;

    public AnalysisJobFluidSteadyState(String name, IParametricDerivationGraph derivationGraph, OptionMap map, IPointEstimator[] estimators, IStatisticsCollector[] collectors, String[] labels) {
        super(name, derivationGraph, map, estimators, collectors, labels);
    }

    @Override
    protected IStatus doRun(final org.eclipse.core.runtime.IProgressMonitor monitor) {
        this.routine = new SteadyStateRoutine(this.optionMap, this.derivationGraph);
        try {
            this.routine.obtainSteadyState((IProgressMonitor)new PepatoProgressMonitorAdapter(monitor, "ODE integration"){
                private long tic;
                private int units;
                private boolean measuring;
                private int maxUnits;

                public void beginTask(int amount) {
                    super.beginTask(amount);
                    this.tic = System.currentTimeMillis();
                    this.units = 0;
                    this.measuring = true;
                }

                public void done() {
                    this.notifyProgress();
                    super.done();
                }

                public void worked(int amount) {
                    super.worked(amount);
                    if (this.measuring) {
                        ++this.units;
                        if (System.currentTimeMillis() - this.tic > 800L) {
                            this.maxUnits = this.units;
                            this.measuring = false;
                        }
                    } else {
                        --this.units;
                        if (this.units == 0) {
                            this.notifyProgress();
                            this.units = this.maxUnits;
                        }
                    }
                }

                private void notifyProgress() {
                    monitor.subTask("" + new Formatter().format("Time: %6.3f  Convergence: %e", AnalysisJobFluidSteadyState.this.routine.getTimePoint(), AnalysisJobFluidSteadyState.this.routine.getConvergenceNorm()));
                }
            });
        }
        catch (DifferentialAnalysisException e) {
            if (e.getKind() != 1) {
                return new Status(4, "uk.ac.ed.inf.pepa.eclipse.ui", "An error occurred during steady-state analysis", (Throwable)e);
            }
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
        try {
            this.computeResults(this.routine.getTimePoint(), this.routine.getSolution());
        }
        catch (DifferentialAnalysisException e) {
            return new Status(4, "uk.ac.ed.inf.pepa.eclipse.ui", "An error occurred during steady-state analysis", (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private void computeResults(double timePoint, double[] solution) throws DifferentialAnalysisException {
        double[] estimates = new double[this.estimators.length];
        this.results = new double[this.collectors.length];
        int i = 0;
        while (i < estimates.length) {
            estimates[i] = this.estimators[i].computeEstimate(timePoint, solution);
            ++i;
        }
        int j = 0;
        while (j < this.collectors.length) {
            this.results[j] = this.collectors[j].computeObservation(estimates);
            ++j;
        }
    }

    @Override
    public DisplayAction getDisplayAction() {
        double tolerance = (Double)this.optionMap.get((Object)"ode.steady-state.norm");
        final boolean showWarning = this.routine.getConvergenceNorm() > tolerance;
        return new DisplayAction("Model solved", true){

            public void run() {
                String title = null;
                String message = "Runtime: " + AnalysisJobFluidSteadyState.this.elapsed + "ms.\n\n";
                int i = 0;
                while (i < AnalysisJobFluidSteadyState.this.results.length) {
                    message = String.valueOf(message) + AnalysisJobFluidSteadyState.this.labels[i] + " : " + new Formatter().format("%6f\n", AnalysisJobFluidSteadyState.this.results[i]);
                    ++i;
                }
                if (showWarning) {
                    title = "Unaccurate estimate";
                    message = "The current steady-state convergence norm is too high: " + new Formatter().format("%e.\n", AnalysisJobFluidSteadyState.this.routine.getConvergenceNorm()) + "Try to increase integration time.\n" + message;
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
                } else {
                    title = "Steady-state analysis";
                    message = String.valueOf(message) + new Formatter().format("Convergence norm is: %e\nSteady state detetected at %5.3f time units", AnalysisJobFluidSteadyState.this.routine.getConvergenceNorm(), AnalysisJobFluidSteadyState.this.routine.getTimePoint());
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
                }
            }
        };
    }
}

