/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.largescale;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import uk.ac.ed.inf.common.ui.plotting.IChart;
import uk.ac.ed.inf.common.ui.plotting.Plotting;
import uk.ac.ed.inf.common.ui.plotting.data.InfoWithAxes;
import uk.ac.ed.inf.common.ui.plotting.data.Series;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.DoubleArray;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.eclipse.core.PepatoProgressMonitorAdapter;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.AnalysisJob;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.DisplayAction;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.PerformanceMetricDialog;
import uk.ac.ed.inf.pepa.largescale.IParametricDerivationGraph;
import uk.ac.ed.inf.pepa.largescale.IPointEstimator;
import uk.ac.ed.inf.pepa.largescale.simulation.IStatisticsCollector;
import uk.ac.ed.inf.pepa.ode.DifferentialAnalysisException;
import uk.ac.ed.inf.pepa.ode.IODESolver;
import uk.ac.ed.inf.pepa.ode.ISolutionRoutineCallback;
import uk.ac.ed.inf.pepa.ode.ODESolverFactory;

public class AnalysisJobFluidTransient
extends AnalysisJob {
    private DoubleArray times;
    private DoubleArray[] results;

    public AnalysisJobFluidTransient(String name, IParametricDerivationGraph derivationGraph, OptionMap map, IPointEstimator[] estimators, IStatisticsCollector[] collectors, String[] labels) {
        super(name, derivationGraph, map, estimators, collectors, labels);
    }

    @Override
    protected IStatus doRun(org.eclipse.core.runtime.IProgressMonitor monitor) {
        IODESolver solver = ODESolverFactory.create((IParametricDerivationGraph)this.derivationGraph);
        this.times = new DoubleArray(100);
        this.results = new DoubleArray[this.estimators.length];
        int i = 0;
        while (i < this.results.length) {
            this.results[i] = new DoubleArray(100);
            ++i;
        }
        ISolutionRoutineCallback callback = new ISolutionRoutineCallback(){

            public void timePointComputed(double timePoint, double[] solution) throws DifferentialAnalysisException {
                AnalysisJobFluidTransient.this.times.add(timePoint);
                int i = 0;
                while (i < AnalysisJobFluidTransient.this.estimators.length) {
                    AnalysisJobFluidTransient.this.results[i].add(AnalysisJobFluidTransient.this.estimators[i].computeEstimate(timePoint, solution));
                    ++i;
                }
            }
        };
        try {
            solver.solve(this.optionMap, callback, (IProgressMonitor)new PepatoProgressMonitorAdapter(monitor, this.getName()));
        }
        catch (DifferentialAnalysisException e) {
            return new Status(4, "uk.ac.ed.inf.pepa.eclipse.ui", "An error occurred during the numerical integration", (Throwable)e);
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    @Override
    public DisplayAction getDisplayAction() {
        return new DisplayAction("", false){

            public void run() {
                InfoWithAxes info = new InfoWithAxes();
                info.setGraphTitle(AnalysisJobFluidTransient.this.getName());
                info.setHas3DEffect(false);
                info.setShowLegend(true);
                info.setShowMarkers(false);
                info.setXSeries(Series.create((double[])AnalysisJobFluidTransient.this.times.toArray(), (String)"Time"));
                int i = 0;
                while (i < AnalysisJobFluidTransient.this.estimators.length) {
                    Series series = Series.create((double[])AnalysisJobFluidTransient.this.results[i].toArray(), (String)AnalysisJobFluidTransient.this.labels[i]);
                    info.getYSeries().add(series);
                    ++i;
                }
                IChart chart = Plotting.getPlottingTools().createTimeSeriesChart(info);
                PerformanceMetricDialog.display(chart);
            }
        };
    }
}

