/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.largescale;

import java.util.Formatter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.eclipse.core.PepatoProgressMonitorAdapter;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.AnalysisJob;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.DisplayAction;
import uk.ac.ed.inf.pepa.largescale.IParametricDerivationGraph;
import uk.ac.ed.inf.pepa.largescale.IPointEstimator;
import uk.ac.ed.inf.pepa.largescale.simulation.IStatisticsCollector;
import uk.ac.ed.inf.pepa.largescale.simulation.SimulationException;
import uk.ac.ed.inf.pepa.largescale.simulation.SteadyStateSimulation;

public class AnalysisJobSimulationSteadyState
extends AnalysisJob {
    protected SteadyStateSimulation simulation;

    public AnalysisJobSimulationSteadyState(String name, IParametricDerivationGraph derivationGraph, OptionMap map, IPointEstimator[] estimators, IStatisticsCollector[] collectors, String[] labels) {
        super(name, derivationGraph, map, estimators, collectors, labels);
        this.simulation = new SteadyStateSimulation(this.optionMap, derivationGraph, estimators, collectors);
    }

    @Override
    protected IStatus doRun(final org.eclipse.core.runtime.IProgressMonitor monitor) {
        try {
            this.simulation.doSimulation((IProgressMonitor)new PepatoProgressMonitorAdapter(monitor, "Steady-state simulation"){
                private int batches;
                {
                    super($anonymous0, $anonymous1);
                    this.batches = 0;
                }

                public void worked(int worked) {
                    super.worked(worked);
                    ++this.batches;
                    double convergence = AnalysisJobSimulationSteadyState.this.simulation.getCurrentConfidenceError();
                    String message = "Current batch: " + this.batches + ". Confidence Interval: ";
                    message = !Double.isInfinite(convergence) ? String.valueOf(message) + new Formatter().format("%4f%%", convergence) : String.valueOf(message) + "-";
                    monitor.subTask(message);
                }
            });
        }
        catch (SimulationException e) {
            return new Status(4, "uk.ac.ed.inf.pepa.eclipse.ui", "An error occurred during steady-state simulation", (Throwable)e);
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    @Override
    public DisplayAction getDisplayAction() {
        return new DisplayAction("Simulation results", true){

            public void run() {
                StringBuffer message = new StringBuffer();
                message.append("Runtime: " + AnalysisJobSimulationSteadyState.this.elapsed + " ms.\n\nResults:\n");
                int i = 0;
                while (i < AnalysisJobSimulationSteadyState.this.simulation.getNumberOfObservers()) {
                    double[] results = new double[2];
                    double cl = AnalysisJobSimulationSteadyState.this.simulation.getRequiredConfidenceLevel();
                    AnalysisJobSimulationSteadyState.this.simulation.confidenceInterval(i, 0, results);
                    message.append("***\nMeasure: " + AnalysisJobSimulationSteadyState.this.labels[i] + "\n");
                    message.append(new Formatter().format("Average: %6f\n", results[0]));
                    double ci = results[1] / results[0] * 100.0;
                    message.append(new Formatter().format("%2.2f%% Confidence Interval: %3.3f%%\n", cl * 100.0, ci));
                    message.append(new Formatter().format("Lag-1 Correlation: %e\n", AnalysisJobSimulationSteadyState.this.simulation.computeLagOneAutoCorrelation(i)));
                    ++i;
                }
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Steady-state Simulation Results", (String)message.toString());
            }
        };
    }
}

