/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.largescale;

import java.util.Formatter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import uk.ac.ed.inf.common.ui.plotting.IChart;
import uk.ac.ed.inf.common.ui.plotting.Plotting;
import uk.ac.ed.inf.common.ui.plotting.data.ConfidenceSeries;
import uk.ac.ed.inf.common.ui.plotting.data.InfoWithAxes;
import uk.ac.ed.inf.common.ui.plotting.data.Series;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.eclipse.core.PepatoProgressMonitorAdapter;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.AnalysisJob;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.DisplayAction;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.PerformanceMetricDialog;
import uk.ac.ed.inf.pepa.largescale.IParametricDerivationGraph;
import uk.ac.ed.inf.pepa.largescale.IPointEstimator;
import uk.ac.ed.inf.pepa.largescale.simulation.IStatisticsCollector;
import uk.ac.ed.inf.pepa.largescale.simulation.SimulationException;
import uk.ac.ed.inf.pepa.largescale.simulation.TransientSimulation;

public class AnalysisJobSimulationTransient
extends AnalysisJob {
    private TransientSimulation simulation;

    public AnalysisJobSimulationTransient(String name, IParametricDerivationGraph derivationGraph, OptionMap map, IPointEstimator[] estimators, IStatisticsCollector[] collectors, String[] labels) {
        super(name, derivationGraph, map, estimators, collectors, labels);
        this.simulation = new TransientSimulation(this.optionMap, derivationGraph, estimators, collectors);
    }

    @Override
    protected IStatus doRun(final org.eclipse.core.runtime.IProgressMonitor monitor) {
        try {
            this.simulation.doSimulation((IProgressMonitor)new PepatoProgressMonitorAdapter(monitor, "Transient simulation"){
                private int replications;
                {
                    super($anonymous0, $anonymous1);
                    this.replications = 0;
                }

                public void worked(int worked) {
                    super.worked(worked);
                    ++this.replications;
                    monitor.subTask(this.getMessage());
                }

                private String getMessage() {
                    double convergence = AnalysisJobSimulationTransient.this.simulation.getCurrentConfidenceError();
                    String message = "Replications completed: " + this.replications + ". Confidence Interval: ";
                    message = !Double.isInfinite(convergence) ? String.valueOf(message) + new Formatter().format("%4f%%", convergence) : String.valueOf(message) + "-";
                    return message;
                }
            });
        }
        catch (SimulationException e) {
            return new Status(4, "uk.ac.ed.inf.pepa.eclipse.ui", "A problem occurred during transient simulation", (Throwable)e);
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    @Override
    public DisplayAction getDisplayAction() {
        return new DisplayAction("Results", false){

            public void run() {
                InfoWithAxes info = new InfoWithAxes();
                info.setGraphTitle(AnalysisJobSimulationTransient.this.getName());
                info.setHas3DEffect(false);
                info.setShowLegend(true);
                info.setShowMarkers(false);
                info.setXSeries(Series.create((double[])AnalysisJobSimulationTransient.this.simulation.getTimes(), (String)"Time"));
                if (AnalysisJobSimulationTransient.this.simulation.canComputeConfidenceInterval()) {
                    this.averagesAndRadii(info);
                } else {
                    this.onlyAverages(info);
                }
                IChart chart = Plotting.getPlottingTools().createTimeSeriesChart(info);
                PerformanceMetricDialog.display(chart);
            }

            private void onlyAverages(InfoWithAxes info) {
                int i = 0;
                while (i < AnalysisJobSimulationTransient.this.simulation.getNumberOfObservers()) {
                    double[] results = AnalysisJobSimulationTransient.this.simulation.getAverages(i);
                    Series series = Series.create((double[])results, (String)AnalysisJobSimulationTransient.this.labels[i]);
                    info.getYSeries().add(series);
                    ++i;
                }
            }

            private void averagesAndRadii(InfoWithAxes info) {
                double[] avg = new double[AnalysisJobSimulationTransient.this.simulation.getNumberOfTimePoints()];
                double[] radii = new double[AnalysisJobSimulationTransient.this.simulation.getNumberOfTimePoints()];
                int i = 0;
                while (i < AnalysisJobSimulationTransient.this.simulation.getNumberOfObservers()) {
                    AnalysisJobSimulationTransient.this.simulation.averagesAndRadii(i, avg, radii);
                    ConfidenceSeries series = ConfidenceSeries.create((double[])avg, (double[])radii, (String)AnalysisJobSimulationTransient.this.labels[i], (double)AnalysisJobSimulationTransient.this.simulation.getRequiredConfidenceLevel());
                    info.getYSeries().add(series);
                    ++i;
                }
            }
        };
    }
}

