/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.largescale;

import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.AnalysisJob;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.AnalysisJobFluidSteadyState;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.AnalysisJobSimulationSteadyState;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.PerformanceMetricDialog;
import uk.ac.ed.inf.pepa.largescale.AverageResponseTimeCalculation;
import uk.ac.ed.inf.pepa.largescale.IParametricDerivationGraph;
import uk.ac.ed.inf.pepa.largescale.IPointEstimator;
import uk.ac.ed.inf.pepa.largescale.ISequentialComponent;
import uk.ac.ed.inf.pepa.largescale.expressions.Coordinate;
import uk.ac.ed.inf.pepa.largescale.simulation.AverageResponseTimeCollector;
import uk.ac.ed.inf.pepa.largescale.simulation.IStatisticsCollector;

public class AverageResponseTimeDialog
extends PerformanceMetricDialog {
    private CheckboxTreeViewer viewer;
    private ViewerFilter filter = new ViewerFilter(){

        public boolean select(Viewer filteredViewer, Object parentElement, Object element) {
            if (element instanceof ISequentialComponent || AverageResponseTimeDialog.this.viewer.getChecked(element)) {
                return true;
            }
            String label = null;
            if (element instanceof Integer) {
                label = AverageResponseTimeDialog.this.fDerivationGraph.getSymbolGenerator().getProcessLabel(AverageResponseTimeDialog.this.fDerivationGraph.getProcessMappings()[(Integer)element]);
            }
            return label.contains(AverageResponseTimeDialog.this.filterText.getText());
        }
    };

    public AverageResponseTimeDialog(boolean isFluid, Shell parentShell, IParametricDerivationGraph derivationGraph, IPepaModel model) {
        super(false, isFluid, parentShell, derivationGraph, model);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.enableOKButton();
        this.setTitle("Average response time");
        return control;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Average response time");
    }

    @Override
    protected StructuredViewer createViewer(Composite composite) {
        Label actions = new Label(composite, 0);
        actions.setText("Select local state in the passage");
        GridData actionsData = new GridData(768);
        actionsData.horizontalSpan = 2;
        actions.setLayoutData((Object)actionsData);
        GridData checkListData = new GridData(1808);
        checkListData.horizontalSpan = 2;
        this.viewer = new CheckboxTreeViewer(composite, 0);
        this.viewer.getTree().setLayoutData((Object)checkListData);
        this.viewer.setContentProvider((IContentProvider)new ResponseTimeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ISequentialComponent) {
                    return ((ISequentialComponent)element).getName();
                }
                if (element instanceof Integer) {
                    return AverageResponseTimeDialog.this.fDerivationGraph.getSymbolGenerator().getProcessLabel(AverageResponseTimeDialog.this.fDerivationGraph.getProcessMappings()[(Integer)element]);
                }
                return super.getText(element);
            }
        });
        this.viewer.setInput((Object)this.fDerivationGraph.getSequentialComponents());
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() instanceof ISequentialComponent && event.getChecked()) {
                    AverageResponseTimeDialog.this.viewer.setChecked(event.getElement(), false);
                }
                AverageResponseTimeDialog.this.enableOKButton();
            }
        });
        return this.viewer;
    }

    @Override
    protected boolean isOKButtonEnabled() {
        ResponseTimeContentProvider provider = (ResponseTimeContentProvider)this.viewer.getContentProvider();
        ISequentialComponent checkedComponent = null;
        ISequentialComponent[] iSequentialComponentArray = this.fDerivationGraph.getSequentialComponents();
        int n = iSequentialComponentArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISequentialComponent c = iSequentialComponentArray[n2];
            Object[] objectArray = provider.getChildren(c);
            int n3 = objectArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Object child = objectArray[n4];
                if (this.viewer.getChecked(child)) {
                    if (checkedComponent == null) {
                        checkedComponent = c;
                    } else if (checkedComponent != c) {
                        return false;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        boolean isOkEnabled = super.isOKButtonEnabled() && checkedComponent != null;
        return isOkEnabled;
    }

    @Override
    protected String getDialogTitle() {
        return "Average response time";
    }

    protected IPointEstimator[] getPerformanceMetrics() {
        int[] insystem = new int[this.viewer.getCheckedElements().length];
        int i = 0;
        while (i < insystem.length) {
            insystem[i] = (Integer)this.viewer.getCheckedElements()[i];
            ++i;
        }
        ISequentialComponent c = (ISequentialComponent)((ResponseTimeContentProvider)this.viewer.getContentProvider()).getParent(this.viewer.getCheckedElements()[0]);
        int j = 0;
        while (j < this.fDerivationGraph.getSequentialComponents().length) {
            if (this.fDerivationGraph.getSequentialComponents()[j] == c) break;
            ++j;
        }
        AverageResponseTimeCalculation art = new AverageResponseTimeCalculation(j, insystem, this.fDerivationGraph);
        return new IPointEstimator[]{art.getUsersInSystemEstimator(), art.getIncomingThroughputEstimator()};
    }

    @Override
    protected AnalysisJob getAnalysisJob() {
        if (this.fSolverOptionsHandler.isTransient()) {
            throw new IllegalStateException("Cannot request a transient analysis with average response time");
        }
        IStatisticsCollector[] collectors = new IStatisticsCollector[]{new AverageResponseTimeCollector(0, 1)};
        String[] labels = new String[]{"Average response time"};
        if (this.isFluid()) {
            return new AnalysisJobFluidSteadyState("Average response time", this.fDerivationGraph, this.fOptionMap, this.getPerformanceMetrics(), collectors, labels);
        }
        return new AnalysisJobSimulationSteadyState("Average response time", this.fDerivationGraph, this.fOptionMap, this.getPerformanceMetrics(), collectors, labels);
    }

    @Override
    protected String getViewerHeader() {
        return "Average response time";
    }

    @Override
    protected ViewerFilter getViewerFilter() {
        return this.filter;
    }

    @Override
    protected void addOptions(Composite composite) {
    }

    private class ResponseTimeContentProvider
    implements ITreeContentProvider {
        private ResponseTimeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ISequentialComponent) {
                Set mapping = ((ISequentialComponent)parentElement).getComponentMapping();
                Object[] children = new Integer[mapping.size()];
                int i = 0;
                for (Map.Entry entry : mapping) {
                    children[i++] = ((Coordinate)entry.getValue()).getCoordinate();
                }
                return children;
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof ISequentialComponent[]) {
                return null;
            }
            if (element instanceof ISequentialComponent) {
                return AverageResponseTimeDialog.this.fDerivationGraph.getSequentialComponents();
            }
            if (element instanceof Integer) {
                ISequentialComponent[] iSequentialComponentArray = AverageResponseTimeDialog.this.fDerivationGraph.getSequentialComponents();
                int n = iSequentialComponentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ISequentialComponent c = iSequentialComponentArray[n2];
                    for (Map.Entry entry : c.getComponentMapping()) {
                        if (((Coordinate)entry.getValue()).getCoordinate() != ((Integer)element).intValue()) continue;
                        return c;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return !(element instanceof Integer);
        }

        public Object[] getElements(Object inputElement) {
            return AverageResponseTimeDialog.this.fDerivationGraph.getSequentialComponents();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

