/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.largescale;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.ChecklistPerformanceMetricDialog;
import uk.ac.ed.inf.pepa.largescale.CapacityUtilisationCalculation;
import uk.ac.ed.inf.pepa.largescale.IParametricDerivationGraph;
import uk.ac.ed.inf.pepa.largescale.IPointEstimator;
import uk.ac.ed.inf.pepa.largescale.ISequentialComponent;

public class CapacityUtilisationDialog
extends ChecklistPerformanceMetricDialog {
    public CapacityUtilisationDialog(boolean isFluid, Shell parentShell, IParametricDerivationGraph derivationGraph, IPepaModel model) {
        super(true, isFluid, parentShell, derivationGraph, model);
    }

    @Override
    protected String getViewerHeader() {
        return "Select sequential component";
    }

    @Override
    protected String getDialogTitle() {
        return "Capacity Utilisation Analysis";
    }

    @Override
    ITableLabelProvider getProvider() {
        return new CapacityUtilisationProvider();
    }

    @Override
    String getShellTitle() {
        return this.getDialogTitle();
    }

    @Override
    Object getViewerInput() {
        Integer[] values = new Integer[this.fDerivationGraph.getSequentialComponents().length];
        int i = 0;
        while (i < values.length) {
            values[i] = i;
            ++i;
        }
        return values;
    }

    @Override
    protected String[] getLabels() {
        Object[] checkedElements = this.viewer.getCheckedElements();
        String[] labels = new String[checkedElements.length];
        int i = 0;
        while (i < checkedElements.length) {
            labels[i] = this.fDerivationGraph.getSequentialComponents()[(Integer)checkedElements[i]].getName();
            ++i;
        }
        return labels;
    }

    @Override
    protected IPointEstimator[] getPerformanceMetrics() {
        Object[] checkedElements = this.viewer.getCheckedElements();
        CapacityUtilisationCalculation[] calculators = new CapacityUtilisationCalculation[checkedElements.length];
        int i = 0;
        while (i < checkedElements.length) {
            calculators[i] = new CapacityUtilisationCalculation(((Integer)checkedElements[i]).intValue(), this.fDerivationGraph);
            ++i;
        }
        return calculators;
    }

    private class CapacityUtilisationProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private CapacityUtilisationProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof Integer) {
                    int index = (Integer)element;
                    ISequentialComponent c = CapacityUtilisationDialog.this.fDerivationGraph.getSequentialComponents()[index];
                    return c.getName();
                }
                throw new IllegalArgumentException();
            }
            return null;
        }
    }
}

