/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.largescale;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.AnalysisJob;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.AnalysisJobFluidSteadyState;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.AnalysisJobFluidTransient;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.AnalysisJobSimulationSteadyState;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.AnalysisJobSimulationTransient;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.PerformanceMetricDialog;
import uk.ac.ed.inf.pepa.largescale.IParametricDerivationGraph;
import uk.ac.ed.inf.pepa.largescale.IPointEstimator;
import uk.ac.ed.inf.pepa.largescale.simulation.DefaultCollector;
import uk.ac.ed.inf.pepa.largescale.simulation.IStatisticsCollector;

public abstract class ChecklistPerformanceMetricDialog
extends PerformanceMetricDialog {
    protected CheckboxTableViewer viewer;
    private ViewerFilter filter = new ViewerFilter(){

        public boolean select(Viewer filteredViewer, Object parentElement, Object element) {
            if (ChecklistPerformanceMetricDialog.this.viewer.getChecked(element)) {
                return true;
            }
            String label = ChecklistPerformanceMetricDialog.this.getProvider().getColumnText(element, 0);
            return label.contains(ChecklistPerformanceMetricDialog.this.filterText.getText());
        }
    };

    public ChecklistPerformanceMetricDialog(boolean supportsTransient, boolean isFluid, Shell parentShell, IParametricDerivationGraph derivationGraph, IPepaModel model) {
        super(supportsTransient, isFluid, parentShell, derivationGraph, model);
    }

    abstract String getShellTitle();

    abstract ITableLabelProvider getProvider();

    abstract Object getViewerInput();

    @Override
    protected AnalysisJob getAnalysisJob() {
        String[] labels = this.getLabels();
        IPointEstimator[] performanceMetrics = this.getPerformanceMetrics();
        IStatisticsCollector[] collectors = DefaultCollector.create((IPointEstimator[])performanceMetrics);
        AnalysisJob job = null;
        if (this.isFluid() && this.fSolverOptionsHandler.isTransient()) {
            job = new AnalysisJobFluidTransient(this.getDialogTitle(), this.fDerivationGraph, this.fOptionMap, performanceMetrics, collectors, labels);
        } else if (this.isFluid() && !this.fSolverOptionsHandler.isTransient()) {
            job = new AnalysisJobFluidSteadyState(this.getDialogTitle(), this.fDerivationGraph, this.fOptionMap, performanceMetrics, collectors, labels);
        } else if (!this.isFluid() && this.fSolverOptionsHandler.isTransient()) {
            job = new AnalysisJobSimulationTransient(this.getDialogTitle(), this.fDerivationGraph, this.fOptionMap, performanceMetrics, collectors, labels);
        } else if (!this.isFluid() && !this.fSolverOptionsHandler.isTransient()) {
            job = new AnalysisJobSimulationSteadyState(this.getDialogTitle(), this.fDerivationGraph, this.fOptionMap, performanceMetrics, collectors, labels);
        }
        return job;
    }

    @Override
    protected void addOptions(Composite composite) {
    }

    protected abstract String[] getLabels();

    protected abstract IPointEstimator[] getPerformanceMetrics();

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.enableOKButton();
        this.setTitle(this.getDialogTitle());
        return control;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.getShellTitle());
    }

    @Override
    protected StructuredViewer createViewer(Composite composite) {
        GridData checkListData = new GridData(1808);
        checkListData.horizontalSpan = 2;
        this.viewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)0);
        this.viewer.getTable().setLayoutData((Object)checkListData);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.getProvider());
        this.viewer.setInput(this.getViewerInput());
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ChecklistPerformanceMetricDialog.this.enableOKButton();
            }
        });
        return this.viewer;
    }

    @Override
    protected final ViewerFilter getViewerFilter() {
        return this.filter;
    }

    @Override
    protected boolean isOKButtonEnabled() {
        return super.isOKButtonEnabled() && this.viewer.getCheckedElements().length != 0;
    }
}

