/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.largescale;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.Page;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraModelChangedListener;
import uk.ac.ed.inf.pepa.eclipse.core.PepatoProgressMonitorAdapter;
import uk.ac.ed.inf.pepa.eclipse.core.ProcessAlgebraModelChangedEvent;
import uk.ac.ed.inf.pepa.largescale.IGeneratingFunction;
import uk.ac.ed.inf.pepa.largescale.IParametricDerivationGraph;
import uk.ac.ed.inf.pepa.largescale.ParametricDerivationGraphBuilder;
import uk.ac.ed.inf.pepa.largescale.expressions.Coordinate;
import uk.ac.ed.inf.pepa.largescale.expressions.DivisionExpression;
import uk.ac.ed.inf.pepa.largescale.expressions.ExpressionVisitor;
import uk.ac.ed.inf.pepa.largescale.expressions.MinimumExpression;
import uk.ac.ed.inf.pepa.largescale.expressions.MultiplicationExpression;
import uk.ac.ed.inf.pepa.largescale.expressions.RateExpression;
import uk.ac.ed.inf.pepa.largescale.expressions.SubtractionExpression;
import uk.ac.ed.inf.pepa.largescale.expressions.SummationExpression;
import uk.ac.ed.inf.pepa.ode.DifferentialAnalysisException;
import uk.ac.ed.inf.pepa.parsing.ModelNode;

public class DifferentialViewPage
extends Page
implements IProcessAlgebraModelChangedListener {
    private Composite main;
    private TableViewer tableViewer;
    private Label message;
    private IParametricDerivationGraph graph;
    private IPepaModel model;
    private Text searchText;
    private FunctionFilter functionFilter = new FunctionFilter();

    public DifferentialViewPage(IPepaModel model) {
        this.model = model;
        this.model.addModelChangedListener((IProcessAlgebraModelChangedListener)this);
    }

    public void dispose() {
        this.model.removeModelChangedListener((IProcessAlgebraModelChangedListener)this);
        super.dispose();
    }

    public void setFocus() {
        this.main.setFocus();
    }

    protected void updateView() {
        if (!this.model.isDerivable()) {
            this.notPepaModel();
            return;
        }
        final IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(org.eclipse.core.runtime.IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    DifferentialViewPage.this.graph = ParametricDerivationGraphBuilder.createDerivationGraph((ModelNode)DifferentialViewPage.this.model.getAST(), (IProgressMonitor)new PepatoProgressMonitorAdapter(monitor, "ODE generation"));
                }
                catch (DifferentialAnalysisException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        this.main.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    DifferentialViewPage.this.getSite().getWorkbenchWindow().run(true, true, runnable);
                }
                catch (Exception exception) {
                    DifferentialViewPage.this.notPepaModel();
                    return;
                }
            }
        });
        this.main.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DifferentialViewPage.this.message.setText("Generating functions");
                Table table = DifferentialViewPage.this.tableViewer.getTable();
                TableColumn[] tableColumnArray = table.getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn c = tableColumnArray[n2];
                    c.dispose();
                    ++n2;
                }
                GC gc = new GC((Drawable)table);
                TableColumn actionColumn = new TableColumn(table, 16384);
                actionColumn.setText("Action Type");
                int totalWidth = 0;
                int actionWidth = Math.max(gc.textExtent((String)new StringBuilder((String)String.valueOf((Object)actionColumn.getText())).append((String)"w").toString()).x, DifferentialViewPage.getLargestActionType(gc, DifferentialViewPage.this.graph));
                actionColumn.setWidth(actionWidth);
                totalWidth += actionWidth;
                int i = 0;
                while (i < DifferentialViewPage.this.graph.getInitialState().length) {
                    TableColumn c = new TableColumn(table, 131072);
                    c.setText(DifferentialViewPage.this.graph.getSymbolGenerator().getProcessLabel(DifferentialViewPage.this.graph.getProcessMappings()[i]));
                    int width = gc.textExtent((String)new StringBuilder((String)String.valueOf((Object)c.getText())).append((String)"w").toString()).x;
                    c.setWidth(width);
                    totalWidth += width;
                    ++i;
                }
                gc.dispose();
                TableColumn rateColumn = new TableColumn(table, 16384);
                rateColumn.setText("Rate");
                rateColumn.setWidth(totalWidth);
                table.setVisible(true);
                DifferentialViewPage.this.tableViewer.setInput((Object)DifferentialViewPage.this.graph.getGeneratingFunctions());
            }
        });
    }

    private static int getLargestActionType(GC gc, IParametricDerivationGraph graph) {
        int max = gc.textExtent((String)"tauw").x;
        IGeneratingFunction[] iGeneratingFunctionArray = graph.getGeneratingFunctions();
        int n = iGeneratingFunctionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IGeneratingFunction f = iGeneratingFunctionArray[n2];
            max = Math.max(max, gc.textExtent((String)new StringBuilder((String)String.valueOf((Object)graph.getSymbolGenerator().getActionLabel((short)f.getActionId()))).append((String)"w").toString()).x);
            ++n2;
        }
        return max;
    }

    private void notPepaModel() {
        this.main.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DifferentialViewPage.this.notPepaModel("Not a PEPA model");
            }
        });
    }

    private void notPepaModel(String messageText) {
        this.message.setText(messageText);
        this.tableViewer.getTable().setVisible(false);
    }

    public void createControl(Composite parent) {
        this.main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.main.setLayout((Layout)layout);
        this.searchText = new Text(this.main, 384);
        this.searchText.setLayoutData((Object)new GridData(768));
        this.searchText.setMessage("Action type filter");
        this.message = new Label(this.main, 0);
        this.message.setLayoutData((Object)new GridData(768));
        this.tableViewer = new TableViewer(this.main, 67588);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new GeneratingFunctionLabelProvider());
        this.searchText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.detail == 256) {
                    DifferentialViewPage.this.tableViewer.resetFilters();
                } else {
                    DifferentialViewPage.this.tableViewer.setFilters(new ViewerFilter[]{DifferentialViewPage.this.functionFilter});
                }
            }
        });
    }

    public Control getControl() {
        return this.main;
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        super.makeContributions(menuManager, toolBarManager, statusLineManager);
        this.updateView();
    }

    public void processAlgebraModelChanged(ProcessAlgebraModelChangedEvent event) {
        if (event.getType() == 0) {
            this.updateView();
        }
    }

    private class ExpressionPrinter
    implements ExpressionVisitor {
        String result;

        private ExpressionPrinter() {
        }

        public void visitCoordinate(Coordinate coordinate) throws DifferentialAnalysisException {
            this.result = DifferentialViewPage.this.graph.getSymbolGenerator().getProcessLabel(DifferentialViewPage.this.graph.getProcessMappings()[coordinate.getCoordinate()]);
        }

        public void visitDivisionExpression(DivisionExpression bin) throws DifferentialAnalysisException {
            ExpressionPrinter pl = new ExpressionPrinter();
            ExpressionPrinter pr = new ExpressionPrinter();
            bin.getLhs().accept((ExpressionVisitor)pl);
            bin.getRhs().accept((ExpressionVisitor)pr);
            this.result = "(" + pl.result + ") / (" + pr.result + ")";
        }

        public void visitMinimumExpression(MinimumExpression bin) throws DifferentialAnalysisException {
            ExpressionPrinter pl = new ExpressionPrinter();
            ExpressionPrinter pr = new ExpressionPrinter();
            bin.getLhs().accept((ExpressionVisitor)pl);
            bin.getRhs().accept((ExpressionVisitor)pr);
            this.result = "min(" + pl.result + ", " + pr.result + ")";
        }

        public void visitMultiplicationExpression(MultiplicationExpression bin) throws DifferentialAnalysisException {
            ExpressionPrinter pl = new ExpressionPrinter();
            ExpressionPrinter pr = new ExpressionPrinter();
            bin.getLhs().accept((ExpressionVisitor)pl);
            bin.getRhs().accept((ExpressionVisitor)pr);
            this.result = "(" + pl.result + ") * (" + pr.result + ")";
        }

        public void visitRateExpression(RateExpression rate) throws DifferentialAnalysisException {
            this.result = String.valueOf(rate.getRate());
        }

        public void visitSummationExpression(SummationExpression bin) throws DifferentialAnalysisException {
            ExpressionPrinter pl = new ExpressionPrinter();
            ExpressionPrinter pr = new ExpressionPrinter();
            bin.getLhs().accept((ExpressionVisitor)pl);
            bin.getRhs().accept((ExpressionVisitor)pr);
            this.result = "(" + pl.result + ") + (" + pr.result + ")";
        }

        public void visitSubtractionExpression(SubtractionExpression subtractionExpression) throws DifferentialAnalysisException {
            throw new IllegalStateException("Subtraction not allowed here");
        }
    }

    private class FunctionFilter
    extends ViewerFilter {
        private FunctionFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            IGeneratingFunction f = (IGeneratingFunction)element;
            String actionLabel = DifferentialViewPage.this.graph.getSymbolGenerator().getActionLabel(f.getActionId());
            boolean result = actionLabel.contains(DifferentialViewPage.this.searchText.getText());
            return result;
        }
    }

    private class GeneratingFunctionLabelProvider
    implements ITableLabelProvider {
        private GeneratingFunctionLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IGeneratingFunction f = (IGeneratingFunction)element;
            if (columnIndex == 0) {
                return DifferentialViewPage.this.graph.getSymbolGenerator().getActionLabel(f.getActionId());
            }
            if (columnIndex >= 1 && columnIndex <= DifferentialViewPage.this.graph.getInitialState().length) {
                short jump = f.getJump()[columnIndex - 1];
                if (jump == 1) {
                    return "+1";
                }
                if (jump == -1) {
                    return "-1";
                }
                return "0";
            }
            if (columnIndex == DifferentialViewPage.this.graph.getInitialState().length + 1) {
                ExpressionPrinter p = new ExpressionPrinter();
                try {
                    f.getRate().accept((ExpressionVisitor)p);
                }
                catch (DifferentialAnalysisException differentialAnalysisException) {
                    return "N/A";
                }
                return p.result;
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

