/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.largescale;

import org.eclipse.swt.widgets.Composite;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.eclipse.ui.dialogs.ConfigurationText;
import uk.ac.ed.inf.pepa.eclipse.ui.dialogs.IValidationCallback;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.SolverOptionsHandler;

class ODESolverOptionsHandler
extends SolverOptionsHandler {
    private ConfigurationText normText;
    private ConfigurationText startTime;

    public ODESolverOptionsHandler(boolean supportsTransient, OptionMap map, IValidationCallback cb) {
        super(supportsTransient, map, cb);
    }

    @Override
    protected void fillDialogArea(Composite composite) {
        this.startTime = this.configure(composite, "Start time", "ode.integration.start-time", true);
        this.configure(composite, "Stop time", "ode.integration.stop-time", true);
        this.configure(composite, "Number of time points", "ode.integration.step", false);
        this.configure(composite, "Absolute tolerance", "ode.integration.atol", true);
        this.configure(composite, "Relative tolerance", "ode.integration.rtol", true);
        this.normText = this.configure(composite, "Steady-state convergercence norm", "ode.steady-state.norm", true);
        this.enableTransientParameters();
    }

    private void enableTransientParameters() {
        this.normText.control.setEnabled(!this.isTransient());
        this.startTime.control.setEnabled(this.isTransient());
    }

    @Override
    protected void setTransient(boolean isTransient) {
        super.setTransient(isTransient);
        this.enableTransientParameters();
    }

    @Override
    protected OptionMap updateOptionMap() {
        OptionMap map = super.updateOptionMap();
        String value = this.isTransient() ? "ode.interpolation.on" : "ode.interpolation.off";
        map.put((Object)"ode.interpolation", (Object)value);
        return map;
    }
}

