/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.largescale;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.ui.actions.BasicProcessAlgebraModelActionDelegate;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.PerformanceMetricDialog;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.RunnableGraphProvider;
import uk.ac.ed.inf.pepa.largescale.IParametricDerivationGraph;
import uk.ac.ed.inf.pepa.parsing.ModelNode;

public abstract class PerformanceMetricActionDelegate
extends BasicProcessAlgebraModelActionDelegate {
    @Override
    protected final void checkStatus() {
        this.action.setEnabled(this.model.isDerivable());
    }

    @Override
    public final void run(IAction action) {
        MessageDialog messageDialog = new MessageDialog(this.activeShell, "Select kind of analysis", null, "What analysis would you like to do?", 2, new String[]{"Simulation", "ODE"}, 0);
        int messageKind = messageDialog.open();
        IPepaModel model = (IPepaModel)this.model;
        ModelNode node = model.getAST();
        try {
            RunnableGraphProvider gp = new RunnableGraphProvider(node);
            new ProgressMonitorDialog(this.activeShell).run(true, true, (IRunnableWithProgress)gp);
            PerformanceMetricDialog d = this.getDialog(messageKind == 1, gp.getGraph(), model);
            d.open();
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError((Shell)this.activeShell, (String)"ODE Generation Error", (String)e.getTargetException().getMessage());
        }
        catch (InterruptedException interruptedException) {
            MessageDialog.openInformation((Shell)this.activeShell, (String)"Cancel Acknowledgement", (String)"The ODE generation process has been cancelled");
        }
    }

    abstract PerformanceMetricDialog getDialog(boolean var1, IParametricDerivationGraph var2, IPepaModel var3);

    abstract boolean supportsTransient();
}

