/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.largescale;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;
import uk.ac.ed.inf.common.ui.plotting.IChart;
import uk.ac.ed.inf.common.ui.plotview.views.PlotView;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.ui.Activator;
import uk.ac.ed.inf.pepa.eclipse.ui.dialogs.IValidationCallback;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.AnalysisJob;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.ODESolverOptionsHandler;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.SimulationSolverOptionsHandler;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.SolverOptionsHandler;
import uk.ac.ed.inf.pepa.largescale.IParametricDerivationGraph;

public abstract class PerformanceMetricDialog
extends TitleAreaDialog {
    private static final String DIALOG_SETTINGS_NAME = "PERFORMANCE_METRIC_DIALOG";
    protected Button okButton;
    protected IParametricDerivationGraph fDerivationGraph;
    protected OptionMap fOptionMap;
    protected IPepaModel fPepaModel;
    protected SolverOptionsHandler fSolverOptionsHandler;
    protected Text filterText;
    private boolean isFluid;

    public PerformanceMetricDialog(boolean supportsTransient, boolean isFluid, Shell parentShell, IParametricDerivationGraph derivationGraph, IPepaModel model) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.fDerivationGraph = derivationGraph;
        this.fOptionMap = model.getOptionMap();
        this.fPepaModel = model;
        IValidationCallback cb = new IValidationCallback(){

            @Override
            public void validate() {
                PerformanceMetricDialog.this.enableOKButton();
            }
        };
        this.fSolverOptionsHandler = isFluid ? new ODESolverOptionsHandler(supportsTransient, this.fOptionMap, cb) : new SimulationSolverOptionsHandler(supportsTransient, this.fOptionMap, cb);
        this.isFluid = isFluid;
    }

    public final boolean isFluid() {
        return this.isFluid;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_NAME);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS_NAME);
        }
        return section;
    }

    protected final Control createDialogArea(Composite parent) {
        Composite composite = (Composite)this.fSolverOptionsHandler.createDialogArea(parent);
        this.addOptions(composite);
        Label actions = new Label(composite, 0);
        actions.setText(this.getViewerHeader());
        GridData actionsData = new GridData(768);
        actionsData.horizontalSpan = 2;
        actions.setLayoutData((Object)actionsData);
        this.filterText = new Text(composite, 384);
        this.filterText.setMessage("Search");
        GridData textData = new GridData(768);
        textData.horizontalSpan = 2;
        this.filterText.setLayoutData((Object)textData);
        final StructuredViewer viewer = this.createViewer(composite);
        final ViewerFilter[] filter = new ViewerFilter[]{this.getViewerFilter()};
        this.filterText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 256) {
                    viewer.resetFilters();
                }
            }
        });
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                viewer.setFilters(filter);
            }
        });
        parent.pack();
        return composite;
    }

    protected abstract void addOptions(Composite var1);

    protected abstract StructuredViewer createViewer(Composite var1);

    protected abstract String getDialogTitle();

    protected abstract AnalysisJob getAnalysisJob();

    protected abstract ViewerFilter getViewerFilter();

    protected abstract String getViewerHeader();

    protected final void okPressed() {
        OptionMap map = this.fSolverOptionsHandler.updateOptionMap();
        this.fPepaModel.setOptionMap(map);
        AnalysisJob job = this.getAnalysisJob();
        job.setUser(true);
        job.schedule();
        super.okPressed();
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.okButton = this.getButton(0);
        this.okButton.setText("Analyse");
        this.enableOKButton();
        return control;
    }

    protected final void enableOKButton() {
        boolean okEnabled = this.isOKButtonEnabled();
        if (!okEnabled) {
            this.setErrorMessage("Configuration not valid");
        } else {
            this.setErrorMessage(null);
        }
        this.okButton.setEnabled(this.isOKButtonEnabled());
    }

    protected boolean isOKButtonEnabled() {
        return this.fSolverOptionsHandler.isConfigurationValid();
    }

    static boolean isModal(Job job) {
        Boolean isModal = (Boolean)job.getProperty(IProgressConstants.PROPERTY_IN_DIALOG);
        if (isModal == null) {
            return false;
        }
        return isModal;
    }

    static void display(final IChart chart) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                Shell shell = window.getShell();
                try {
                    PlotView plotView = (PlotView)page.showView("uk.ac.ed.inf.common.ui.plotview.views.PlotView");
                    plotView.reveal(chart);
                }
                catch (PartInitException e) {
                    ErrorDialog.openError((Shell)shell, (String)"Error", (String)"Error displaying graph", (IStatus)e.getStatus());
                }
            }
        });
    }
}

