/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.largescale;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.ChecklistPerformanceMetricDialog;
import uk.ac.ed.inf.pepa.largescale.IParametricDerivationGraph;
import uk.ac.ed.inf.pepa.largescale.IPointEstimator;
import uk.ac.ed.inf.pepa.ode.DifferentialAnalysisException;

public class PopulationLevelDialog
extends ChecklistPerformanceMetricDialog {
    public PopulationLevelDialog(boolean isFluid, Shell parentShell, IParametricDerivationGraph derivationGraph, IPepaModel model) {
        super(true, isFluid, parentShell, derivationGraph, model);
    }

    @Override
    protected String getViewerHeader() {
        return "Select population levels";
    }

    @Override
    protected String getDialogTitle() {
        return "Population Level Analysis";
    }

    @Override
    ITableLabelProvider getProvider() {
        return new PopulationLevelProvider();
    }

    @Override
    String getShellTitle() {
        return this.getDialogTitle();
    }

    @Override
    Object getViewerInput() {
        Integer[] values = new Integer[this.fDerivationGraph.getProcessMappings().length];
        int i = 0;
        while (i < values.length) {
            values[i] = i;
            ++i;
        }
        return values;
    }

    @Override
    protected String[] getLabels() {
        Object[] checkedElements = this.viewer.getCheckedElements();
        String[] labels = new String[checkedElements.length];
        int i = 0;
        while (i < checkedElements.length) {
            labels[i] = this.fDerivationGraph.getSymbolGenerator().getProcessLabel(this.fDerivationGraph.getProcessMappings()[(Integer)checkedElements[i]]);
            ++i;
        }
        return labels;
    }

    @Override
    protected IPointEstimator[] getPerformanceMetrics() {
        Object[] checkedElements = this.viewer.getCheckedElements();
        IPointEstimator[] estimators = new IPointEstimator[checkedElements.length];
        int i = 0;
        while (i < checkedElements.length) {
            estimators[i] = new PopulationEstimator((Integer)checkedElements[i]);
            System.err.println("Population: " + (Integer)checkedElements[i]);
            ++i;
        }
        return estimators;
    }

    class PopulationEstimator
    implements IPointEstimator {
        private int index;

        public PopulationEstimator(int index) {
            this.index = index;
        }

        public double computeEstimate(double timePoint, double[] solution) throws DifferentialAnalysisException {
            return solution[this.index];
        }
    }

    private class PopulationLevelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private PopulationLevelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof Integer) {
                    return PopulationLevelDialog.this.fDerivationGraph.getSymbolGenerator().getProcessLabel(PopulationLevelDialog.this.fDerivationGraph.getProcessMappings()[(Integer)element]);
                }
                throw new IllegalArgumentException();
            }
            return null;
        }
    }
}

