/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.largescale;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.eclipse.ui.dialogs.ConfigurationWidget;
import uk.ac.ed.inf.pepa.eclipse.ui.dialogs.DoubleConfigurationText;
import uk.ac.ed.inf.pepa.eclipse.ui.dialogs.IValidationCallback;
import uk.ac.ed.inf.pepa.eclipse.ui.dialogs.IntegerConfigurationText;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.SolverOptionsHandler;

class SimulationSolverOptionsHandler
extends SolverOptionsHandler {
    private DoubleConfigurationText startText;
    private IntegerConfigurationText stepText;
    private IntegerConfigurationText iterText;
    private DoubleConfigurationText confidenceLevelErrorText;
    private Combo convergenceCombo;
    private Label stopLabel;

    public SimulationSolverOptionsHandler(boolean supportsTransient, OptionMap map, IValidationCallback cb) {
        super(supportsTransient, map, cb);
    }

    @Override
    protected void fillDialogArea(Composite composite) {
        Label convergenceCriterion = new Label(composite, 0);
        convergenceCriterion.setText("Convergence criterion");
        convergenceCriterion.setLayoutData((Object)new GridData(768));
        this.convergenceCombo = new Combo(composite, 8);
        this.convergenceCombo.setLayoutData((Object)new GridData(768));
        this.convergenceCombo.add("Confidence level");
        this.convergenceCombo.add("Number of replications");
        this.convergenceCombo.select(0);
        this.convergenceCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SimulationSolverOptionsHandler.this.cb.validate();
            }
        });
        this.startText = (DoubleConfigurationText)this.configure(composite, "Start time", "ssa.start-time", true);
        this.stopLabel = (Label)this.configureComplete(composite, "Stop time", "ssa.stop-time", true)[1];
        this.stepText = (IntegerConfigurationText)this.configure(composite, "Number of time points", "ssa.time-interval", false);
        this.iterText = (IntegerConfigurationText)this.configure(composite, "Number of replications", "ssa.convergence.max-iterations", false);
        this.configure(composite, "Confidence level", "ssa.convergence.confidence", true);
        this.confidenceLevelErrorText = (DoubleConfigurationText)this.configure(composite, "Confidence level percentage error", "ssa.convergence.confidence-percent", true);
        this.convergenceCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ((SimulationSolverOptionsHandler)SimulationSolverOptionsHandler.this).confidenceLevelErrorText.control.setEnabled(SimulationSolverOptionsHandler.this.convergenceCombo.getSelectionIndex() == 0);
            }

            public void widgetSelected(SelectionEvent e) {
                ((SimulationSolverOptionsHandler)SimulationSolverOptionsHandler.this).confidenceLevelErrorText.control.setEnabled(SimulationSolverOptionsHandler.this.convergenceCombo.getSelectionIndex() == 0);
            }
        });
    }

    @Override
    protected void setTransient(boolean isTransient) {
        super.setTransient(isTransient);
        this.startText.control.setEnabled(isTransient);
        this.stepText.control.setEnabled(isTransient);
        this.iterText.control.setEnabled(isTransient);
        if (isTransient) {
            this.convergenceCombo.setEnabled(true);
            this.confidenceLevelErrorText.control.setEnabled(this.convergenceCombo.getSelectionIndex() == 0);
            this.stopLabel.setText("Stop time");
        } else {
            this.convergenceCombo.setEnabled(false);
            this.convergenceCombo.select(0);
            this.confidenceLevelErrorText.control.setEnabled(true);
            this.stopLabel.setText("Transient period");
        }
    }

    public String getConvergenceCriterion() {
        if (this.convergenceCombo.getSelectionIndex() == 0) {
            return "ssa.confidence-level";
        }
        return "ssa.max-iterations";
    }

    @Override
    protected OptionMap updateOptionMap() {
        OptionMap map = super.updateOptionMap();
        map.put((Object)"ssa.convergence", (Object)this.getConvergenceCriterion());
        for (ConfigurationWidget w : this.widgets) {
            map.put((Object)w.getProperty(), w.getValue());
        }
        return map;
    }
}

