/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.largescale;

import java.util.ArrayList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.eclipse.ui.dialogs.ConfigurationText;
import uk.ac.ed.inf.pepa.eclipse.ui.dialogs.ConfigurationWidget;
import uk.ac.ed.inf.pepa.eclipse.ui.dialogs.IValidationCallback;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.NonNegativeDoubleConfigurationText;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.PositiveIntegerConfigurationText;

abstract class SolverOptionsHandler {
    private boolean isTransient = false;
    private boolean supportsTransient;
    protected Combo transientCombo;
    protected OptionMap map;
    protected IValidationCallback cb;
    protected ArrayList<ConfigurationWidget> widgets = new ArrayList();

    public SolverOptionsHandler(boolean supportsTransient, OptionMap map, IValidationCallback cb) {
        this.supportsTransient = supportsTransient;
        this.map = map;
        this.cb = cb;
    }

    public final Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layoutTP = new GridLayout();
        layoutTP.marginWidth = 5;
        layoutTP.numColumns = 2;
        composite.setLayout((Layout)layoutTP);
        Label analysisLabel = new Label(composite, 0);
        analysisLabel.setText("Kind of analysis");
        analysisLabel.setLayoutData((Object)new GridData(768));
        this.transientCombo = new Combo(composite, 8);
        this.transientCombo.setLayoutData((Object)new GridData(768));
        this.transientCombo.add("Steady state");
        if (this.supportsTransient) {
            this.transientCombo.add("Transient");
        }
        this.transientCombo.select(0);
        this.transientCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SolverOptionsHandler.this.setTransient(SolverOptionsHandler.this.transientCombo.getText().equals("Transient"));
                SolverOptionsHandler.this.cb.validate();
            }
        });
        this.fillDialogArea(composite);
        this.setTransient(false);
        return composite;
    }

    protected void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    protected abstract void fillDialogArea(Composite var1);

    public boolean isConfigurationValid() {
        for (ConfigurationWidget w : this.widgets) {
            if (w.isValid()) continue;
            return false;
        }
        return true;
    }

    public final boolean isTransient() {
        return this.isTransient;
    }

    protected ConfigurationText configure(Composite composite, String labelText, String key, boolean isDouble) {
        return (ConfigurationText)this.configureComplete(composite, labelText, key, isDouble)[0];
    }

    protected Object[] configureComplete(Composite composite, String labelText, String key, boolean isDouble) {
        Label label = new Label(composite, 0);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData(768));
        ConfigurationText configurationText = isDouble ? new NonNegativeDoubleConfigurationText(this.map, key, this.cb) : new PositiveIntegerConfigurationText(this.map, key, this.cb);
        configurationText.createControl(composite);
        configurationText.control.setLayoutData((Object)new GridData(768));
        this.widgets.add(configurationText);
        return new Object[]{configurationText, label};
    }

    protected OptionMap updateOptionMap() {
        for (ConfigurationWidget w : this.widgets) {
            this.map.put((Object)w.getProperty(), w.getValue());
        }
        return this.map;
    }
}

