/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.largescale;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.ui.largescale.ChecklistPerformanceMetricDialog;
import uk.ac.ed.inf.pepa.largescale.IParametricDerivationGraph;
import uk.ac.ed.inf.pepa.largescale.IPointEstimator;
import uk.ac.ed.inf.pepa.largescale.ISequentialComponent;
import uk.ac.ed.inf.pepa.largescale.ThroughputCalculation;

public class ThroughputDialog
extends ChecklistPerformanceMetricDialog {
    public ThroughputDialog(boolean isFluid, Shell shell, IParametricDerivationGraph derivationGraph, IPepaModel model) {
        super(true, isFluid, shell, derivationGraph, model);
    }

    @Override
    String getShellTitle() {
        return "Fluid-flow Throughput Calculation";
    }

    @Override
    protected String getViewerHeader() {
        return "Select actions";
    }

    @Override
    protected String getDialogTitle() {
        return "Throughput Analysis";
    }

    @Override
    ITableLabelProvider getProvider() {
        return new ThroughputTableProvider();
    }

    @Override
    protected Object getViewerInput() {
        return this.getAlphabet();
    }

    private Short[] getAlphabet() {
        ArrayList<Short> alphabet = new ArrayList<Short>();
        ISequentialComponent[] iSequentialComponentArray = this.fDerivationGraph.getSequentialComponents();
        int n = iSequentialComponentArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISequentialComponent c = iSequentialComponentArray[n2];
            short[] sArray = c.getActionAlphabet();
            int n3 = sArray.length;
            int n4 = 0;
            while (n4 < n3) {
                short actionId = sArray[n4];
                if (!alphabet.contains(actionId)) {
                    alphabet.add(actionId);
                }
                ++n4;
            }
            ++n2;
        }
        Collections.sort(alphabet, new Comparator<Short>(){

            @Override
            public int compare(Short arg0, Short arg1) {
                return ThroughputDialog.this.fDerivationGraph.getSymbolGenerator().getActionLabel(arg0.shortValue()).compareTo(ThroughputDialog.this.fDerivationGraph.getSymbolGenerator().getActionLabel(arg1.shortValue()));
            }
        });
        return alphabet.toArray(new Short[alphabet.size()]);
    }

    @Override
    protected String[] getLabels() {
        Object[] checkedElements = this.viewer.getCheckedElements();
        String[] labels = new String[checkedElements.length];
        int i = 0;
        while (i < checkedElements.length) {
            labels[i] = this.fDerivationGraph.getSymbolGenerator().getActionLabel(((Short)checkedElements[i]).shortValue());
            ++i;
        }
        return labels;
    }

    @Override
    protected IPointEstimator[] getPerformanceMetrics() {
        Object[] checkedElements = this.viewer.getCheckedElements();
        ThroughputCalculation[] calculators = new ThroughputCalculation[checkedElements.length];
        int i = 0;
        while (i < checkedElements.length) {
            calculators[i] = new ThroughputCalculation(((Short)checkedElements[i]).shortValue(), this.fDerivationGraph);
            ++i;
        }
        return calculators;
    }

    private class ThroughputTableProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ThroughputTableProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof Short) {
                    return ThroughputDialog.this.fDerivationGraph.getSymbolGenerator().getActionLabel(((Short)element).shortValue());
                }
                throw new IllegalArgumentException();
            }
            return null;
        }
    }
}

