/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.view;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraModelChangedListener;
import uk.ac.ed.inf.pepa.eclipse.core.PepaCore;
import uk.ac.ed.inf.pepa.eclipse.core.ProcessAlgebraModelChangedEvent;
import uk.ac.ed.inf.pepa.eclipse.ui.editor.IProcessAlgebraEditor;

public abstract class AbstractView
extends ViewPart {
    private ListenerMix fListener;
    protected IProcessAlgebraEditor fEditor;

    public static IEditorPart getActiveEditor() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PepaCore.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    public void init(IViewSite site) throws PartInitException {
        super.setSite((IWorkbenchPartSite)site);
        this.fListener = new ListenerMix(this);
        site.getPage().addPartListener((IPartListener2)this.fListener);
    }

    public final void createPartControl(Composite parent) {
        this.internalCreatePartControl(parent);
        IEditorPart part = AbstractView.getActiveEditor();
        this.setInput(part);
    }

    protected abstract void internalCreatePartControl(Composite var1);

    private void setInput(IEditorPart editor) {
        if (editor == this.fEditor) {
            return;
        }
        if (this.fEditor != null) {
            this.unRegisterPEPAListener();
        }
        if (editor instanceof IProcessAlgebraEditor) {
            this.fEditor = (IProcessAlgebraEditor)editor;
            this.registerPEPAListener();
        } else {
            this.fEditor = null;
        }
        this.updateView(this.fEditor);
    }

    protected abstract void updateView(IProcessAlgebraEditor var1);

    protected abstract void handleModelChanged(ProcessAlgebraModelChangedEvent var1);

    private void registerPEPAListener() {
        this.fEditor.getProcessAlgebraModel().addModelChangedListener((IProcessAlgebraModelChangedListener)this.fListener);
    }

    private void unRegisterPEPAListener() {
        if (this.fEditor != null) {
            this.fEditor.getProcessAlgebraModel().removeModelChangedListener((IProcessAlgebraModelChangedListener)this.fListener);
        }
    }

    public abstract void setFocus();

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.fListener);
        this.unRegisterPEPAListener();
        super.dispose();
    }

    private static class ListenerMix
    implements IPartListener2,
    IProcessAlgebraModelChangedListener {
        private AbstractView fView;

        public ListenerMix(AbstractView view) {
            this.fView = view;
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            if (partRef instanceof IEditorReference) {
                IEditorReference editorRef = (IEditorReference)partRef;
                IEditorPart part = editorRef.getEditor(true);
                this.fView.setInput(part);
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            if (partRef instanceof IEditorReference) {
                this.fView.setInput(AbstractView.getActiveEditor());
            }
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void processAlgebraModelChanged(ProcessAlgebraModelChangedEvent event) {
            this.fView.handleModelChanged(event);
        }
    }
}

