/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.view.abstractionview;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.SpringLayoutAlgorithm;
import uk.ac.ed.inf.pepa.ctmc.kronecker.KroneckerDisplayComponent;
import uk.ac.ed.inf.pepa.ctmc.kronecker.KroneckerDisplayModel;
import uk.ac.ed.inf.pepa.ctmc.kronecker.KroneckerDisplayPropertyMap;
import uk.ac.ed.inf.pepa.ctmc.kronecker.KroneckerDisplayState;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.PropertyDependencyException;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.core.ProcessAlgebraModelChangedEvent;
import uk.ac.ed.inf.pepa.eclipse.ui.ImageManager;
import uk.ac.ed.inf.pepa.eclipse.ui.editor.IProcessAlgebraEditor;
import uk.ac.ed.inf.pepa.eclipse.ui.editor.PEPAEditor;
import uk.ac.ed.inf.pepa.eclipse.ui.view.AbstractView;
import uk.ac.ed.inf.pepa.eclipse.ui.view.abstractionview.PropertyManager;
import uk.ac.ed.inf.pepa.eclipse.ui.view.abstractionview.SequentialComponentGraphBuilder;

public class AbstractionView
extends AbstractView {
    private Composite viewFrame;
    private CTabFolder tabFolder;
    private Button aggregateButton;
    private Button disaggregateButton;
    private Button showActionsButton;
    private Button useShortNamesButton;
    private Label propertyLabel;
    private Label statusLabel;
    private Table propertyTable;
    private TableEditor propertyTableEditor;
    private boolean showActions = false;
    private boolean useShortNames = true;
    private Action addPropertyAction;
    private Action increaseSizeAction;
    private Action decreaseSizeAction;
    private SequentialComponentGraphBuilder[] builders;
    private KroneckerDisplayComponent[] displayComponents;
    private Graph[] componentViewers;
    private boolean[] applyLayoutOnSelect;

    private void createAddPropertyAction() {
        this.addPropertyAction = new Action("New Property"){

            public void run() {
                int currentTab = AbstractionView.this.tabFolder.getSelectionIndex();
                KroneckerDisplayPropertyMap propertyMap = AbstractionView.this.displayComponents[currentTab].getPropertyMap();
                String newName = propertyMap.addProperty();
                propertyMap.setPropertyAll(newName, false);
                TableItem property = PropertyManager.newProperty(AbstractionView.this.propertyTable, 0);
                property.setText(newName);
                ArrayList selection = AbstractionView.this.getStates(AbstractionView.this.componentViewers[currentTab].getSelection().toArray());
                if (selection.size() > 0) {
                    propertyMap.setPropertyAll(newName, false);
                    propertyMap.setProperty(newName, selection, true);
                    PropertyManager.setTrue(property);
                } else {
                    PropertyManager.setUnselected(property);
                }
                AbstractionView.this.editProperty(property);
            }
        };
    }

    private void createFontSizeActions() {
        this.increaseSizeAction = new Action("Larger Font", 1){

            public void run() {
                int i = 0;
                while (i < AbstractionView.this.builders.length) {
                    AbstractionView.this.builders[i].increaseFontSize();
                    ++i;
                }
            }
        };
        this.increaseSizeAction.setToolTipText("Increase font size");
        this.increaseSizeAction.setImageDescriptor(ImageManager.getInstance().getImageDescriptor("zoom-in.gif"));
        this.decreaseSizeAction = new Action("Smaller Font", 1){

            public void run() {
                int i = 0;
                while (i < AbstractionView.this.builders.length) {
                    AbstractionView.this.builders[i].decreaseFontSize();
                    ++i;
                }
            }
        };
        this.decreaseSizeAction.setToolTipText("Decrease font size");
        this.decreaseSizeAction.setImageDescriptor(ImageManager.getInstance().getImageDescriptor("zoom-out.gif"));
    }

    private void createToolBar() {
        IToolBarManager manager = this.getViewSite().getActionBars().getToolBarManager();
        manager.removeAll();
        manager.update(false);
        manager.add((IAction)this.increaseSizeAction);
        manager.add((IAction)this.decreaseSizeAction);
        manager.update(true);
    }

    private void deleteProperty(TableItem property) {
        int currentTab = this.tabFolder.getSelectionIndex();
        KroneckerDisplayPropertyMap propertyMap = this.displayComponents[currentTab].getPropertyMap();
        String name = property.getText();
        try {
            propertyMap.removeProperty(name);
            this.propertyTable.remove(this.propertyTable.indexOf(property));
            this.computePropertyTableWidths();
        }
        catch (PropertyDependencyException propertyDependencyException) {
            MessageBox errorMessage = new MessageBox(this.getSite().getShell(), 33);
            errorMessage.setText("Error");
            errorMessage.setMessage("The property \"" + name + "\" cannot be deleted, because it is being used by " + "a CSL property. You must remove all references to \"" + name + "\" from the " + "model checking view before you can delete it.");
            errorMessage.open();
        }
    }

    private Action createDeletePropertyAction(final TableItem selection) {
        Action deletePropertyAction = new Action("Delete"){

            public void run() {
                AbstractionView.this.deleteProperty(selection);
                AbstractionView.this.updateCurrentGraph();
            }
        };
        return deletePropertyAction;
    }

    private void renameProperty(TableItem property) {
        int currentTab = this.tabFolder.getSelectionIndex();
        if (currentTab == -1) {
            return;
        }
        String newName = ((Text)this.propertyTableEditor.getEditor()).getText();
        String oldName = property.getText();
        String renamedProperty = this.displayComponents[currentTab].getPropertyMap().renameProperty(oldName, newName);
        this.propertyTableEditor.getItem().setText(renamedProperty);
        this.computePropertyTableWidths();
    }

    private void editProperty(final TableItem property) {
        Control oldEditor = this.propertyTableEditor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
        Text newEditor = new Text((Composite)this.propertyTable, 0);
        newEditor.setBackground(property.getBackground());
        newEditor.setText(property.getText());
        newEditor.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                AbstractionView.this.renameProperty(property);
                Control oldEditor = AbstractionView.this.propertyTableEditor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
            }
        });
        newEditor.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                Control oldEditor;
                if (e.character == '\r') {
                    AbstractionView.this.renameProperty(property);
                    Control oldEditor2 = AbstractionView.this.propertyTableEditor.getEditor();
                    if (oldEditor2 != null) {
                        oldEditor2.dispose();
                    }
                } else if (e.character == '\u001b' && (oldEditor = AbstractionView.this.propertyTableEditor.getEditor()) != null) {
                    oldEditor.dispose();
                }
            }
        });
        newEditor.selectAll();
        newEditor.setFocus();
        this.propertyTableEditor.setEditor((Control)newEditor, property, 0);
    }

    private Action createRenamePropertyAction(final TableItem property) {
        Action renamePropertyAction = new Action("Rename"){

            public void run() {
                AbstractionView.this.editProperty(property);
            }
        };
        return renamePropertyAction;
    }

    private Action createSetPropertyAction(String propertyName, boolean isChecked) {
        Action setPropertyAction = new Action(propertyName, 32){

            public void run() {
                int currentTab = AbstractionView.this.tabFolder.getSelectionIndex();
                KroneckerDisplayPropertyMap propertyMap = AbstractionView.this.displayComponents[currentTab].getPropertyMap();
                ArrayList selected = AbstractionView.this.getStates(AbstractionView.this.componentViewers[currentTab].getSelection().toArray());
                propertyMap.setProperty(this.getText(), selected, this.isChecked());
                AbstractionView.this.updatePropertyTable(false);
            }
        };
        setPropertyAction.setChecked(isChecked);
        return setPropertyAction;
    }

    private void switchPropertyTable() {
        int currentTab = this.tabFolder.getSelectionIndex();
        this.propertyTable.removeAll();
        if (currentTab == -1) {
            return;
        }
        KroneckerDisplayComponent component = this.displayComponents[currentTab];
        String[] properties = component.getPropertyMap().getProperties();
        int i = 0;
        while (i < properties.length) {
            TableItem property = PropertyManager.newProperty(this.propertyTable, 0);
            property.setText(properties[i]);
            ++i;
        }
        this.updatePropertyTable(false);
    }

    private void updatePropertyTable(boolean ignoreUnselected) {
        this.propertyTable.deselectAll();
        int currentTab = this.tabFolder.getSelectionIndex();
        if (currentTab == -1) {
            return;
        }
        Graph componentViewer = this.componentViewers[currentTab];
        KroneckerDisplayComponent component = this.displayComponents[currentTab];
        KroneckerDisplayPropertyMap propertyMap = component.getPropertyMap();
        TableItem[] properties = this.propertyTable.getItems();
        ArrayList<KroneckerDisplayState> selection = this.getStates(componentViewer.getSelection().toArray());
        if (selection.size() > 0) {
            int i = 0;
            while (i < properties.length) {
                if (!ignoreUnselected || !PropertyManager.isUnselected(properties[i])) {
                    if (propertyMap.testProperty(properties[i].getText(), selection, false)) {
                        PropertyManager.setFalse(properties[i]);
                    } else if (propertyMap.testProperty(properties[i].getText(), selection, true)) {
                        PropertyManager.setTrue(properties[i]);
                    } else {
                        PropertyManager.setMaybe(properties[i]);
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < properties.length) {
                PropertyManager.setUnselected(properties[i]);
                ++i;
            }
        }
    }

    private void updateCurrentGraph() {
        int currentTab = this.tabFolder.getSelectionIndex();
        if (currentTab == -1) {
            return;
        }
        KroneckerDisplayComponent component = this.displayComponents[currentTab];
        KroneckerDisplayPropertyMap propertyMap = component.getPropertyMap();
        TableItem[] properties = this.propertyTable.getItems();
        ArrayList selection = null;
        boolean allUnselected = true;
        int i = 0;
        while (i < properties.length) {
            ArrayList newSelection;
            if (PropertyManager.isFalse(properties[i])) {
                newSelection = propertyMap.getStates(properties[i].getText(), false);
                allUnselected = false;
            } else if (PropertyManager.isTrue(properties[i])) {
                newSelection = propertyMap.getStates(properties[i].getText(), true);
                allUnselected = false;
            } else if (PropertyManager.isMaybe(properties[i])) {
                newSelection = propertyMap.getAllStates();
                allUnselected = false;
            } else {
                newSelection = propertyMap.getAllStates();
            }
            if (selection == null) {
                selection = newSelection;
            } else {
                selection.retainAll(newSelection);
            }
            ++i;
        }
        if (allUnselected) {
            this.selectStates(this.builders[currentTab], new ArrayList<KroneckerDisplayState>(0));
        } else {
            component.clearSelection();
            for (KroneckerDisplayState state : selection) {
                component.selectState(state);
            }
            this.selectStates(this.builders[currentTab], selection);
        }
    }

    private void updateGraphLabels(boolean applyLayout) {
        int i = 0;
        while (i < this.builders.length) {
            this.builders[i].build(this.showActions, this.useShortNames);
            this.applyLayoutOnSelect[i] = this.applyLayoutOnSelect[i] || applyLayout;
            ++i;
        }
        int tabIndex = this.tabFolder.getSelectionIndex();
        if (tabIndex > -1) {
            this.applyLayout(tabIndex);
        }
    }

    private void applyLayout(int tabIndex) {
        if (this.applyLayoutOnSelect[tabIndex]) {
            this.componentViewers[tabIndex].applyLayout();
            this.applyLayoutOnSelect[tabIndex] = false;
        }
    }

    @Override
    protected void updateView(final IProcessAlgebraEditor editor) {
        this.tabFolder.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                CTabItem[] tabs = AbstractionView.this.tabFolder.getItems();
                int i = 0;
                while (i < tabs.length) {
                    tabs[i].dispose();
                    ++i;
                }
                AbstractionView.this.aggregateButton.setEnabled(false);
                AbstractionView.this.disaggregateButton.setEnabled(false);
                AbstractionView.this.showActionsButton.setEnabled(false);
                AbstractionView.this.useShortNamesButton.setEnabled(false);
                AbstractionView.this.propertyLabel.setEnabled(false);
                AbstractionView.this.statusLabel.setText("");
                KroneckerDisplayModel displayModel = null;
                AbstractionView.this.displayComponents = null;
                AbstractionView.this.propertyTable.removeAll();
                if (editor == null) {
                    return;
                }
                IPepaModel pepaModel = ((PEPAEditor)editor).getProcessAlgebraModel();
                if (pepaModel == null) {
                    return;
                }
                displayModel = pepaModel.getDisplayModel();
                if (displayModel == null) {
                    return;
                }
                int numComponents = displayModel.getNumComponents();
                AbstractionView.this.displayComponents = new KroneckerDisplayComponent[numComponents];
                AbstractionView.this.showActionsButton.setEnabled(true);
                AbstractionView.this.useShortNamesButton.setEnabled(true);
                AbstractionView.this.propertyLabel.setEnabled(true);
                AbstractionView.this.componentViewers = new Graph[numComponents];
                AbstractionView.this.applyLayoutOnSelect = new boolean[numComponents];
                AbstractionView.this.builders = new SequentialComponentGraphBuilder[numComponents];
                int i2 = 0;
                while (i2 < numComponents) {
                    ((AbstractionView)AbstractionView.this).displayComponents[i2] = displayModel.getComponent(i2);
                    CTabItem componentTab = new CTabItem(AbstractionView.this.tabFolder, 0);
                    componentTab.setText(AbstractionView.this.displayComponents[i2].getName());
                    ((AbstractionView)AbstractionView.this).componentViewers[i2] = new Graph((Composite)AbstractionView.this.tabFolder, 0);
                    ((AbstractionView)AbstractionView.this).builders[i2] = new SequentialComponentGraphBuilder(AbstractionView.this.displayComponents[i2], AbstractionView.this.componentViewers[i2]);
                    AbstractionView.this.builders[i2].build(AbstractionView.this.showActions, AbstractionView.this.useShortNames);
                    AbstractionView.this.componentViewers[i2].setConnectionStyle(2);
                    AbstractionView.this.componentViewers[i2].setLayoutAlgorithm((LayoutAlgorithm)new SpringLayoutAlgorithm(3), true);
                    GraphSelectionListener selectionListener = new GraphSelectionListener(AbstractionView.this.builders[i2]);
                    AbstractionView.this.componentViewers[i2].addSelectionListener((SelectionListener)selectionListener);
                    componentTab.setControl((Control)AbstractionView.this.componentViewers[i2]);
                    AbstractionView.this.addGraphContextMenu(AbstractionView.this.componentViewers[i2]);
                    ((AbstractionView)AbstractionView.this).applyLayoutOnSelect[i2] = true;
                    ++i2;
                }
                AbstractionView.this.switchPropertyTable();
                AbstractionView.this.computePropertyTableWidths();
            }
        });
    }

    @Override
    protected void handleModelChanged(ProcessAlgebraModelChangedEvent event) {
        if (event.getType() == 0) {
            this.updateView(this.fEditor);
        }
    }

    @Override
    public void setFocus() {
        if (this.tabFolder != null && !this.tabFolder.isDisposed()) {
            this.tabFolder.setFocus();
        }
    }

    @Override
    protected void internalCreatePartControl(Composite parent) {
        this.viewFrame = new Composite(parent, 0);
        this.viewFrame.setLayout((Layout)new FormLayout());
        this.disaggregateButton = new Button(this.viewFrame, 8);
        this.disaggregateButton.setText("Disaggregate");
        this.disaggregateButton.setEnabled(false);
        this.disaggregateButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int tabIndex = AbstractionView.this.tabFolder.getSelectionIndex();
                if (tabIndex == -1) {
                    return;
                }
                AbstractionView.this.displayComponents[tabIndex].disaggregateSelected();
                Object[] selection = AbstractionView.this.componentViewers[tabIndex].getSelection().toArray();
                AbstractionView.this.setControls(AbstractionView.this.displayComponents[tabIndex], AbstractionView.this.getStates(selection));
            }
        });
        FormData formData = new FormData();
        formData.right = new FormAttachment(100, -5);
        formData.bottom = new FormAttachment(100, -5);
        this.disaggregateButton.setLayoutData((Object)formData);
        this.aggregateButton = new Button(this.viewFrame, 8);
        this.aggregateButton.setText("Aggregate");
        this.aggregateButton.setEnabled(false);
        this.aggregateButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int tabIndex = AbstractionView.this.tabFolder.getSelectionIndex();
                if (tabIndex == -1) {
                    return;
                }
                AbstractionView.this.displayComponents[tabIndex].aggregateSelected();
                Object[] selection = AbstractionView.this.componentViewers[tabIndex].getSelection().toArray();
                AbstractionView.this.setControls(AbstractionView.this.displayComponents[tabIndex], AbstractionView.this.getStates(selection));
            }
        });
        formData = new FormData();
        formData.right = new FormAttachment((Control)this.disaggregateButton, -5);
        formData.bottom = new FormAttachment(100, -5);
        this.aggregateButton.setLayoutData((Object)formData);
        this.showActionsButton = new Button(this.viewFrame, 32);
        this.showActionsButton.setText("Show Actions");
        this.showActionsButton.setEnabled(true);
        this.showActionsButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AbstractionView.this.showActions = !AbstractionView.this.showActions;
                AbstractionView.this.updateGraphLabels(AbstractionView.this.showActions);
            }
        });
        formData = new FormData();
        formData.right = new FormAttachment((Control)this.aggregateButton, -5);
        formData.bottom = new FormAttachment(100, -8);
        this.showActionsButton.setLayoutData((Object)formData);
        this.useShortNamesButton = new Button(this.viewFrame, 32);
        this.useShortNamesButton.setText("Show Rates");
        this.useShortNamesButton.setEnabled(true);
        this.useShortNamesButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AbstractionView.this.useShortNames = !AbstractionView.this.useShortNames;
                AbstractionView.this.updateGraphLabels(false);
            }
        });
        formData = new FormData();
        formData.right = new FormAttachment((Control)this.showActionsButton, -5);
        formData.bottom = new FormAttachment(100, -8);
        this.useShortNamesButton.setLayoutData((Object)formData);
        this.statusLabel = new Label(this.viewFrame, 4);
        this.statusLabel.setText("");
        formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment((Control)this.useShortNamesButton, -5);
        formData.bottom = new FormAttachment(100, -10);
        this.statusLabel.setLayoutData((Object)formData);
        this.propertyLabel = new Label(this.viewFrame, 0);
        this.propertyLabel.setText("Properties");
        this.propertyLabel.setAlignment(0x1000000);
        formData = new FormData();
        formData.right = new FormAttachment(100, -5);
        formData.top = new FormAttachment(0, 5);
        this.propertyLabel.setLayoutData((Object)formData);
        this.propertyTable = new Table(this.viewFrame, 67586);
        this.propertyTable.setHeaderVisible(false);
        this.propertyTable.setLinesVisible(false);
        TableColumn propertyColumn = new TableColumn(this.propertyTable, 0);
        propertyColumn.setAlignment(16384);
        this.computePropertyTableWidths();
        this.propertyTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (AbstractionView.this.propertyTable.getMenu().isVisible()) {
                    return;
                }
                TableItem[] selected = AbstractionView.this.propertyTable.getSelection();
                if (selected.length < 1) {
                    return;
                }
                TableItem selectedItem = selected[0];
                AbstractionView.this.propertyTable.setData((Object)selectedItem);
                TableItem[] allItems = AbstractionView.this.propertyTable.getItems();
                int i = 0;
                while (i < allItems.length) {
                    if (allItems[i] != selectedItem) {
                        PropertyManager.setUnselected(allItems[i]);
                    }
                    ++i;
                }
                PropertyManager.click(selectedItem);
                AbstractionView.this.updateCurrentGraph();
                AbstractionView.this.propertyTable.deselectAll();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        this.addPropertyContextMenu();
        this.createAddPropertyAction();
        this.propertyTableEditor = new TableEditor(this.propertyTable);
        this.propertyTableEditor.horizontalAlignment = 16384;
        this.propertyTableEditor.grabHorizontal = true;
        this.propertyTableEditor.verticalAlignment = 0x1000000;
        formData = new FormData();
        formData.right = new FormAttachment(100, -5);
        formData.top = new FormAttachment((Control)this.propertyLabel, 5);
        formData.bottom = new FormAttachment((Control)this.disaggregateButton, -5);
        this.propertyTable.setLayoutData((Object)formData);
        this.tabFolder = new CTabFolder(this.viewFrame, 2048);
        this.tabFolder.setSimple(false);
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractionView.this.switchPropertyTable();
                int tabIndex = AbstractionView.this.tabFolder.getSelectionIndex();
                if (tabIndex == -1) {
                    return;
                }
                AbstractionView.this.applyLayout(tabIndex);
                Object[] selection = AbstractionView.this.componentViewers[tabIndex].getSelection().toArray();
                AbstractionView.this.setControls(AbstractionView.this.displayComponents[tabIndex], AbstractionView.this.getStates(selection));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment((Control)this.disaggregateButton, -5);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment((Control)this.propertyTable, -5);
        this.tabFolder.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.tabFolder, 5);
        formData.right = new FormAttachment(100, -5);
        formData.top = new FormAttachment(0, 5);
        this.propertyLabel.setLayoutData((Object)formData);
        this.createFontSizeActions();
        this.createToolBar();
    }

    private void computePropertyTableWidths() {
        this.propertyTable.getColumn(0).pack();
        int currentWidth = this.propertyTable.getColumn(0).getWidth();
        int newWidth = Math.max(currentWidth, 100);
        this.propertyTable.getColumn(0).setWidth(newWidth);
    }

    private void addPropertyContextMenu() {
        MenuManager menuMgr = new MenuManager("#PropertyPopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AbstractionView.this.fillPropertyContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.propertyTable);
        this.propertyTable.setMenu(menu);
    }

    private void fillPropertyContextMenu(IMenuManager manager) {
        TableItem selected = (TableItem)this.propertyTable.getData();
        TableItem[] selection = this.propertyTable.getSelection();
        if (selection.length > 0) {
            this.propertyTable.deselectAll();
            selected = selection[0];
        }
        if (this.tabFolder.getSelection() != null) {
            manager.add((IAction)this.addPropertyAction);
            if (selected != null) {
                Action renameAction = this.createRenamePropertyAction(selected);
                manager.add((IAction)renameAction);
                Action deleteAction = this.createDeletePropertyAction(selected);
                manager.add((IAction)deleteAction);
            }
        }
        this.propertyTable.setData(null);
    }

    private void addGraphContextMenu(Graph graph) {
        MenuManager menuMgr = new MenuManager("#GraphPopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                int tabIndex = AbstractionView.this.tabFolder.getSelectionIndex();
                if (tabIndex != -1) {
                    AbstractionView.this.fillGraphContextMenu(manager, AbstractionView.this.componentViewers[tabIndex], AbstractionView.this.displayComponents[tabIndex]);
                }
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)graph);
        graph.setMenu(menu);
    }

    private void fillGraphContextMenu(IMenuManager manager, Graph graph, KroneckerDisplayComponent component) {
        ArrayList<KroneckerDisplayState> selected = this.getStates(graph.getSelection().toArray());
        if (selected.size() == 0) {
            return;
        }
        TableItem[] properties = this.propertyTable.getItems();
        KroneckerDisplayPropertyMap propertyMap = component.getPropertyMap();
        int i = 0;
        while (i < properties.length) {
            boolean isTrue = propertyMap.testProperty(properties[i].getText(), selected, true);
            Action setPropertyAction = this.createSetPropertyAction(properties[i].getText(), isTrue);
            manager.add((IAction)setPropertyAction);
            ++i;
        }
    }

    private ArrayList<KroneckerDisplayState> getStates(Object[] selection) {
        ArrayList<KroneckerDisplayState> selectedStates = new ArrayList<KroneckerDisplayState>();
        int i = 0;
        while (i < selection.length) {
            GraphNode node;
            if (selection[i] instanceof GraphNode && (node = (GraphNode)selection[i]).getData() instanceof KroneckerDisplayState) {
                selectedStates.add((KroneckerDisplayState)node.getData());
            }
            ++i;
        }
        return selectedStates;
    }

    private void selectStates(SequentialComponentGraphBuilder builder, ArrayList<KroneckerDisplayState> selection) {
        builder.getGraph().setSelection(this.getGraphNodes(builder, selection));
        this.setControls(builder.getComponent(), selection);
    }

    private void setControls(KroneckerDisplayComponent component, ArrayList<KroneckerDisplayState> selectedStates) {
        if (selectedStates.size() == 0) {
            this.aggregateButton.setEnabled(false);
            this.disaggregateButton.setEnabled(false);
            this.statusLabel.setText("");
            return;
        }
        ArrayList<Short> abstractStates = new ArrayList<Short>(10);
        for (KroneckerDisplayState currentConcrete : selectedStates) {
            short currentAbstract = component.getAbstractState(currentConcrete);
            if (abstractStates.contains(currentAbstract)) continue;
            abstractStates.add(currentAbstract);
        }
        this.disaggregateButton.setEnabled(abstractStates.size() < selectedStates.size());
        this.aggregateButton.setEnabled(abstractStates.size() > 1);
        String text = "Concrete States: " + selectedStates.toString() + " => Abstract States: " + abstractStates.toString();
        this.statusLabel.setText(text);
    }

    private GraphItem[] getGraphNodes(SequentialComponentGraphBuilder builder, ArrayList<KroneckerDisplayState> selection) {
        GraphItem[] nodes = new GraphItem[selection.size()];
        int i = 0;
        for (KroneckerDisplayState state : selection) {
            nodes[i++] = builder.getNode(state, this.useShortNames);
        }
        return nodes;
    }

    private void updateGraphSelection(SequentialComponentGraphBuilder builder, boolean makeSuper) {
        GraphItem[] selectedNodes;
        Object[] selectedStates = builder.getGraph().getSelection().toArray();
        builder.getComponent().clearSelection();
        ArrayList<KroneckerDisplayState> selection = new ArrayList<KroneckerDisplayState>(10);
        ArrayList<GraphNode> selectionMinusStates = new ArrayList<GraphNode>(10);
        KroneckerDisplayPropertyMap propertyMap = builder.getComponent().getPropertyMap();
        int i = 0;
        while (i < selectedStates.length) {
            if (selectedStates[i] instanceof GraphNode) {
                GraphNode node = (GraphNode)selectedStates[i];
                if (node.getData() instanceof KroneckerDisplayState) {
                    KroneckerDisplayState nodeState = (KroneckerDisplayState)node.getData();
                    if (makeSuper || propertyMap.isConsistent(nodeState)) {
                        KroneckerDisplayState[] aggregate = builder.getComponent().getAggregate(nodeState);
                        int j = 0;
                        while (j < aggregate.length) {
                            KroneckerDisplayState state = aggregate[j];
                            if (!selection.contains(state)) {
                                builder.getComponent().selectState(state);
                                selection.add(state);
                            }
                            ++j;
                        }
                    }
                } else {
                    selectionMinusStates.add(node);
                }
            }
            ++i;
        }
        this.setControls(builder.getComponent(), selection);
        if (selection.size() == 0) {
            GraphItem[] selectedActions = new GraphItem[selectionMinusStates.size()];
            selectionMinusStates.toArray(selectedActions);
            selectedNodes = selectedActions;
        } else {
            selectedNodes = this.getGraphNodes(builder, selection);
        }
        builder.getGraph().setSelection(selectedNodes);
    }

    private class GraphSelectionListener
    implements SelectionListener {
        private SequentialComponentGraphBuilder builder;

        public GraphSelectionListener(SequentialComponentGraphBuilder builder) {
            this.builder = builder;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            AbstractionView.this.updateGraphSelection(this.builder, true);
            AbstractionView.this.updatePropertyTable(false);
        }
    }
}

