/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.view.abstractionview;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class PropertyManager {
    private static final int PROPERTY_UNSELECTED = -1;
    private static final int PROPERTY_FALSE = 0;
    private static final int PROPERTY_TRUE = 1;
    private static final int PROPERTY_MAYBE = 2;
    public static final Color COLOR_UNSELECTED = new Color(null, 255, 255, 255);
    public static final Color COLOR_FALSE = new Color(null, 255, 200, 200);
    public static final Color COLOR_TRUE = new Color(null, 200, 255, 200);
    public static final Color COLOR_MAYBE = new Color(null, 200, 200, 200);

    public static TableItem newProperty(Table parent, int style) {
        TableItem property = new TableItem(parent, style);
        PropertyManager.setUnselected(property);
        return property;
    }

    private static int getData(TableItem property) {
        return (Integer)property.getData();
    }

    private static void setData(TableItem property, int data) {
        property.setData((Object)data);
    }

    public static boolean isTrue(TableItem property) {
        return PropertyManager.getData(property) == 1;
    }

    public static void setTrue(TableItem property) {
        PropertyManager.setData(property, 1);
        property.setBackground(COLOR_TRUE);
    }

    public static boolean isFalse(TableItem property) {
        return PropertyManager.getData(property) == 0;
    }

    public static void setFalse(TableItem property) {
        PropertyManager.setData(property, 0);
        property.setBackground(COLOR_FALSE);
    }

    public static boolean isMaybe(TableItem property) {
        return PropertyManager.getData(property) == 2;
    }

    public static void setMaybe(TableItem property) {
        PropertyManager.setData(property, 2);
        property.setBackground(COLOR_MAYBE);
    }

    public static boolean isUnselected(TableItem property) {
        return PropertyManager.getData(property) == -1;
    }

    public static void setUnselected(TableItem property) {
        PropertyManager.setData(property, -1);
        property.setBackground(COLOR_UNSELECTED);
    }

    public static void paint(TableItem property) {
        int data = PropertyManager.getData(property);
        switch (data) {
            case 0: {
                property.setBackground(COLOR_FALSE);
                break;
            }
            case 1: {
                property.setBackground(COLOR_TRUE);
                break;
            }
            case 2: {
                property.setBackground(COLOR_MAYBE);
                break;
            }
            default: {
                property.setBackground(COLOR_UNSELECTED);
            }
        }
    }

    public static void click(TableItem property) {
        if (PropertyManager.isTrue(property)) {
            PropertyManager.setFalse(property);
        } else if (PropertyManager.isFalse(property)) {
            PropertyManager.setUnselected(property);
        } else {
            PropertyManager.setTrue(property);
        }
    }
}

