/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.view.abstractionview;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.IContainer;
import uk.ac.ed.inf.pepa.ctmc.kronecker.KroneckerDisplayAction;
import uk.ac.ed.inf.pepa.ctmc.kronecker.KroneckerDisplayComponent;
import uk.ac.ed.inf.pepa.ctmc.kronecker.KroneckerDisplayState;
import uk.ac.ed.inf.pepa.ctmc.kronecker.KroneckerDisplayTransition;

public class SequentialComponentGraphBuilder {
    private KroneckerDisplayComponent component;
    private Graph graph;
    private HashMap<KroneckerDisplayState, GraphNode> nodeMap = new HashMap();
    private HashMap<KroneckerDisplayAction, GraphNode> actionNodeMap = new HashMap();
    private ArrayList<GraphConnection> connectors = new ArrayList();
    private int numActions;
    private HashMap<Short, Integer> actions = new HashMap();
    private int fontSize = 12;
    private Font stateFont;
    private Font actionFont;

    public SequentialComponentGraphBuilder(KroneckerDisplayComponent component, Graph graph) {
        this.component = component;
        this.graph = graph;
        this.stateFont = new Font(null, "Arial", this.fontSize + 6, 1);
        this.actionFont = new Font(null, "Arial", this.fontSize, 1);
    }

    public void increaseFontSize() {
        Font oldStateFont = this.stateFont;
        Font oldActionFont = this.actionFont;
        ++this.fontSize;
        this.stateFont = new Font(null, "Arial", this.fontSize + 6, 1);
        this.actionFont = new Font(null, "Arial", this.fontSize, 1);
        this.updateNodes();
        oldStateFont.dispose();
        oldActionFont.dispose();
    }

    public void decreaseFontSize() {
        if (this.fontSize > 1) {
            Font oldStateFont = this.stateFont;
            Font oldActionFont = this.actionFont;
            --this.fontSize;
            this.stateFont = new Font(null, "Arial", this.fontSize + 6, 1);
            this.actionFont = new Font(null, "Arial", this.fontSize, 1);
            this.updateNodes();
            oldStateFont.dispose();
            oldActionFont.dispose();
        }
    }

    private void updateNodes() {
        for (GraphNode node : this.nodeMap.values()) {
            node.setFont(this.stateFont);
        }
        for (GraphNode node : this.actionNodeMap.values()) {
            node.setFont(this.actionFont);
        }
    }

    private int getActionNum(short actionID) {
        if (this.actions.containsKey(actionID)) {
            return this.actions.get(actionID);
        }
        int actionNum = this.numActions++;
        this.actions.put(actionID, actionNum);
        return actionNum;
    }

    public GraphNode getNode(KroneckerDisplayState state, boolean useShortNames) {
        GraphNode node = this.nodeMap.get(state);
        if (node == null) {
            node = new GraphNode((IContainer)this.graph, 0, (Object)state);
            node.setBackgroundColor(new Color(null, 255, 200, 100));
            this.nodeMap.put(state, node);
        }
        node.setText(state.getLabel(useShortNames));
        node.setFont(this.stateFont);
        return node;
    }

    public GraphNode getNode(KroneckerDisplayAction action, boolean useShortNames) {
        GraphNode node = this.actionNodeMap.get(action);
        if (node == null) {
            node = new GraphNode((IContainer)this.graph, 0, (Object)action);
            int x = 80 * this.getActionNum(action.getID()) / this.component.getNumActions();
            node.setBackgroundColor(new Color(null, 131 + x, 218 - x, 255));
            this.actionNodeMap.put(action, node);
        }
        node.setText(action.getLabel(useShortNames));
        node.setFont(this.actionFont);
        return node;
    }

    private void addGraphConnection(GraphNode n1, GraphNode n2, double weight) {
        GraphConnection g = new GraphConnection(this.graph, 0, n1, n2);
        g.setConnectionStyle(2);
        g.setWeight(weight);
        g.setLineWidth(2);
        g.setLineColor(ColorConstants.darkGray);
        this.connectors.add(g);
    }

    private void clearConnections() {
        for (GraphConnection connector : this.connectors) {
            connector.dispose();
        }
        this.connectors.clear();
    }

    private void deselectActions() {
        List selection = this.graph.getSelection();
        ArrayList<GraphNode> newSelection = new ArrayList<GraphNode>();
        for (GraphNode node : selection) {
            if (this.actionNodeMap.containsValue(node)) continue;
            newSelection.add(node);
        }
        GraphNode[] selectionArray = new GraphNode[newSelection.size()];
        newSelection.toArray(selectionArray);
        this.graph.setSelection((GraphItem[])selectionArray);
    }

    private void clearActions() {
        this.deselectActions();
        for (GraphNode node : this.actionNodeMap.values()) {
            node.dispose();
        }
        this.actionNodeMap.clear();
    }

    public void build(boolean displayActions, boolean useShortNames) {
        this.clearConnections();
        if (!displayActions) {
            this.clearActions();
        }
        KroneckerDisplayTransition[] transitions = this.component.getTransitions();
        int i = 0;
        while (i < transitions.length) {
            KroneckerDisplayTransition transition = transitions[i];
            GraphNode s1 = this.getNode(transition.getStartState(), useShortNames);
            GraphNode s2 = this.getNode(transition.getEndState(), useShortNames);
            if (displayActions) {
                GraphNode action = this.getNode(transition.getAction(), useShortNames);
                this.addGraphConnection(s1, action, 1.0);
                this.addGraphConnection(action, s2, 0.8);
            } else {
                this.addGraphConnection(s1, s2, 0.8);
            }
            ++i;
        }
    }

    public KroneckerDisplayComponent getComponent() {
        return this.component;
    }

    public Graph getGraph() {
        return this.graph;
    }
}

