/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.view.astview;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import uk.ac.ed.inf.pepa.analysis.IProblem;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.core.ProcessAlgebraModelChangedEvent;
import uk.ac.ed.inf.pepa.eclipse.ui.editor.IProcessAlgebraEditor;
import uk.ac.ed.inf.pepa.eclipse.ui.editor.PEPAEditor;
import uk.ac.ed.inf.pepa.eclipse.ui.view.AbstractView;
import uk.ac.ed.inf.pepa.parsing.ASTNode;
import uk.ac.ed.inf.pepa.parsing.ASTVisitor;
import uk.ac.ed.inf.pepa.parsing.ActionTypeNode;
import uk.ac.ed.inf.pepa.parsing.Actions;
import uk.ac.ed.inf.pepa.parsing.ActivityNode;
import uk.ac.ed.inf.pepa.parsing.AggregationNode;
import uk.ac.ed.inf.pepa.parsing.BinaryOperatorProcessNode;
import uk.ac.ed.inf.pepa.parsing.BinaryOperatorRateNode;
import uk.ac.ed.inf.pepa.parsing.ChoiceNode;
import uk.ac.ed.inf.pepa.parsing.ConstantProcessNode;
import uk.ac.ed.inf.pepa.parsing.CooperationNode;
import uk.ac.ed.inf.pepa.parsing.HidingNode;
import uk.ac.ed.inf.pepa.parsing.ILocationInfo;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.parsing.PassiveRateNode;
import uk.ac.ed.inf.pepa.parsing.PrefixNode;
import uk.ac.ed.inf.pepa.parsing.ProcessDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.RateDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.RateDoubleNode;
import uk.ac.ed.inf.pepa.parsing.UnknownActionTypeNode;
import uk.ac.ed.inf.pepa.parsing.VariableRateNode;
import uk.ac.ed.inf.pepa.parsing.WildcardCooperationNode;

public class ASTView
extends AbstractView {
    private Tree fTree;

    @Override
    protected void updateView(final IProcessAlgebraEditor editor) {
        this.fTree.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ASTView.this.fTree.removeAll();
                if (editor == null || !(editor instanceof PEPAEditor)) {
                    return;
                }
                ModelNode modelNode = ((IPepaModel)editor.getProcessAlgebraModel()).getAST();
                modelNode.accept((ASTVisitor)new TreeVisitor(ASTView.this.fTree));
            }
        });
    }

    @Override
    protected void handleModelChanged(ProcessAlgebraModelChangedEvent event) {
        if (event.getType() == 0) {
            this.updateView(this.fEditor);
        }
    }

    @Override
    public void setFocus() {
        if (this.fTree != null && !this.fTree.isDisposed()) {
            this.fTree.setFocus();
        }
    }

    @Override
    protected void internalCreatePartControl(Composite parent) {
        this.fTree = new Tree(parent, 768);
    }

    private class TreeVisitor
    implements ASTVisitor {
        private TreeItem item;
        private Tree tree;

        public TreeVisitor(TreeItem treeItem) {
            this.item = treeItem;
        }

        public TreeVisitor(Tree tree) {
            this.tree = tree;
        }

        private String getLocation(ASTNode node) {
            ILocationInfo info = node.getLeftLocation();
            return "[" + info.getLine() + "," + info.getColumn() + "]";
        }

        public void visitActivityNode(ActivityNode activity) {
            TreeItem activityItem = new TreeItem(this.item, 0);
            activityItem.setText("Activity " + this.getLocation((ASTNode)activity));
            TreeItem action = new TreeItem(activityItem, 0);
            action.setText("Action");
            activity.getAction().accept((ASTVisitor)new TreeVisitor(action));
            TreeItem rate = new TreeItem(activityItem, 0);
            rate.setText("Rate");
            activity.getRate().accept((ASTVisitor)new TreeVisitor(rate));
        }

        public void visitActionTypeNode(ActionTypeNode actionType) {
            TreeItem actionItem = new TreeItem(this.item, 0);
            actionItem.setText("Action Type " + this.getLocation((ASTNode)actionType));
            TreeItem value = new TreeItem(actionItem, 0);
            value.setText("Name: " + actionType.getType());
        }

        public void visitChoiceNode(ChoiceNode choice) {
            TreeItem choiceItem = new TreeItem(this.item, 0);
            choiceItem.setText("Choice " + this.getLocation((ASTNode)choice));
            this.handleBinaryOperatorProcessNode(choiceItem, (BinaryOperatorProcessNode)choice);
        }

        public void visitConstantProcessNode(ConstantProcessNode constant) {
            TreeItem constantItem = new TreeItem(this.item, 0);
            constantItem.setText("Constant " + this.getLocation((ASTNode)constant));
            TreeItem name = new TreeItem(constantItem, 0);
            name.setText("Name: " + constant.getName());
        }

        public void visitCooperationNode(CooperationNode cooperation) {
            TreeItem coopItem = new TreeItem(this.item, 0);
            coopItem.setText("Cooperation " + this.getLocation((ASTNode)cooperation));
            this.handleBinaryOperatorProcessNode(coopItem, (BinaryOperatorProcessNode)cooperation);
            this.handleActionSet(coopItem, cooperation.getActionSet());
        }

        public void visitHidingNode(HidingNode hiding) {
            TreeItem hidingItem = new TreeItem(this.item, 0);
            hidingItem.setText("Hiding " + this.getLocation((ASTNode)hiding));
            TreeItem process = new TreeItem(hidingItem, 0);
            process.setText("Process");
            hiding.getProcess().accept((ASTVisitor)new TreeVisitor(process));
            this.handleActionSet(hidingItem, hiding.getActionSet());
        }

        private void handleActionSet(TreeItem parent, Actions set) {
            TreeItem actionSet = new TreeItem(parent, 0);
            actionSet.setText("ACTIONS (" + set.size() + ")");
            for (ActionTypeNode actionType : set) {
                actionType.accept((ASTVisitor)new TreeVisitor(actionSet));
            }
        }

        private void handleBinaryOperatorProcessNode(TreeItem parent, BinaryOperatorProcessNode node) {
            TreeItem lhs = new TreeItem(parent, 0);
            lhs.setText("Lhs");
            node.getLeft().accept((ASTVisitor)new TreeVisitor(lhs));
            TreeItem rhs = new TreeItem(parent, 0);
            rhs.setText("Rhs");
            node.getRight().accept((ASTVisitor)new TreeVisitor(rhs));
        }

        public void visitModelNode(ModelNode model) {
            TreeItem rates = new TreeItem(this.tree, 0);
            rates.setText("RATES (" + model.rateDefinitions().size() + ")");
            TreeItem processes = new TreeItem(this.tree, 0);
            processes.setText("PROCESSES (" + model.processDefinitions().size() + ")");
            TreeItem equation = new TreeItem(this.tree, 0);
            equation.setText("System Equation");
            TreeItem problems = new TreeItem(this.tree, 0);
            problems.setText("PROBLEMS (" + model.getProblems().length + ")");
            for (RateDefinitionNode rateDefinition : model.rateDefinitions()) {
                rateDefinition.accept((ASTVisitor)new TreeVisitor(rates));
            }
            for (ProcessDefinitionNode procDef : model.processDefinitions()) {
                procDef.accept((ASTVisitor)new TreeVisitor(processes));
            }
            boolean foundError = false;
            IProblem[] iProblemArray = model.getProblems();
            int n = iProblemArray.length;
            int n2 = 0;
            while (n2 < n) {
                String text;
                IProblem problem = iProblemArray[n2];
                TreeItem aProblem = new TreeItem(problems, 0);
                if (problem.isError()) {
                    text = "Error: ";
                    foundError = true;
                } else {
                    text = "Warning: ";
                }
                aProblem.setText(String.valueOf(text) + problem.getMessage());
                ++n2;
            }
            if (!foundError) {
                model.getSystemEquation().accept((ASTVisitor)new TreeVisitor(equation));
            }
        }

        public void visitPassiveRateNode(PassiveRateNode passive) {
            TreeItem passiveValue = new TreeItem(this.item, 0);
            passiveValue.setText("Passive " + this.getLocation((ASTNode)passive));
            TreeItem v = new TreeItem(passiveValue, 0);
            v.setText("Multiplicity: " + passive.getMultiplicity());
        }

        public void visitPrefixNode(PrefixNode prefix) {
            TreeItem prefixItem = new TreeItem(this.item, 0);
            prefixItem.setText("Prefix " + this.getLocation((ASTNode)prefix));
            TreeItem activity = new TreeItem(prefixItem, 0);
            activity.setText("Activity");
            prefix.getActivity().accept((ASTVisitor)new TreeVisitor(activity));
            TreeItem target = new TreeItem(prefixItem, 0);
            target.setText("Target");
            prefix.getTarget().accept((ASTVisitor)new TreeVisitor(target));
        }

        public void visitProcessDefinitionNode(ProcessDefinitionNode processDefinition) {
            TreeItem processDefinitionItem = new TreeItem(this.item, 0);
            processDefinitionItem.setText("Process definition " + this.getLocation((ASTNode)processDefinition));
            TreeItem name = new TreeItem(processDefinitionItem, 0);
            name.setText("Name");
            processDefinition.getName().accept((ASTVisitor)new TreeVisitor(name));
            TreeItem value = new TreeItem(processDefinitionItem, 0);
            value.setText("Process");
            processDefinition.getNode().accept((ASTVisitor)new TreeVisitor(value));
        }

        public void visitRateDefinitionNode(RateDefinitionNode rateDefinition) {
            TreeItem rate = new TreeItem(this.item, 0);
            rate.setText("Rate definition " + this.getLocation((ASTNode)rateDefinition));
            TreeItem name = new TreeItem(rate, 0);
            name.setText("Name");
            rateDefinition.getName().accept((ASTVisitor)new TreeVisitor(name));
            TreeItem value = new TreeItem(rate, 0);
            value.setText("Value");
            rateDefinition.getRate().accept((ASTVisitor)new TreeVisitor(value));
        }

        public void visitRateDoubleNode(RateDoubleNode doubleRate) {
            TreeItem doubleValue = new TreeItem(this.item, 0);
            doubleValue.setText("Double " + this.getLocation((ASTNode)doubleRate));
            TreeItem v = new TreeItem(doubleValue, 0);
            v.setText("Value: " + doubleRate.getValue());
        }

        public void visitVariableRateNode(VariableRateNode variableRate) {
            TreeItem varItem = new TreeItem(this.item, 0);
            varItem.setText("Variable Rate " + this.getLocation((ASTNode)variableRate));
            TreeItem name = new TreeItem(varItem, 0);
            name.setText("Name: " + variableRate.getName());
        }

        public void visitBinaryOperatorRateNode(BinaryOperatorRateNode rate) {
            TreeItem binItem = new TreeItem(this.item, 0);
            binItem.setText("Binary Operator " + this.getLocation((ASTNode)rate));
            TreeItem lhs = new TreeItem(binItem, 0);
            lhs.setText("Lhs");
            rate.getLeft().accept((ASTVisitor)new TreeVisitor(lhs));
            TreeItem rhs = new TreeItem(binItem, 0);
            rhs.setText("Rhs");
            rate.getRight().accept((ASTVisitor)new TreeVisitor(rhs));
            TreeItem operator = new TreeItem(binItem, 0);
            operator.setText("Operator: " + rate.getOperator().name());
        }

        public void visitAggregationNode(AggregationNode aggregation) {
            TreeItem aggrItem = new TreeItem(this.item, 0);
            aggrItem.setText("Aggregation " + this.getLocation((ASTNode)aggregation));
            TreeItem process = new TreeItem(aggrItem, 0);
            process.setText("Process");
            aggregation.getProcessNode().accept((ASTVisitor)new TreeVisitor(process));
            TreeItem copies = new TreeItem(aggrItem, 0);
            copies.setText("Copies");
            aggregation.getCopies().accept((ASTVisitor)new TreeVisitor(copies));
        }

        public void visitUnknownActionTypeNode(UnknownActionTypeNode unknownActionTypeNode) {
            TreeItem actionItem = new TreeItem(this.item, 0);
            actionItem.setText("TAU " + this.getLocation((ASTNode)unknownActionTypeNode));
        }

        public void visitWildcardCooperationNode(WildcardCooperationNode cooperation) {
            TreeItem coopItem = new TreeItem(this.item, 0);
            coopItem.setText("Cooperation " + this.getLocation((ASTNode)cooperation));
            this.handleBinaryOperatorProcessNode(coopItem, (BinaryOperatorProcessNode)cooperation);
            TreeItem actionSet = new TreeItem(coopItem, 0);
            actionSet.setText("ACTIONS (*)");
        }
    }
}

