/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.view.modelcheckingview;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import uk.ac.ed.inf.pepa.ctmc.kronecker.KroneckerDisplayModel;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAbstractPathProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAbstractProbability;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAbstractProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAbstractStateProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAndNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAtomicNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLBooleanNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLDouble;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLImpliesNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLNextNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLNotNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLOrNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLPathPlaceHolder;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLPathPropertyNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLProbabilityComparator;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLProbabilityTest;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLStatePlaceHolder;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLSteadyStateNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLTimeInterval;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLUntilNode;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.StringPosition;

public class EditCSLDialog
extends Dialog {
    private static final Font PROPERTY_FONT = new Font(null, "Ariel", 14, 1);
    private static final Color SELECTED_BG_COLOR = new Color(null, 255, 240, 153);
    private static final Color SELECTED_FG_COLOR = new Color(null, 0, 0, 0);
    private KroneckerDisplayModel model;
    private String name;
    private CSLAbstractStateProperty newProperty;
    private Text nameText;
    private StyledText propertyText;
    private Button steadyStateButton;
    private Button pathPropertyButton;
    private Button nextButton;
    private Button untilButton;
    private Button andButton;
    private Button orButton;
    private Button notButton;
    private Button impliesButton;
    private Button atomicButton;
    private Button trueButton;
    private Button falseButton;
    private Menu atomicMenu;
    private Menu steadyStateMenu;
    private Menu pathPropertyMenu;
    private Menu nextMenu;
    private Menu untilMenu;
    private StringPosition currentSelection = null;

    public EditCSLDialog(Shell parentShell, KroneckerDisplayModel model, String name, CSLAbstractStateProperty property) {
        super(parentShell);
        this.model = model;
        this.name = name;
        this.newProperty = property.copy();
    }

    private void selectPathButtons() {
        this.steadyStateButton.setEnabled(false);
        this.pathPropertyButton.setEnabled(false);
        this.nextButton.setEnabled(true);
        this.untilButton.setEnabled(true);
        this.andButton.setEnabled(false);
        this.orButton.setEnabled(false);
        this.notButton.setEnabled(false);
        this.impliesButton.setEnabled(false);
        this.atomicButton.setEnabled(false);
        this.trueButton.setEnabled(false);
        this.falseButton.setEnabled(false);
    }

    private void selectStateButtons() {
        boolean enableLogic = true;
        boolean enablePath = true;
        boolean enableSteadyState = true;
        if (this.currentSelection != null && this.currentSelection.getObject().isProbabilityTest()) {
            enableLogic = false;
            if (this.currentSelection.getObject() instanceof CSLPathPropertyNode) {
                enableSteadyState = false;
            } else {
                enablePath = false;
            }
        }
        this.steadyStateButton.setEnabled(enableSteadyState);
        this.pathPropertyButton.setEnabled(enablePath);
        this.nextButton.setEnabled(false);
        this.untilButton.setEnabled(false);
        this.andButton.setEnabled(enableLogic);
        this.orButton.setEnabled(enableLogic);
        this.notButton.setEnabled(enableLogic);
        this.impliesButton.setEnabled(enableLogic);
        this.atomicButton.setEnabled(true);
        this.trueButton.setEnabled(true);
        this.falseButton.setEnabled(true);
    }

    private void deselectButtons() {
        this.steadyStateButton.setEnabled(false);
        this.pathPropertyButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.untilButton.setEnabled(false);
        this.andButton.setEnabled(false);
        this.orButton.setEnabled(false);
        this.notButton.setEnabled(false);
        this.impliesButton.setEnabled(false);
        this.atomicButton.setEnabled(false);
        this.trueButton.setEnabled(false);
        this.falseButton.setEnabled(false);
    }

    private Menu createAtomicMenu() {
        Menu menu = new Menu((Decorations)this.getShell(), 8);
        String[] atomicProperties = this.model.getAtomicProperties();
        int i = 0;
        while (i < atomicProperties.length) {
            final String propertyName = atomicProperties[i];
            MenuItem propertyItem = new MenuItem(menu, 8);
            propertyItem.setText(propertyName);
            propertyItem.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    CSLAtomicNode property = new CSLAtomicNode(propertyName);
                    EditCSLDialog.this.newProperty = EditCSLDialog.this.newProperty.replace(EditCSLDialog.this.currentSelection.getObject(), (CSLAbstractProperty)property);
                    EditCSLDialog.this.updateSelection((CSLAbstractProperty)property);
                }
            });
            ++i;
        }
        return menu;
    }

    private Menu createStateMenu(final boolean isSteadyState) {
        Menu menu = new Menu((Decorations)this.getShell(), 8);
        MenuItem testItem = new MenuItem(menu, 8);
        testItem.setText("[=?] Test Probability");
        testItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                EditCSLDialog.this.addStateProperty(isSteadyState, (CSLAbstractProbability)new CSLProbabilityTest());
            }
        });
        MenuItem compareGTItem = new MenuItem(menu, 8);
        compareGTItem.setText("[<P] Probability Less Than P");
        compareGTItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                EditCSLDialog.this.addStateProperty(isSteadyState, (CSLAbstractProbability)new CSLProbabilityComparator(true, new CSLDouble(true, 1.0)));
            }
        });
        MenuItem compareLTItem = new MenuItem(menu, 8);
        compareLTItem.setText("[>P] Probability Greater Than P");
        compareLTItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                EditCSLDialog.this.addStateProperty(isSteadyState, (CSLAbstractProbability)new CSLProbabilityComparator(false, new CSLDouble(true, 0.0)));
            }
        });
        return menu;
    }

    private void addStateProperty(boolean isSteadyState, CSLAbstractProbability comparator) {
        Object property = isSteadyState ? (this.currentSelection.getObject() instanceof CSLSteadyStateNode ? new CSLSteadyStateNode(this.getStateChild(1, this.currentSelection.getObject()), comparator) : new CSLSteadyStateNode(this.getState(this.currentSelection.getObject()), comparator)) : new CSLPathPropertyNode(this.getPathChild(this.currentSelection.getObject()), comparator);
        this.newProperty = this.newProperty.replace(this.currentSelection.getObject(), (CSLAbstractProperty)property);
        this.updateSelection((CSLAbstractProperty)property);
    }

    private Menu createPathMenu(final boolean isNext) {
        Menu menu = new Menu((Decorations)this.getShell(), 8);
        MenuItem unboundedItem = new MenuItem(menu, 8);
        unboundedItem.setText("[-,-] Unbounded");
        unboundedItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                EditCSLDialog.this.addPathProperty(isNext, new CSLTimeInterval());
            }
        });
        MenuItem lowerBoundItem = new MenuItem(menu, 8);
        lowerBoundItem.setText("[t,-] Lower Bound");
        lowerBoundItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                EditCSLDialog.this.addPathProperty(isNext, new CSLTimeInterval(new CSLDouble(false, 0.0), true));
            }
        });
        MenuItem upperBoundItem = new MenuItem(menu, 8);
        upperBoundItem.setText("[-,t] Upper Bound");
        upperBoundItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                EditCSLDialog.this.addPathProperty(isNext, new CSLTimeInterval(new CSLDouble(false, 0.0), false));
            }
        });
        MenuItem boundedItem = new MenuItem(menu, 8);
        boundedItem.setText("[t,t] Bounded");
        boundedItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                EditCSLDialog.this.addPathProperty(isNext, new CSLTimeInterval(new CSLDouble(false, 0.0), new CSLDouble(false, 0.0)));
            }
        });
        if (isNext) {
            lowerBoundItem.setEnabled(false);
            upperBoundItem.setEnabled(false);
            boundedItem.setEnabled(false);
        }
        return menu;
    }

    private void addPathProperty(boolean isNext, CSLTimeInterval interval) {
        Object property = isNext ? new CSLNextNode(this.getStateChild(1, this.currentSelection.getObject()), interval) : new CSLUntilNode(this.getStateChild(1, this.currentSelection.getObject()), this.getStateChild(2, this.currentSelection.getObject()), interval);
        this.newProperty = this.newProperty.replace(this.currentSelection.getObject(), (CSLAbstractProperty)property);
        this.updateSelection((CSLAbstractProperty)property);
    }

    private void createMenus() {
        this.steadyStateMenu = this.createStateMenu(true);
        this.pathPropertyMenu = this.createStateMenu(false);
        this.nextMenu = this.createPathMenu(true);
        this.untilMenu = this.createPathMenu(false);
        this.atomicMenu = this.createAtomicMenu();
    }

    private CSLAbstractStateProperty getState(CSLAbstractProperty property) {
        if (property instanceof CSLAbstractStateProperty) {
            return (CSLAbstractStateProperty)property.copy();
        }
        return new CSLStatePlaceHolder();
    }

    private CSLAbstractStateProperty getStateChild(int number, CSLAbstractProperty property) {
        StringPosition[] children = property.getChildren();
        int count = 0;
        int i = 0;
        while (i < children.length) {
            CSLAbstractProperty child = children[i].getObject();
            if (child instanceof CSLAbstractStateProperty && ++count == number) {
                return (CSLAbstractStateProperty)child;
            }
            ++i;
        }
        return new CSLStatePlaceHolder();
    }

    private CSLAbstractPathProperty getPathChild(CSLAbstractProperty property) {
        StringPosition[] children = property.getChildren();
        int i = 0;
        while (i < children.length) {
            CSLAbstractProperty child = children[i].getObject();
            if (child instanceof CSLAbstractPathProperty) {
                return (CSLAbstractPathProperty)child;
            }
            ++i;
        }
        return new CSLPathPlaceHolder();
    }

    private void updateSelection() {
        int index = this.propertyText.getCaretOffset();
        StringPosition position = this.newProperty.objectAt(index);
        if (position == null) {
            return;
        }
        this.propertyText.setSelection(position.getStart(), position.getEnd());
        this.currentSelection = position;
        if (this.currentSelection.getObject() instanceof CSLAbstractStateProperty) {
            this.selectStateButtons();
        } else if (this.currentSelection.getObject() instanceof CSLAbstractPathProperty) {
            this.selectPathButtons();
        } else {
            this.deselectButtons();
        }
        if (this.propertyText.getEditable()) {
            String text = this.newProperty.toString();
            if (!this.propertyText.getText().equals(text)) {
                this.propertyText.setText(text);
                this.clearSelection();
            }
        }
        this.setEditable();
    }

    private void setEditable() {
        boolean canEdit = this.currentSelection != null && this.currentSelection.getObject() instanceof CSLDouble;
        this.propertyText.setEditable(canEdit);
    }

    private void deleteSelection() {
        CSLAbstractStateProperty replacement = null;
        if (this.currentSelection != null) {
            if (this.currentSelection.getObject() instanceof CSLAbstractStateProperty) {
                replacement = this.getStateChild(1, this.currentSelection.getObject());
            } else if (this.currentSelection.getObject() instanceof CSLAbstractPathProperty) {
                replacement = new CSLPathPlaceHolder();
            }
        }
        if (replacement != null) {
            this.newProperty = this.newProperty.replace(this.currentSelection.getObject(), replacement);
            this.updateSelection((CSLAbstractProperty)replacement);
        }
    }

    private void clearSelection() {
        this.propertyText.selectAll();
        this.propertyText.setSelection(0);
        this.currentSelection = null;
        this.deselectButtons();
        this.setEditable();
    }

    private void updateSelection(CSLAbstractProperty newSelection) {
        this.propertyText.setText(this.newProperty.toString());
        if (this.currentSelection != null) {
            StringPosition position = this.newProperty.indexOf(newSelection);
            this.propertyText.setSelection(position.getStart(), position.getEnd());
            this.currentSelection = position;
            if (this.currentSelection.getObject() instanceof CSLAbstractStateProperty) {
                this.selectStateButtons();
            }
        } else {
            this.clearSelection();
        }
        this.setEditable();
    }

    private void updateHighlighting() {
        if (this.currentSelection != null) {
            this.propertyText.setSelection(this.currentSelection.getStart(), this.currentSelection.getEnd());
        } else {
            this.clearSelection();
        }
    }

    private Composite createStatePropertyButtons(Composite parent) {
        final Group buttonFrame = new Group(parent, 0);
        buttonFrame.setText("State");
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        buttonFrame.setLayout((Layout)layout);
        this.steadyStateButton = new Button((Composite)buttonFrame, 8);
        this.steadyStateButton.setText("Steady State");
        this.steadyStateButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Rectangle rect = EditCSLDialog.this.steadyStateButton.getBounds();
                Point position = new Point(rect.x + rect.width, rect.y);
                position = buttonFrame.toDisplay(position);
                EditCSLDialog.this.steadyStateMenu.setLocation(position);
                boolean canBeQuestion = EditCSLDialog.this.currentSelection.getObject() == EditCSLDialog.this.newProperty;
                EditCSLDialog.this.steadyStateMenu.getItem(0).setEnabled(canBeQuestion);
                EditCSLDialog.this.steadyStateMenu.setVisible(true);
            }
        });
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        this.steadyStateButton.setLayoutData((Object)layoutData);
        this.pathPropertyButton = new Button((Composite)buttonFrame, 8);
        this.pathPropertyButton.setText("Path Property");
        this.pathPropertyButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Rectangle rect = EditCSLDialog.this.pathPropertyButton.getBounds();
                Point position = new Point(rect.x + rect.width, rect.y);
                position = buttonFrame.toDisplay(position);
                EditCSLDialog.this.pathPropertyMenu.setLocation(position);
                boolean canBeQuestion = EditCSLDialog.this.currentSelection.getObject() == EditCSLDialog.this.newProperty;
                EditCSLDialog.this.pathPropertyMenu.getItem(0).setEnabled(canBeQuestion);
                EditCSLDialog.this.pathPropertyMenu.setVisible(true);
            }
        });
        layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        this.pathPropertyButton.setLayoutData((Object)layoutData);
        return buttonFrame;
    }

    private Composite createPathPropertyButtons(Composite parent) {
        final Group buttonFrame = new Group(parent, 0);
        buttonFrame.setText("Path");
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        buttonFrame.setLayout((Layout)layout);
        this.nextButton = new Button((Composite)buttonFrame, 8);
        this.nextButton.setText("Next Operator");
        this.nextButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Rectangle rect = EditCSLDialog.this.nextButton.getBounds();
                Point position = new Point(rect.x + rect.width, rect.y);
                position = buttonFrame.toDisplay(position);
                EditCSLDialog.this.nextMenu.setLocation(position);
                EditCSLDialog.this.nextMenu.setVisible(true);
            }
        });
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        this.nextButton.setLayoutData((Object)layoutData);
        this.untilButton = new Button((Composite)buttonFrame, 8);
        this.untilButton.setText("Until Operator");
        this.untilButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Rectangle rect = EditCSLDialog.this.untilButton.getBounds();
                Point position = new Point(rect.x + rect.width, rect.y);
                position = buttonFrame.toDisplay(position);
                EditCSLDialog.this.untilMenu.setLocation(position);
                EditCSLDialog.this.untilMenu.setVisible(true);
            }
        });
        layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        this.untilButton.setLayoutData((Object)layoutData);
        return buttonFrame;
    }

    private Composite createLogicPropertyButtons(Composite parent) {
        Group buttonFrame = new Group(parent, 0);
        buttonFrame.setText("Logic");
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        buttonFrame.setLayout((Layout)layout);
        this.andButton = new Button((Composite)buttonFrame, 8);
        this.andButton.setText("/\\");
        this.andButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CSLAndNode property = EditCSLDialog.this.currentSelection.getObject() instanceof CSLAndNode || EditCSLDialog.this.currentSelection.getObject() instanceof CSLOrNode || EditCSLDialog.this.currentSelection.getObject() instanceof CSLImpliesNode ? new CSLAndNode(EditCSLDialog.this.getStateChild(1, EditCSLDialog.this.currentSelection.getObject()), EditCSLDialog.this.getStateChild(2, EditCSLDialog.this.currentSelection.getObject())) : new CSLAndNode(EditCSLDialog.this.getState(EditCSLDialog.this.currentSelection.getObject()), EditCSLDialog.this.getState(EditCSLDialog.this.currentSelection.getObject()));
                EditCSLDialog.this.newProperty = EditCSLDialog.this.newProperty.replace(EditCSLDialog.this.currentSelection.getObject(), (CSLAbstractProperty)property);
                EditCSLDialog.this.updateSelection((CSLAbstractProperty)property);
            }
        });
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        this.andButton.setLayoutData((Object)layoutData);
        this.orButton = new Button((Composite)buttonFrame, 8);
        this.orButton.setText("\\/");
        this.orButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CSLOrNode property = EditCSLDialog.this.currentSelection.getObject() instanceof CSLAndNode || EditCSLDialog.this.currentSelection.getObject() instanceof CSLOrNode || EditCSLDialog.this.currentSelection.getObject() instanceof CSLImpliesNode ? new CSLOrNode(EditCSLDialog.this.getStateChild(1, EditCSLDialog.this.currentSelection.getObject()), EditCSLDialog.this.getStateChild(2, EditCSLDialog.this.currentSelection.getObject())) : new CSLOrNode(EditCSLDialog.this.getState(EditCSLDialog.this.currentSelection.getObject()), EditCSLDialog.this.getState(EditCSLDialog.this.currentSelection.getObject()));
                EditCSLDialog.this.newProperty = EditCSLDialog.this.newProperty.replace(EditCSLDialog.this.currentSelection.getObject(), (CSLAbstractProperty)property);
                EditCSLDialog.this.updateSelection((CSLAbstractProperty)property);
            }
        });
        layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        this.orButton.setLayoutData((Object)layoutData);
        this.notButton = new Button((Composite)buttonFrame, 8);
        this.notButton.setText("\u00ac");
        this.notButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Object property = EditCSLDialog.this.currentSelection.getObject() instanceof CSLNotNode ? EditCSLDialog.this.getStateChild(1, EditCSLDialog.this.currentSelection.getObject()) : new CSLNotNode(EditCSLDialog.this.getState(EditCSLDialog.this.currentSelection.getObject()));
                EditCSLDialog.this.newProperty = EditCSLDialog.this.newProperty.replace(EditCSLDialog.this.currentSelection.getObject(), (CSLAbstractProperty)property);
                EditCSLDialog.this.updateSelection((CSLAbstractProperty)property);
            }
        });
        layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        this.notButton.setLayoutData((Object)layoutData);
        this.impliesButton = new Button((Composite)buttonFrame, 8);
        this.impliesButton.setText("=>");
        this.impliesButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CSLImpliesNode property = EditCSLDialog.this.currentSelection.getObject() instanceof CSLAndNode || EditCSLDialog.this.currentSelection.getObject() instanceof CSLOrNode || EditCSLDialog.this.currentSelection.getObject() instanceof CSLImpliesNode ? new CSLImpliesNode(EditCSLDialog.this.getStateChild(1, EditCSLDialog.this.currentSelection.getObject()), EditCSLDialog.this.getStateChild(2, EditCSLDialog.this.currentSelection.getObject())) : new CSLImpliesNode(EditCSLDialog.this.getState(EditCSLDialog.this.currentSelection.getObject()), EditCSLDialog.this.getState(EditCSLDialog.this.currentSelection.getObject()));
                EditCSLDialog.this.newProperty = EditCSLDialog.this.newProperty.replace(EditCSLDialog.this.currentSelection.getObject(), (CSLAbstractProperty)property);
                EditCSLDialog.this.updateSelection((CSLAbstractProperty)property);
            }
        });
        layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        this.impliesButton.setLayoutData((Object)layoutData);
        return buttonFrame;
    }

    private Composite createAtomicPropertyButtons(Composite parent) {
        final Group buttonFrame = new Group(parent, 0);
        buttonFrame.setText("Atomic");
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        buttonFrame.setLayout((Layout)layout);
        this.atomicButton = new Button((Composite)buttonFrame, 8);
        this.atomicButton.setText("Atomic Property");
        this.atomicButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Rectangle rect = EditCSLDialog.this.atomicButton.getBounds();
                Point position = new Point(rect.x + rect.width, rect.y);
                position = buttonFrame.toDisplay(position);
                EditCSLDialog.this.atomicMenu.setLocation(position);
                EditCSLDialog.this.atomicMenu.setVisible(true);
            }
        });
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.horizontalSpan = 2;
        layoutData.grabExcessHorizontalSpace = true;
        this.atomicButton.setLayoutData((Object)layoutData);
        this.trueButton = new Button((Composite)buttonFrame, 8);
        this.trueButton.setText("True");
        this.trueButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CSLBooleanNode property = new CSLBooleanNode(true);
                EditCSLDialog.this.newProperty = EditCSLDialog.this.newProperty.replace(EditCSLDialog.this.currentSelection.getObject(), (CSLAbstractProperty)property);
                EditCSLDialog.this.updateSelection((CSLAbstractProperty)property);
            }
        });
        layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        this.trueButton.setLayoutData((Object)layoutData);
        this.falseButton = new Button((Composite)buttonFrame, 8);
        this.falseButton.setText("False");
        this.falseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CSLBooleanNode property = new CSLBooleanNode(false);
                EditCSLDialog.this.newProperty = EditCSLDialog.this.newProperty.replace(EditCSLDialog.this.currentSelection.getObject(), (CSLAbstractProperty)property);
                EditCSLDialog.this.updateSelection((CSLAbstractProperty)property);
            }
        });
        layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        this.falseButton.setLayoutData((Object)layoutData);
        return buttonFrame;
    }

    protected Control createDialogArea(Composite parent) {
        Composite viewFrame = new Composite(parent, 0);
        viewFrame.setLayout((Layout)new FormLayout());
        Label nameLabel = new Label(viewFrame, 0);
        nameLabel.setText("Name:");
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 10);
        formData.left = new FormAttachment(0, 5);
        nameLabel.setLayoutData((Object)formData);
        this.nameText = new Text(viewFrame, 2048);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditCSLDialog.this.setOKEnabled();
            }
        });
        this.nameText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                EditCSLDialog.this.updateSelection();
                EditCSLDialog.this.clearSelection();
            }

            public void focusLost(FocusEvent e) {
            }
        });
        formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment((Control)nameLabel, 5);
        formData.right = new FormAttachment(100, -5);
        this.nameText.setLayoutData((Object)formData);
        this.propertyText = new StyledText(viewFrame, 2114);
        this.propertyText.setFont(PROPERTY_FONT);
        this.propertyText.setAlignment(0x1000000);
        this.propertyText.setEditable(false);
        this.propertyText.setDoubleClickEnabled(false);
        this.propertyText.setDragDetect(true);
        this.propertyText.setSelectionBackground(SELECTED_BG_COLOR);
        this.propertyText.setSelectionForeground(SELECTED_FG_COLOR);
        this.propertyText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                EditCSLDialog.this.updateSelection();
            }
        });
        this.propertyText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (EditCSLDialog.this.propertyText.getEditable()) {
                    if (EditCSLDialog.this.propertyText.getCaretOffset() < EditCSLDialog.this.currentSelection.getStart()) {
                        EditCSLDialog.this.propertyText.setSelection(EditCSLDialog.this.currentSelection.getStart());
                    } else if (EditCSLDialog.this.propertyText.getCaretOffset() > EditCSLDialog.this.currentSelection.getEnd()) {
                        EditCSLDialog.this.propertyText.setSelection(EditCSLDialog.this.currentSelection.getEnd());
                    }
                    if (e.character == '\r') {
                        EditCSLDialog.this.updateSelection();
                    }
                } else if (e.character == '\u007f' || e.character == '\b') {
                    EditCSLDialog.this.deleteSelection();
                } else {
                    EditCSLDialog.this.updateSelection();
                }
            }
        });
        this.propertyText.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent e) {
                if (!EditCSLDialog.this.propertyText.getEditable()) {
                    return;
                }
                e.doit = false;
                int position = ((EditCSLDialog)EditCSLDialog.this).propertyText.getSelection().y;
                if (e.character == '\r') {
                    EditCSLDialog.this.updateSelection();
                } else if (e.keyCode >= 48 && e.keyCode <= 57 || e.keyCode == 46) {
                    EditCSLDialog.this.currentSelection.incrementEnd(1);
                    e.doit = true;
                } else if (e.character == '\u007f' && position < EditCSLDialog.this.currentSelection.getEnd()) {
                    EditCSLDialog.this.currentSelection.incrementEnd(-1);
                    e.doit = true;
                } else if (e.character == '\b' && position > EditCSLDialog.this.currentSelection.getStart()) {
                    EditCSLDialog.this.currentSelection.incrementEnd(-1);
                    e.doit = true;
                }
                if (e.doit) {
                    EditCSLDialog.this.propertyText.setSelection(position);
                }
            }
        });
        this.propertyText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (EditCSLDialog.this.propertyText.getEditable() && EditCSLDialog.this.currentSelection.getObject() instanceof CSLDouble) {
                    CSLDouble value = (CSLDouble)EditCSLDialog.this.currentSelection.getObject();
                    if (EditCSLDialog.this.currentSelection.getStart() < EditCSLDialog.this.currentSelection.getEnd()) {
                        String newText = EditCSLDialog.this.propertyText.getText(EditCSLDialog.this.currentSelection.getStart(), EditCSLDialog.this.currentSelection.getEnd() - 1);
                        double newValue = value.getValue();
                        try {
                            newValue = Double.parseDouble(newText);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        if (newValue != value.getValue()) {
                            value.setValue(newValue);
                        }
                    }
                    EditCSLDialog.this.updateHighlighting();
                }
                EditCSLDialog.this.setOKEnabled();
            }
        });
        GC gc = new GC((Drawable)this.propertyText);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.nameText, 5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        formData.height = 3 * gc.getFontMetrics().getHeight();
        this.propertyText.setLayoutData((Object)formData);
        Composite statePropertyButtons = this.createStatePropertyButtons(viewFrame);
        formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.top = new FormAttachment((Control)this.propertyText, 5);
        statePropertyButtons.setLayoutData((Object)formData);
        Composite pathPropertyButtons = this.createPathPropertyButtons(viewFrame);
        formData = new FormData();
        formData.left = new FormAttachment((Control)statePropertyButtons, 5);
        formData.top = new FormAttachment((Control)this.propertyText, 5);
        pathPropertyButtons.setLayoutData((Object)formData);
        Composite logicPropertyButtons = this.createLogicPropertyButtons(viewFrame);
        formData = new FormData();
        formData.left = new FormAttachment((Control)pathPropertyButtons, 5);
        formData.top = new FormAttachment((Control)this.propertyText, 5);
        logicPropertyButtons.setLayoutData((Object)formData);
        Composite atomicPropertyButtons = this.createAtomicPropertyButtons(viewFrame);
        formData = new FormData();
        formData.left = new FormAttachment((Control)logicPropertyButtons, 5);
        formData.top = new FormAttachment((Control)this.propertyText, 5);
        formData.right = new FormAttachment(100, -5);
        atomicPropertyButtons.setLayoutData((Object)formData);
        this.createMenus();
        this.deselectButtons();
        return viewFrame;
    }

    public void create() {
        super.create();
        this.nameText.setText(this.name);
        this.propertyText.setText(this.newProperty.toString());
    }

    private void setOKEnabled() {
        if (this.getButton(0) == null) {
            return;
        }
        String newName = this.nameText.getText();
        boolean isNameOK = newName.length() > 0;
        boolean isNameUnique = newName.equals(this.name) || !this.model.containsCSLPropertyName(newName);
        boolean isPropertyOK = !this.newProperty.containsPlaceHolder();
        boolean isOK = isNameOK && isNameUnique && isPropertyOK;
        this.getButton(0).setEnabled(isOK);
        int defaultButton = isOK ? 0 : 1;
        Shell shell = this.getShell();
        if (shell != null) {
            shell.setDefaultButton(this.getButton(defaultButton));
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.setOKEnabled();
    }

    public CSLAbstractStateProperty getNewProperty() {
        return this.newProperty;
    }

    public String getNewName() {
        return this.name;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Edit CSL Property");
    }

    protected void okPressed() {
        String newName = this.nameText.getText();
        if (newName.length() > 0) {
            this.name = newName;
        }
        super.okPressed();
    }
}

