/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.view.modelcheckingview;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import uk.ac.ed.inf.pepa.ctmc.kronecker.KroneckerDisplayModel;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.AbstractBoolean;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAbstractStateProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLStatePlaceHolder;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.IPropertyChangedListener;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.ProbabilityInterval;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.core.PEPAModelChecker;
import uk.ac.ed.inf.pepa.eclipse.core.ProcessAlgebraModelChangedEvent;
import uk.ac.ed.inf.pepa.eclipse.ui.editor.IProcessAlgebraEditor;
import uk.ac.ed.inf.pepa.eclipse.ui.editor.PEPAEditor;
import uk.ac.ed.inf.pepa.eclipse.ui.view.AbstractView;
import uk.ac.ed.inf.pepa.eclipse.ui.view.abstractionview.PropertyManager;
import uk.ac.ed.inf.pepa.eclipse.ui.view.modelcheckingview.EditCSLDialog;

public class ModelCheckingView
extends AbstractView
implements IPropertyChangedListener {
    private Composite modelCheckingView;
    private Table propertyTable;
    private Button modelCheckButton;
    private Text boundAccuracyText;
    private Label boundAccuracyLabel;
    private Action newPropertyAction;
    private KroneckerDisplayModel model;
    private IPepaModel pepaModel;

    private void createNewPropertyAction() {
        this.newPropertyAction = new Action("New CSL Property"){

            public void run() {
                EditCSLDialog editDialog = new EditCSLDialog(ModelCheckingView.this.getSite().getShell(), ModelCheckingView.this.model, "", (CSLAbstractStateProperty)new CSLStatePlaceHolder());
                if (editDialog.open() != 0) {
                    return;
                }
                String name = editDialog.getNewName();
                CSLAbstractStateProperty property = editDialog.getNewProperty();
                ModelCheckingView.this.model.addCSLProperty(name, property);
                ModelCheckingView.this.handlePropertiesChanged();
                ModelCheckingView.this.checkProperty(name);
            }
        };
    }

    private void editProperty(TableItem selected) {
        String name = selected.getText(1);
        CSLAbstractStateProperty property = this.model.getCSLProperty(name);
        EditCSLDialog editDialog = new EditCSLDialog(this.getSite().getShell(), this.model, name, property);
        if (editDialog.open() != 0) {
            return;
        }
        String newName = editDialog.getNewName();
        CSLAbstractStateProperty newProperty = editDialog.getNewProperty();
        this.model.changeCSLProperty(name, property, newName, newProperty);
        this.handlePropertiesChanged();
        this.checkProperty(name);
    }

    private Action createEditPropertyAction(final TableItem selected) {
        Action editPropertyAction = new Action("Edit"){

            public void run() {
                ModelCheckingView.this.editProperty(selected);
            }
        };
        return editPropertyAction;
    }

    private Action createDeletePropertyAction(final TableItem[] selection) {
        Action deletePropertyAction = new Action("Delete"){

            public void run() {
                int i = 0;
                while (i < selection.length) {
                    TableItem selected = selection[i];
                    ModelCheckingView.this.model.removeCSLProperty(selected.getText(1));
                    int index = ModelCheckingView.this.propertyTable.indexOf(selected);
                    ModelCheckingView.this.propertyTable.remove(index);
                    ModelCheckingView.this.updateModelCheckingButton();
                    ++i;
                }
            }
        };
        return deletePropertyAction;
    }

    private void modelCheck(final String propertyName) {
        block10: {
            if (this.pepaModel == null) {
                return;
            }
            double accuracy = 1.0E-4;
            try {
                accuracy = Double.parseDouble(this.boundAccuracyText.getText());
            }
            catch (NumberFormatException numberFormatException) {}
            final double boundAccuracy = accuracy;
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    String value;
                    PEPAModelChecker modelChecker = ModelCheckingView.this.pepaModel.getModelChecker(boundAccuracy);
                    CSLAbstractStateProperty property = ModelCheckingView.this.model.getCSLProperty(propertyName);
                    if (property.isProbabilityTest()) {
                        ProbabilityInterval interval = modelChecker.testProperty(property);
                        value = interval.toString(5);
                    } else {
                        AbstractBoolean isOK = modelChecker.checkProperty(property);
                        value = isOK.toString();
                    }
                    ModelCheckingView.this.model.setCSLPropertyValue(propertyName, value);
                }
            };
            ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(this.getSite().getShell());
            try {
                monitorDialog.run(true, true, runnable);
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error during model checking", (String)("Error when model checking property \"" + propertyName + "\": " + e.getCause().getMessage() + "."));
                this.model.setCSLPropertyValue(propertyName, "");
                this.handlePropertiesChanged();
                break block10;
            }
            catch (InterruptedException interruptedException) {
                try {
                    MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"Operation aborted", (String)"Operation interrupted.");
                    this.model.setCSLPropertyValue(propertyName, "");
                    break block10;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.handlePropertiesChanged();
                }
            }
            this.handlePropertiesChanged();
        }
        this.computeTableWidths();
    }

    private void colorTableItem(TableItem item) {
        String value = item.getText(3);
        if (value.equals(AbstractBoolean.FALSE.toString())) {
            item.setBackground(PropertyManager.COLOR_FALSE);
        } else if (value.equals(AbstractBoolean.TRUE.toString())) {
            item.setBackground(PropertyManager.COLOR_TRUE);
        } else {
            item.setBackground(PropertyManager.COLOR_UNSELECTED);
        }
    }

    private void updateModelCheckingButton() {
        TableItem[] properties = this.propertyTable.getItems();
        boolean enabled = false;
        int i = 0;
        while (i < properties.length) {
            enabled = enabled || properties[i].getChecked();
            ++i;
        }
        this.modelCheckButton.setEnabled(enabled);
    }

    @Override
    protected void internalCreatePartControl(Composite parent) {
        this.modelCheckingView = new Composite(parent, 0);
        this.modelCheckingView.setLayout((Layout)new FormLayout());
        this.modelCheckButton = new Button(this.modelCheckingView, 8);
        this.modelCheckButton.setText("Check Properties");
        this.modelCheckButton.setEnabled(false);
        this.modelCheckButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TableItem[] properties = ModelCheckingView.this.propertyTable.getItems();
                ArrayList<String> propertyNames = new ArrayList<String>();
                int i = 0;
                while (i < properties.length) {
                    if (properties[i].getChecked()) {
                        propertyNames.add(properties[i].getText(1));
                    }
                    ++i;
                }
                for (String propertyName : propertyNames) {
                    ModelCheckingView.this.modelCheck(propertyName);
                }
            }
        });
        FormData formData = new FormData();
        formData.right = new FormAttachment(100, -5);
        formData.bottom = new FormAttachment(100, -5);
        this.modelCheckButton.setLayoutData((Object)formData);
        this.boundAccuracyText = new Text(this.modelCheckingView, 2048);
        this.boundAccuracyText.setText("0.00001");
        formData = new FormData();
        formData.right = new FormAttachment((Control)this.modelCheckButton, -10);
        formData.bottom = new FormAttachment(100, -5);
        formData.width = 100;
        this.boundAccuracyText.setLayoutData((Object)formData);
        this.boundAccuracyLabel = new Label(this.modelCheckingView, 0);
        this.boundAccuracyLabel.setText("Transient Accuracy:");
        formData = new FormData();
        formData.right = new FormAttachment((Control)this.boundAccuracyText, -5);
        formData.bottom = new FormAttachment(100, -10);
        this.boundAccuracyLabel.setLayoutData((Object)formData);
        this.propertyTable = new Table(this.modelCheckingView, 67620);
        this.propertyTable.setHeaderVisible(true);
        this.propertyTable.setLinesVisible(true);
        this.propertyTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TableItem[] selected = ModelCheckingView.this.propertyTable.getSelection();
                if (selected.length == 1) {
                    ModelCheckingView.this.editProperty(selected[0]);
                }
            }
        });
        this.propertyTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ModelCheckingView.this.updateModelCheckingButton();
            }
        });
        formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment((Control)this.modelCheckButton, -5);
        this.propertyTable.setLayoutData((Object)formData);
        TableColumn checkColumn = new TableColumn(this.propertyTable, 32);
        checkColumn.setAlignment(0x1000000);
        checkColumn.setText("");
        checkColumn.setResizable(false);
        TableColumn nameColumn = new TableColumn(this.propertyTable, 0);
        nameColumn.setAlignment(16384);
        nameColumn.setText("Name");
        nameColumn.setResizable(false);
        TableColumn propertyColumn = new TableColumn(this.propertyTable, 0);
        propertyColumn.setAlignment(16384);
        propertyColumn.setText("CSL Property");
        propertyColumn.setResizable(false);
        TableColumn resultColumn = new TableColumn(this.propertyTable, 0);
        resultColumn.setAlignment(16384);
        resultColumn.setText("Result");
        resultColumn.setResizable(false);
        this.addPropertyContextMenu();
        this.createNewPropertyAction();
        this.modelCheckingView.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ModelCheckingView.this.computeTableWidths();
            }
        });
    }

    private int minimumWidth(int column) {
        GC gc = new GC((Drawable)this.propertyTable);
        int columnWidth = gc.textExtent((String)this.propertyTable.getColumn((int)column).getText()).x;
        int i = 0;
        while (i < this.propertyTable.getItemCount()) {
            int textWidth = gc.textExtent((String)this.propertyTable.getItem((int)i).getText((int)column)).x;
            columnWidth = Math.max(columnWidth, textWidth);
            ++i;
        }
        return columnWidth;
    }

    private void computeTableWidths() {
        Rectangle area = this.modelCheckingView.getClientArea();
        Point preferredSize = this.propertyTable.computeSize(-1, -1);
        Point buttonPreferredSize = this.modelCheckButton.computeSize(-1, -1);
        int width = area.width - 2 * this.propertyTable.getBorderWidth();
        if (preferredSize.y > area.height - buttonPreferredSize.y - 10 - this.propertyTable.getHeaderHeight()) {
            Point vBarSize = this.propertyTable.getVerticalBar().getSize();
            width -= vBarSize.x;
        }
        this.propertyTable.getColumn(0).setWidth(20);
        this.propertyTable.getColumn(1).setWidth(Math.max(150, this.minimumWidth(1) + 20));
        this.propertyTable.getColumn(3).setWidth(Math.max(120, this.minimumWidth(3)));
        this.propertyTable.getColumn(2).setWidth(Math.max(width - 20 - this.propertyTable.getColumn(1).getWidth() - this.propertyTable.getColumn(3).getWidth(), this.minimumWidth(2) + 20));
    }

    private void addPropertyContextMenu() {
        MenuManager menuMgr = new MenuManager("#CSLPopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ModelCheckingView.this.fillPropertyContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.propertyTable);
        this.propertyTable.setMenu(menu);
    }

    private void fillPropertyContextMenu(IMenuManager manager) {
        if (this.model == null) {
            return;
        }
        TableItem[] selection = this.propertyTable.getSelection();
        manager.add((IAction)this.newPropertyAction);
        if (selection.length > 0) {
            Action editAction = this.createEditPropertyAction(selection[0]);
            manager.add((IAction)editAction);
            Action deleteAction = this.createDeletePropertyAction(selection);
            manager.add((IAction)deleteAction);
        }
    }

    @Override
    protected void updateView(final IProcessAlgebraEditor editor) {
        this.propertyTable.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ModelCheckingView.this.model = null;
                ModelCheckingView.this.propertyTable.removeAll();
                ModelCheckingView.this.propertyTable.setEnabled(false);
                ModelCheckingView.this.boundAccuracyText.setEnabled(false);
                ModelCheckingView.this.boundAccuracyLabel.setEnabled(false);
                if (editor == null) {
                    ModelCheckingView.this.pepaModel = null;
                    return;
                }
                ModelCheckingView.this.pepaModel = ((PEPAEditor)editor).getProcessAlgebraModel();
                if (ModelCheckingView.this.pepaModel == null) {
                    return;
                }
                ModelCheckingView.this.model = ModelCheckingView.this.pepaModel.getDisplayModel();
                if (ModelCheckingView.this.model == null) {
                    return;
                }
                ModelCheckingView.this.propertyTable.setEnabled(true);
                ModelCheckingView.this.boundAccuracyText.setEnabled(true);
                ModelCheckingView.this.boundAccuracyLabel.setEnabled(true);
                ModelCheckingView.this.model.addPropertyChangedListener((IPropertyChangedListener)ModelCheckingView.this);
                ModelCheckingView.this.handlePropertiesChanged();
            }
        });
    }

    @Override
    protected void handleModelChanged(ProcessAlgebraModelChangedEvent event) {
        if (event.getType() == 0) {
            this.updateView(this.fEditor);
        }
    }

    public void handlePropertiesChanged() {
        this.propertyTable.removeAll();
        String[] propertyNames = this.model.getCSLPropertyNames();
        int i = 0;
        while (i < propertyNames.length) {
            String name = propertyNames[i];
            String property = this.model.getCSLProperty(name).toString();
            String value = this.model.getCSLPropertyValue(name);
            TableItem newTableProperty = new TableItem(this.propertyTable, 0);
            newTableProperty.setChecked(false);
            this.updateModelCheckingButton();
            newTableProperty.setText(new String[]{"", name, property, value});
            this.colorTableItem(newTableProperty);
            ++i;
        }
        this.computeTableWidths();
    }

    private void checkProperty(String name) {
        TableItem[] properties = this.propertyTable.getItems();
        int i = 0;
        while (i < properties.length) {
            if (properties[i].getText(1).equals(name)) {
                properties[i].setChecked(true);
                this.modelCheckButton.setEnabled(true);
            }
            ++i;
        }
    }

    @Override
    public void setFocus() {
        if (this.propertyTable != null && !this.propertyTable.isDisposed()) {
            this.propertyTable.setFocus();
        }
    }
}

