/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.view.statespaceexplorer;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraModel;

public class LazyContentProvider
implements ILazyContentProvider {
    private ArrayList<Integer> filteredStates;
    private TableViewer viewer;
    private IProcessAlgebraModel model;

    public LazyContentProvider(IProcessAlgebraModel model, TableViewer viewer) {
        this.viewer = viewer;
        this.model = model;
        this.filteredStates = null;
    }

    public IStateSpace getStateSpace() {
        return this.model.getStateSpace();
    }

    public boolean isFiltered(int state) {
        if (this.filteredStates == null) {
            return false;
        }
        return this.filteredStates.contains(state);
    }

    public void updateElement(int index) {
        if (this.filteredStates == null) {
            this.viewer.replace((Object)index, index);
        } else {
            this.viewer.replace((Object)this.filteredStates.get(index), index);
        }
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        IStateSpace currentStateSpace = this.model.getStateSpace();
        this.filteredStates = (ArrayList)newInput;
        if (currentStateSpace != null) {
            if (this.filteredStates == null) {
                this.viewer.setItemCount(currentStateSpace.size());
            } else {
                this.viewer.setItemCount(this.filteredStates.size());
            }
        } else {
            this.viewer.setItemCount(0);
        }
    }
}

