/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.view.statespaceexplorer;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.eclipse.ui.Activator;
import uk.ac.ed.inf.pepa.eclipse.ui.view.statespaceexplorer.LazyContentProvider;
import uk.ac.ed.inf.pepa.eclipse.ui.view.statespaceexplorer.ProcessAlgebraModelPage;
import uk.ac.ed.inf.pepa.eclipse.ui.view.statespaceexplorer.TransitionLabelProvider;

class NavigationDialog
extends Dialog {
    private static final String DIALOG_SETTINGS_NAME = "NAVIGATION_DIALOG";
    ProcessAlgebraModelPage page;
    int currentState;
    int[] outgoingStates;
    int[] incomingStates;
    TableViewer outgoingStatesTableViewer;
    TableViewer incomingStatesTableViewer;
    TableViewer currentStateTableViewer;
    IStructuredSelection selectedSelection;
    Button okButton;
    Button enableColouring;
    Label outgoingNumStates;
    Label incomingNumStates;
    Font boldFont;
    Color red;
    Color black;
    private final Listener RESIZE_LISTENER = new Listener(){
        private boolean isResizing = false;

        public void handleEvent(Event event) {
            if (!(event.widget instanceof TableColumn)) {
                return;
            }
            if (this.isResizing) {
                return;
            }
            if (!this.isResizing) {
                this.isResizing = true;
            }
            TableColumn column = (TableColumn)event.widget;
            this.tryTable(NavigationDialog.this.currentStateTableViewer.getTable(), column);
            this.tryTable(NavigationDialog.this.outgoingStatesTableViewer.getTable(), column);
            this.tryTable(NavigationDialog.this.incomingStatesTableViewer.getTable(), column);
            this.isResizing = false;
        }

        private void tryTable(Table table, TableColumn column) {
            if (table == null) {
                return;
            }
            Table parent = column.getParent();
            if (parent != table) {
                int index = 0;
                while (index < parent.getColumnCount()) {
                    if (parent.getColumn(index) == column) break;
                    ++index;
                }
                table.getColumn(index).setWidth(parent.getColumn(index).getWidth());
            }
        }
    };
    boolean navigateStatesAnyway = true;

    protected NavigationDialog(ProcessAlgebraModelPage page, int startingState) {
        super(page.getControl().getShell());
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.red = page.getControl().getDisplay().getSystemColor(3);
        this.black = page.getControl().getDisplay().getSystemColor(2);
        this.page = page;
        this.updateStateModel(startingState);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_NAME);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS_NAME);
        }
        return section;
    }

    public boolean close() {
        this.boldFont.dispose();
        return super.close();
    }

    private void updateStateModel(int startingState) {
        this.currentState = startingState;
        this.prepareStates();
    }

    private void prepareStates() {
        IStateSpace ss = this.page.model.getStateSpace();
        this.outgoingStates = ss.getOutgoingStateIndices(this.currentState);
        this.incomingStates = ss.getIncomingStateIndices(this.currentState);
    }

    private void updateDialogBox() {
        ArrayList<Integer> current = new ArrayList<Integer>();
        current.add(this.currentState);
        this.currentStateTableViewer.setInput(current);
        ArrayList<Integer> outgoing = new ArrayList<Integer>();
        int[] nArray = this.outgoingStates;
        int n = this.outgoingStates.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            outgoing.add(i);
            ++n2;
        }
        ArrayList<Integer> incoming = new ArrayList<Integer>();
        int[] nArray2 = this.incomingStates;
        int n3 = this.incomingStates.length;
        n = 0;
        while (n < n3) {
            int i = nArray2[n];
            incoming.add(i);
            ++n;
        }
        this.outgoingStatesTableViewer.setInput(outgoing);
        this.incomingStatesTableViewer.setInput(incoming);
        this.outgoingNumStates.setText(String.valueOf(this.outgoingStates.length) + " outgoing states");
        this.incomingNumStates.setText(String.valueOf(this.incomingStates.length) + " incoming states");
        this.colouring();
    }

    private void colouring() {
        TableItem currentItem = this.currentStateTableViewer.getTable().getItem(0);
        boolean enabled = this.enableColouring.getSelection();
        boolean solutionAvailable = this.page.model.getStateSpace().isSolutionAvailable();
        this.compareAgainst(enabled, currentItem, this.incomingStatesTableViewer.getTable(), solutionAvailable);
        this.compareAgainst(enabled, currentItem, this.outgoingStatesTableViewer.getTable(), solutionAvailable);
    }

    private void compareAgainst(boolean enabled, TableItem currentItem, Table compareAgainst, boolean solutionAvailable) {
        TableItem[] tableItemArray = compareAgainst.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            int i = 2;
            while (i < compareAgainst.getColumnCount() - (solutionAvailable ? 1 : 0)) {
                if (!item.getText(i).equals(currentItem.getText(i))) {
                    item.setForeground(i, enabled ? this.red : this.black);
                } else {
                    item.setForeground(i, this.black);
                }
                ++i;
            }
            ++n2;
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Single Step Navigator");
    }

    protected void okPressed() {
        this.page.tableViewer.setSelection((ISelection)this.selectedSelection);
        this.updateStateModel((Integer)this.selectedSelection.getFirstElement());
        this.updateDialogBox();
    }

    protected void cancelPressed() {
        this.selectedSelection = null;
        super.cancelPressed();
    }

    protected Point getInitialSize() {
        return super.getInitialSize();
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.okButton = this.getButton(0);
        this.okButton.setEnabled(false);
        this.okButton.setText("Go to");
        Button cancelButton = this.getButton(1);
        cancelButton.setText("Finish");
        ISelectionChangedListener selListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NavigationDialog.this.handleSelection((IStructuredSelection)event.getSelection());
            }
        };
        IDoubleClickListener dblListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                NavigationDialog.this.handleSelection((IStructuredSelection)event.getSelection());
                if (NavigationDialog.this.okButton.isEnabled()) {
                    NavigationDialog.this.okPressed();
                }
            }
        };
        this.outgoingStatesTableViewer.addSelectionChangedListener(selListener);
        this.incomingStatesTableViewer.addSelectionChangedListener(selListener);
        this.outgoingStatesTableViewer.addDoubleClickListener(dblListener);
        this.incomingStatesTableViewer.addDoubleClickListener(dblListener);
        return control;
    }

    private void handleSelection(IStructuredSelection sel) {
        this.okButton.setEnabled(false);
        if (sel == null) {
            return;
        }
        Integer state = (Integer)sel.getFirstElement();
        if (state == null) {
            return;
        }
        boolean navigable = false;
        if (!this.navigateStatesAnyway) {
            navigable = ((LazyContentProvider)this.page.tableViewer.getContentProvider()).isFiltered(state);
        }
        if (this.navigateStatesAnyway || navigable) {
            this.okButton.setEnabled(true);
            this.selectedSelection = sel;
        }
    }

    protected Control createDialogArea(Composite parent) {
        FontData[] datas;
        int verticalSpan = 5;
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layoutTP = new GridLayout();
        layoutTP.marginWidth = 5;
        layoutTP.numColumns = 1;
        composite.setLayout((Layout)layoutTP);
        final Button option = new Button(composite, 32);
        option.setText("Only states unaffected by filters can be reached");
        option.setLayoutData((Object)new GridData(768));
        option.setSelection(!this.navigateStatesAnyway);
        option.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                boolean bl = NavigationDialog.this.navigateStatesAnyway = !option.getSelection();
                if (!NavigationDialog.this.navigateStatesAnyway) {
                    NavigationDialog.this.handleSelection(NavigationDialog.this.selectedSelection);
                }
            }
        });
        this.enableColouring = new Button(composite, 32);
        this.enableColouring.setText("Enable colouring");
        this.enableColouring.setLayoutData((Object)new GridData(768));
        this.enableColouring.setSelection(true);
        this.enableColouring.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NavigationDialog.this.colouring();
            }
        });
        Label incomingTitle = new Label(composite, 0);
        incomingTitle.setText("Incoming States");
        GridData incomingData = new GridData();
        incomingData.verticalIndent = verticalSpan;
        incomingData.verticalAlignment = 1024;
        incomingData.grabExcessVerticalSpace = false;
        incomingTitle.setLayoutData((Object)incomingData);
        FontData[] fontDataArray = datas = incomingTitle.getFont().getFontData();
        int n = datas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData d = fontDataArray[n2];
            d.setStyle(1);
            ++n2;
        }
        this.boldFont = new Font((Device)incomingTitle.getDisplay(), datas);
        incomingTitle.setFont(this.boldFont);
        this.incomingStatesTableViewer = this.createTableViewer(true, false, composite);
        this.incomingNumStates = new Label(composite, 0);
        this.incomingNumStates.setLayoutData((Object)new GridData(768));
        Label currentStateTitle = new Label(composite, 0);
        GridData currentData = new GridData();
        currentData.verticalSpan = verticalSpan;
        currentData.verticalAlignment = 1024;
        currentData.grabExcessVerticalSpace = false;
        currentStateTitle.setLayoutData((Object)currentData);
        currentStateTitle.setText("Current State");
        currentStateTitle.setFont(this.boldFont);
        this.currentStateTableViewer = this.createTableViewer(false, false, composite);
        Label outgoingTitle = new Label(composite, 0);
        outgoingTitle.setText("Outgoing States");
        GridData outgoingData = new GridData();
        outgoingData.verticalSpan = verticalSpan;
        outgoingData.verticalSpan = verticalSpan;
        outgoingData.verticalAlignment = 1024;
        outgoingTitle.setLayoutData((Object)outgoingData);
        outgoingTitle.setFont(this.boldFont);
        this.outgoingStatesTableViewer = this.createTableViewer(true, true, composite);
        this.outgoingNumStates = new Label(composite, 0);
        this.outgoingNumStates.setLayoutData((Object)new GridData(768));
        this.currentStateTableViewer.getTable().getColumn(0).setWidth(this.outgoingStatesTableViewer.getTable().getColumn(0).getWidth());
        this.updateDialogBox();
        return composite;
    }

    private TableViewer createTableViewer(boolean transitionTable, boolean outgoing, Composite composite) {
        TableViewer tableViewer = new TableViewer(composite, 268503044);
        LazyContentProvider contentProvider = new LazyContentProvider(this.page.model, tableViewer);
        TransitionLabelProvider provider = new TransitionLabelProvider(contentProvider, this, transitionTable, outgoing);
        tableViewer.setLabelProvider((IBaseLabelProvider)provider);
        tableViewer.setContentProvider((IContentProvider)contentProvider);
        Table table = tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        Table originalTable = this.page.tableViewer.getTable();
        TableColumn actionColumn = new TableColumn(table, 131072);
        if (transitionTable) {
            actionColumn.setText("Action");
        } else {
            actionColumn.setText("");
        }
        int i = 0;
        while (i < originalTable.getColumnCount()) {
            TableColumn c = new TableColumn(table, 16384);
            if (i == 0) {
                c.setText("No.");
            } else {
                c.setText("Comp. " + i);
            }
            int originalWidth = originalTable.getColumns()[i].getWidth();
            c.setWidth(originalWidth);
            c.addListener(11, this.RESIZE_LISTENER);
            ++i;
        }
        actionColumn.pack();
        actionColumn.addListener(11, this.RESIZE_LISTENER);
        return tableViewer;
    }
}

