/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.view.statespaceexplorer;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraModel;

public class OptionWizardPage
extends WizardPage {
    private IProcessAlgebraModel model;
    private Text separatorText;
    private Button includeStateNumberButton;
    private Button includeCurrentSolutionButton;

    protected OptionWizardPage(IProcessAlgebraModel processAlgebraModel) {
        super("optionWizardPage");
        this.model = processAlgebraModel;
        this.setTitle("Exporter Options");
        this.setDescription("Export the state space data model using the following settings");
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.verticalSpacing = 10;
        main.setLayout((Layout)layout);
        this.setControl((Control)main);
        Group commonOptions = new Group(main, 0);
        commonOptions.setText("Common Options");
        commonOptions.setLayoutData((Object)new GridData(768));
        GridLayout col = new GridLayout(2, false);
        col.marginBottom = 10;
        col.marginTop = 10;
        commonOptions.setLayout((Layout)col);
        Label l = new Label((Composite)commonOptions, 0);
        l.setText("Separator");
        l.setLayoutData((Object)new GridData());
        this.separatorText = new Text((Composite)commonOptions, 2048);
        this.separatorText.setTextLimit(5);
        this.separatorText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                if (OptionWizardPage.this.separatorText.getText().equals("")) {
                    OptionWizardPage.this.setPageComplete(false);
                } else {
                    OptionWizardPage.this.setPageComplete(true);
                }
            }
        });
        this.separatorText.setText(",");
        this.separatorText.setLayoutData((Object)new GridData(768));
        Group stateSpaceOptions = new Group(main, 0);
        stateSpaceOptions.setText("State Space Options");
        GridLayout sol = new GridLayout(1, true);
        sol.marginHeight = 10;
        sol.marginTop = 10;
        sol.marginBottom = 10;
        stateSpaceOptions.setLayout((Layout)sol);
        stateSpaceOptions.setLayoutData((Object)new GridData(768));
        this.includeStateNumberButton = new Button((Composite)stateSpaceOptions, 32);
        this.includeStateNumberButton.setText("Include state number");
        this.includeStateNumberButton.setLayoutData((Object)new GridData(768));
        this.includeCurrentSolutionButton = new Button((Composite)stateSpaceOptions, 32);
        this.includeCurrentSolutionButton.setText("Include current steady-state solution");
        this.includeCurrentSolutionButton.setLayoutData((Object)new GridData(768));
        this.includeCurrentSolutionButton.setEnabled(this.model.isSolved());
    }

    public boolean isIncludeStateNumber() {
        return this.includeStateNumberButton.getSelection();
    }

    public boolean isIncludeCurrentSolution() {
        if (this.includeCurrentSolutionButton.getEnabled()) {
            return this.includeCurrentSolutionButton.getSelection();
        }
        return false;
    }

    public String getSeparator() {
        return this.separatorText.getText();
    }
}

