/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.view.statespaceexplorer;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.Page;
import uk.ac.ed.inf.pepa.ctmc.derivation.IFilterRunner;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraModel;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraModelChangedListener;
import uk.ac.ed.inf.pepa.eclipse.core.PepaLog;
import uk.ac.ed.inf.pepa.eclipse.core.ProcessAlgebraModelChangedEvent;
import uk.ac.ed.inf.pepa.eclipse.ui.Activator;
import uk.ac.ed.inf.pepa.eclipse.ui.IFilterManager;
import uk.ac.ed.inf.pepa.eclipse.ui.IFilterModel;
import uk.ac.ed.inf.pepa.eclipse.ui.ImageManager;
import uk.ac.ed.inf.pepa.eclipse.ui.dialogs.FilterDialogs;
import uk.ac.ed.inf.pepa.eclipse.ui.view.statespaceexplorer.LazyContentProvider;
import uk.ac.ed.inf.pepa.eclipse.ui.view.statespaceexplorer.NavigationDialog;
import uk.ac.ed.inf.pepa.eclipse.ui.view.statespaceexplorer.StateLabelProvider;
import uk.ac.ed.inf.pepa.eclipse.ui.view.statespaceexplorer.StateSpaceExportAction;
import uk.ac.ed.inf.pepa.eclipse.ui.view.statespaceexplorer.StateSpaceImportAction;

public abstract class ProcessAlgebraModelPage
extends Page
implements IProcessAlgebraModelChangedListener {
    protected TableViewer tableViewer;
    Action navigateAction;
    IProcessAlgebraModel model;
    private ArrayList<Integer> filteredInput = new ArrayList();
    private Action exportAction;
    private Action importAction;
    private Composite pgComp;
    protected Label messageLabel;
    private Action filterAction;
    private final IFilterManager filterManager;
    private IFilterModel currentConfiguration = null;
    private Action problemDescriptionAction;
    private LazyContentProvider contentProvider;

    public ProcessAlgebraModelPage(IProcessAlgebraModel model) {
        this.model = model;
        this.filterManager = Activator.getDefault().getFilterManagerProvider().getFilterManager(model);
        this.model.addModelChangedListener((IProcessAlgebraModelChangedListener)this);
    }

    public void dispose() {
        this.model.removeModelChangedListener((IProcessAlgebraModelChangedListener)this);
        super.dispose();
    }

    public void createControl(Composite parent) {
        this.pgComp = new Composite(parent, 0);
        this.pgComp.setLayoutData((Object)new GridData(1808));
        GridLayout layoutTP = new GridLayout();
        layoutTP.marginWidth = 0;
        layoutTP.numColumns = 1;
        this.pgComp.setLayout((Layout)layoutTP);
        this.messageLabel = new Label(this.pgComp, 0);
        this.messageLabel.setLayoutData((Object)new GridData(768));
        this.tableViewer = this.createTableViewer(this.pgComp);
        this.createActions();
        this.createContextMenu();
        this.contributeToActionBars();
    }

    protected TableViewer createTableViewer(Composite composite) {
        TableViewer tableViewer = new TableViewer(composite, 268503044);
        Table table = tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        this.contentProvider = new LazyContentProvider(this.model, tableViewer);
        tableViewer.setLabelProvider((IBaseLabelProvider)new StateLabelProvider(this.contentProvider));
        tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        return tableViewer;
    }

    private void createActions() {
        this.navigateAction = new Action(){

            public void run() {
                NavigationDialog dialog = new NavigationDialog(ProcessAlgebraModelPage.this, (Integer)((IStructuredSelection)ProcessAlgebraModelPage.this.tableViewer.getSelection()).getFirstElement());
                dialog.open();
            }
        };
        this.navigateAction.setToolTipText("Single Step Navigator");
        this.navigateAction.setText("Single Step Navigator...");
        this.problemDescriptionAction = new Action(){

            public void run() {
            }
        };
        this.problemDescriptionAction.setText("Properties");
        this.problemDescriptionAction.setToolTipText("Show properties of this state");
        this.exportAction = new StateSpaceExportAction(this);
        this.importAction = new StateSpaceImportAction(this);
    }

    private void contributeToActionBars() {
        this.contributeToLocalToolBar(this.getSite().getActionBars().getToolBarManager());
    }

    private void contributeToLocalToolBar(IToolBarManager mng) {
        mng.removeAll();
        mng.update(false);
        mng.add((IAction)this.exportAction);
        mng.add((IAction)this.importAction);
        mng.update(true);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ProcessAlgebraModelPage.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.tableViewer.getControl());
        this.tableViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu("pepaModelPage", menuMgr, (ISelectionProvider)this.tableViewer);
    }

    private void fillContextMenu(IMenuManager mgr) {
        IStructuredSelection sel = (IStructuredSelection)this.tableViewer.getSelection();
        if (!sel.isEmpty() && sel.getFirstElement() instanceof Integer) {
            mgr.add((IAction)this.navigateAction);
            mgr.add((IContributionItem)new Separator());
            mgr.add((IAction)this.problemDescriptionAction);
        }
        mgr.add((IContributionItem)new Separator("additions"));
    }

    public Control getControl() {
        return this.pgComp;
    }

    public static void revealStateSpace() {
        try {
            IWorkbenchWindow dw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            dw.getActivePage().showView("uk.ac.ed.inf.pepa.eclipse.ui.stateSpaceView");
        }
        catch (Exception e) {
            PepaLog.logError((Throwable)e);
        }
    }

    public void setFocus() {
        this.pgComp.setFocus();
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        super.makeContributions(menuManager, toolBarManager, statusLineManager);
        this.filterAction = new Action(){

            public void run() {
                ProcessAlgebraModelPage.this.currentConfiguration = FilterDialogs.openFilterManagerDialog(ProcessAlgebraModelPage.this.filterManager, ProcessAlgebraModelPage.this.pgComp.getShell(), ProcessAlgebraModelPage.this.currentConfiguration);
                ProcessAlgebraModelPage.this.updateView();
            }
        };
        this.filterAction.setText("Filters...");
        this.filterAction.setToolTipText("Filter this view according to state number, sequential component or steady-state probability, if available");
        this.filterAction.setImageDescriptor(ImageManager.getInstance().getImageDescriptor("filter_ps.gif"));
        menuManager.add((IAction)this.filterAction);
        this.updateView();
    }

    private void filterElementsInDataModel() {
        this.filteredInput.clear();
        if (this.currentConfiguration == null) {
            return;
        }
        IFilterRunner[] runners = new IFilterRunner[this.currentConfiguration.getFilters().length];
        int j = 0;
        while (j < runners.length) {
            runners[j] = this.currentConfiguration.getFilters()[j].getRunner(this.model.getStateSpace());
            ++j;
        }
        int s = 0;
        while (s < this.model.getStateSpace().size()) {
            boolean makesItThrough = true;
            IFilterRunner[] iFilterRunnerArray = runners;
            int n = runners.length;
            int n2 = 0;
            while (n2 < n) {
                IFilterRunner runner = iFilterRunnerArray[n2];
                if (!runner.select(s)) {
                    makesItThrough = false;
                    break;
                }
                ++n2;
            }
            if (makesItThrough) {
                this.filteredInput.add(s);
            }
            ++s;
        }
    }

    private void updateView() {
        this.getControl().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ProcessAlgebraModelPage.this.updateTable();
                ProcessAlgebraModelPage.this.updateActions();
                ProcessAlgebraModelPage.this.updateMessageLabel();
            }
        });
    }

    protected void updateMessageLabel() {
        if (this.model.getStateSpace() == null) {
            this.messageLabel.setText("");
        } else {
            int size = this.model.getStateSpace().size();
            if (this.currentConfiguration != null) {
                String text = String.valueOf(this.filteredInput.size()) + " states" + " (filtered from " + size + " states)";
                if (this.model.isSolved()) {
                    text = String.valueOf(text) + " Probability: " + this.getShownTotalProbability();
                }
                this.messageLabel.setText(text);
            } else {
                this.messageLabel.setText(String.valueOf(size) + " states");
            }
        }
    }

    protected double getShownTotalProbability() {
        double result = 0.0;
        for (int i : this.filteredInput) {
            result += this.model.getStateSpace().getSolution(i);
        }
        return result < 0.0 ? 0.0 : result;
    }

    private void updateActions() {
        this.filterAction.setEnabled(this.model.getStateSpace() != null);
        this.exportAction.setEnabled(this.model.getStateSpace() != null);
        this.importAction.setEnabled(this.model.getStateSpace() != null);
    }

    private void updateTable() {
        IStateSpace ss = this.model.getStateSpace();
        if (this.model.getStateSpace() != null) {
            this.filterElementsInDataModel();
        }
        this.tableViewer.setInput(this.currentConfiguration != null ? this.filteredInput : null);
        if (ss != null) {
            int alreadyShownColumns;
            int totalNumberOfColumns = !ss.isSolutionAvailable() ? ss.getMaximumNumberOfSequentialComponents() + 1 : 2 + ss.getMaximumNumberOfSequentialComponents();
            if (totalNumberOfColumns != (alreadyShownColumns = this.tableViewer.getTable().getColumnCount())) {
                if (totalNumberOfColumns < alreadyShownColumns) {
                    int i = alreadyShownColumns - 1;
                    while (i >= totalNumberOfColumns) {
                        this.tableViewer.getTable().getColumns()[i].dispose();
                        --i;
                    }
                } else {
                    int i = 0;
                    while (i < totalNumberOfColumns - alreadyShownColumns) {
                        new TableColumn(this.tableViewer.getTable(), 16384);
                        ++i;
                    }
                }
                this.resizeControl_(this.tableViewer.getTable());
            }
            this.tableViewer.refresh();
            if (!this.tableViewer.getTable().isVisible()) {
                this.tableViewer.getTable().setVisible(true);
            }
        } else {
            this.tableViewer.getTable().setVisible(false);
        }
    }

    protected abstract void resizeControl_(Table var1);

    public void processAlgebraModelChanged(ProcessAlgebraModelChangedEvent event) {
        this.updateView();
    }
}

