/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.view.statespaceexplorer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import uk.ac.ed.inf.common.ui.wizards.SaveAsPage;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.eclipse.ui.view.statespaceexplorer.OptionWizardPage;
import uk.ac.ed.inf.pepa.eclipse.ui.view.statespaceexplorer.ProcessAlgebraModelPage;

public class StateSpaceExporterWizard
extends Wizard {
    private static final String Q_EXTENSION = "generator";
    private static final String S_EXTENSION = "statespace";
    private OptionWizardPage optionWizardPage;
    private SaveAsPage stateSpacePage;
    private SaveAsPage generatorPage;
    ProcessAlgebraModelPage modelPage;

    public StateSpaceExporterWizard(ProcessAlgebraModelPage modelPage) {
        if (modelPage == null || modelPage.model == null) {
            throw new NullPointerException();
        }
        if (!modelPage.model.isDerivable()) {
            throw new IllegalStateException("PEPA Model is not derivable");
        }
        this.modelPage = modelPage;
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this.optionWizardPage = new OptionWizardPage(this.modelPage.model);
        this.addPage((IWizardPage)this.optionWizardPage);
        IFile stateSpaceFile = this.getFileFor(S_EXTENSION);
        this.stateSpacePage = new SaveAsPage("stateSpacePage", (IStructuredSelection)new StructuredSelection((Object)stateSpaceFile), S_EXTENSION);
        this.stateSpacePage.setTitle("Save State Space");
        this.stateSpacePage.setDescription("Save state space to the given location");
        this.stateSpacePage.setFileName(stateSpaceFile.getName());
        this.addPage((IWizardPage)this.stateSpacePage);
        IFile generatorFile = this.getFileFor(Q_EXTENSION);
        this.generatorPage = new SaveAsPage("generatorPage", (IStructuredSelection)new StructuredSelection((Object)generatorFile), Q_EXTENSION);
        this.generatorPage.setFileName(generatorFile.getName());
        this.generatorPage.setTitle("Save Infinitesimal Generator Matrix");
        this.generatorPage.setDescription("Save infinitesimal generator matrix to the given location");
        this.addPage((IWizardPage)this.generatorPage);
    }

    private IFile getFileFor(String extension) {
        IResource resource = this.modelPage.model.getUnderlyingResource();
        IPath fullPath = resource.getFullPath();
        fullPath = fullPath.removeFileExtension();
        fullPath = fullPath.addFileExtension(extension);
        return ResourcesPlugin.getWorkspace().getRoot().getFile(fullPath);
    }

    public boolean performFinish() {
        final IFile stateSpaceFile = this.getFileFor(this.stateSpacePage);
        final IFile generatorFile = this.getFileFor(this.generatorPage);
        try {
            this.getContainer().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                            File ssFile = stateSpaceFile.getLocation().toFile();
                            StateSpaceExporterWizard.this.createStateSpace(ssFile, subMonitor.newChild(45));
                            File genFile = generatorFile.getLocation().toFile();
                            StateSpaceExporterWizard.this.createMatrix(genFile, subMonitor.newChild(45));
                            stateSpaceFile.touch((IProgressMonitor)subMonitor.newChild(5));
                            generatorFile.touch((IProgressMonitor)subMonitor.newChild(5));
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.modelPage.getSite().getShell(), (String)"Error while saving resources to disk", (String)e.getMessage());
            return false;
        }
        try {
            IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)stateSpaceFile);
        }
        catch (PartInitException partInitException) {
            MessageDialog.openError((Shell)this.modelPage.getSite().getShell(), (String)"Error opening saved resource", (String)("An error occurred while opening this file: " + stateSpaceFile.getName()));
            return false;
        }
        return true;
    }

    private IFile getFileFor(SaveAsPage page) {
        return page.createNewFile();
    }

    private void createStateSpace(File file, SubMonitor monitor) throws InterruptedException, IOException {
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));
        IStateSpace ss = this.modelPage.model.getStateSpace();
        int size = ss.size();
        monitor.beginTask("Creating state space", size);
        String separator = this.optionWizardPage.getSeparator();
        String ls = System.getProperty("line.separator");
        String openBracket = "{";
        String closeBracket = "}";
        int i = 0;
        while (i < size) {
            if (monitor.isCanceled()) {
                monitor.done();
                throw new InterruptedException("State space exporting interrupted by user");
            }
            if (this.optionWizardPage.isIncludeStateNumber()) {
                ((OutputStream)output).write((i + 1 + separator).getBytes());
            }
            int state = i;
            ((OutputStream)output).write(openBracket.getBytes());
            int j = 0;
            while (j < ss.getNumberOfSequentialComponents(i)) {
                ((OutputStream)output).write((String.valueOf(ss.getLabel(state, j)) + (j != ss.getNumberOfSequentialComponents(i) - 1 ? separator : "")).getBytes());
                ++j;
            }
            ((OutputStream)output).write(closeBracket.getBytes());
            if (this.optionWizardPage.isIncludeCurrentSolution()) {
                ((OutputStream)output).write((String.valueOf(separator) + ss.getSolution(state)).getBytes());
            }
            ((OutputStream)output).write(ls.getBytes());
            monitor.worked(1);
            ++i;
        }
        ((OutputStream)output).close();
        monitor.done();
    }

    private void createMatrix(File genFile, SubMonitor monitor) throws InterruptedException, IOException, DerivationException {
        IStateSpace ss = this.modelPage.model.getStateSpace();
        int size = ss.size();
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(genFile));
        try {
            String separator = this.optionWizardPage.getSeparator();
            String ls = System.getProperty("line.separator");
            monitor.beginTask("Creating generator matrix", size);
            int s = 0;
            while (s < ss.size()) {
                int[] outgoing;
                int[] nArray = outgoing = ss.getOutgoingStateIndices(s);
                int n = outgoing.length;
                int n2 = 0;
                while (n2 < n) {
                    int index = nArray[n2];
                    ((OutputStream)output).write(Integer.toString(s + 1).getBytes());
                    ((OutputStream)output).write(separator.getBytes());
                    ((OutputStream)output).write(Integer.toString(index + 1).getBytes());
                    ((OutputStream)output).write(separator.getBytes());
                    ((OutputStream)output).write(Double.toString(ss.getRate(s, index)).getBytes());
                    ((OutputStream)output).write(ls.getBytes());
                    ++n2;
                }
                monitor.worked(1);
                ++s;
            }
        }
        finally {
            if (output != null) {
                try {
                    ((OutputStream)output).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

