/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.view.statespaceexplorer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.eclipse.ui.ImageManager;
import uk.ac.ed.inf.pepa.eclipse.ui.view.statespaceexplorer.ProcessAlgebraModelPage;

public class StateSpaceImportAction
extends Action {
    private ProcessAlgebraModelPage page;

    public StateSpaceImportAction(ProcessAlgebraModelPage pepaModelPage) {
        super("Import", 1);
        this.setImageDescriptor(ImageManager.getInstance().getImageDescriptor("import.gif"));
        this.setToolTipText("Import steady-state distribution from ASCII file");
        this.page = pepaModelPage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        Shell shell = this.page.getSite().getShell();
        String errorMessage = "An error occurred while reading the file";
        String errorTitle = "Error";
        FileDialog dialog = new FileDialog(shell);
        String fileName = dialog.open();
        if (fileName == null) return;
        File file = new File(fileName);
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            this.setSolution(reader);
            MessageDialog.openConfirm((Shell)shell, (String)"Success", (String)"Solution imported.");
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)shell, (String)errorTitle, (String)(String.valueOf(errorMessage) + " : " + e.getMessage()));
            if (reader == null) return;
            try {
                reader.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (Throwable t) {
            try {
                t.printStackTrace();
                MessageDialog.openError((Shell)shell, (String)"Unexpected Error", (String)(String.valueOf(t.getClass().getName()) + ": " + t.getMessage()));
                if (reader == null) return;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                reader.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        if (reader == null) return;
        try {
            reader.close();
            return;
        }
        catch (IOException iOException) {}
    }

    private void setSolution(FileReader fileReader) throws IOException {
        BufferedReader r = new BufferedReader(fileReader);
        double[] solution = new double[this.page.model.getStateSpace().size()];
        String line = null;
        int stateSpaceSize = this.page.model.getStateSpace().size();
        int i = 0;
        while ((line = r.readLine()) != null) {
            if (i == stateSpaceSize) {
                throw new IOException("Too many values");
            }
            try {
                solution[i++] = Double.parseDouble(line);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Format unsupported");
            }
        }
        try {
            this.page.model.setSolution(solution);
        }
        catch (DerivationException e) {
            MessageDialog.openError((Shell)this.page.getSite().getShell(), (String)"Error", (String)("An error occurred while setting the new solution." + e.getMessage()));
        }
    }
}

