/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.view.utilisationview;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.Page;
import uk.ac.ed.inf.common.ui.plotting.IChart;
import uk.ac.ed.inf.common.ui.plotting.Plotting;
import uk.ac.ed.inf.common.ui.plotting.data.InfoWithAxes;
import uk.ac.ed.inf.common.ui.plotting.data.InfoWithoutAxes;
import uk.ac.ed.inf.common.ui.plotview.views.PlotView;
import uk.ac.ed.inf.pepa.ctmc.LocalState;
import uk.ac.ed.inf.pepa.ctmc.PopulationLevelResult;
import uk.ac.ed.inf.pepa.ctmc.SequentialComponent;
import uk.ac.ed.inf.pepa.ctmc.ThroughputResult;
import uk.ac.ed.inf.pepa.ctmc.UtilisationResult;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraModel;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraModelChangedListener;
import uk.ac.ed.inf.pepa.eclipse.core.ProcessAlgebraModelChangedEvent;
import uk.ac.ed.inf.pepa.eclipse.ui.ImageManager;
import uk.ac.ed.inf.pepa.eclipse.ui.internal.Utilities;
import uk.ac.ed.inf.pepa.eclipse.ui.view.utilisationview.GraphCreator;
import uk.ac.ed.inf.pepa.eclipse.ui.view.utilisationview.PopulationTableProvider;
import uk.ac.ed.inf.pepa.eclipse.ui.view.utilisationview.ThroughputLabelProvider;
import uk.ac.ed.inf.pepa.eclipse.ui.view.utilisationview.UtilisationTreeContentProvider;
import uk.ac.ed.inf.pepa.eclipse.ui.view.utilisationview.UtilisationTreeLabelProvider;
import uk.ac.ed.inf.pepa.eclipse.ui.view.utilisationview.ViewerMenuListener;

class UtilisationPage
extends Page {
    private final Comparator<PopulationLevelResult> populationComparator = new Comparator<PopulationLevelResult>(){

        @Override
        public int compare(PopulationLevelResult arg0, PopulationLevelResult arg1) {
            return arg0.getName().compareTo(arg1.getName());
        }
    };
    private final Comparator<ThroughputResult> throughputComparator = new Comparator<ThroughputResult>(){

        @Override
        public int compare(ThroughputResult arg0, ThroughputResult arg1) {
            return arg0.getActionType().compareTo(arg1.getActionType());
        }
    };
    private Composite parent;
    private TabFolder tabFolder;
    private TabItem fUtilisationTab;
    private TabItem fThroughputTab;
    private TabItem fPopulationTab;
    private TreeViewer fUtilisationTreeViewer;
    private TableViewer fThroughputTableViewer;
    private TableViewer fPopulationTableViewer;
    private boolean alwaysLinkToModel = true;
    private Action linkToModelAction;
    private Action expandAllAction;
    private Action collapseAllAction;
    private IProcessAlgebraModel model;
    private IProcessAlgebraModelChangedListener listener = new IProcessAlgebraModelChangedListener(){

        public void processAlgebraModelChanged(ProcessAlgebraModelChangedEvent event) {
            if (event.getType() == 2 && UtilisationPage.this.alwaysLinkToModel) {
                UtilisationPage.this.updateView();
            }
        }
    };

    public UtilisationPage(IProcessAlgebraModel model) {
        if (model == null) {
            throw new NullPointerException("Model cannot be null");
        }
        this.model = model;
        this.model.addModelChangedListener(this.listener);
    }

    public void dispose() {
        this.model.removeModelChangedListener(this.listener);
        super.dispose();
    }

    public void createControl(Composite parent) {
        this.parent = new Composite(parent, 0);
        this.parent.setLayout((Layout)new FillLayout());
        this.tabFolder = new TabFolder(this.parent, 0);
        this.fUtilisationTab = new TabItem(this.tabFolder, 0);
        this.fUtilisationTab.setText("Utilisation");
        this.fUtilisationTab.setToolTipText("Utilisation");
        Composite utilisationParent = new Composite((Composite)this.tabFolder, 0);
        utilisationParent.setLayout((Layout)new FillLayout());
        this.fUtilisationTab.setControl((Control)utilisationParent);
        this.fUtilisationTreeViewer = new TreeViewer(utilisationParent, 2);
        this.fUtilisationTreeViewer.setLabelProvider((IBaseLabelProvider)new UtilisationTreeLabelProvider());
        this.fUtilisationTreeViewer.setContentProvider((IContentProvider)new UtilisationTreeContentProvider());
        this.fThroughputTab = new TabItem(this.tabFolder, 0);
        this.fThroughputTab.setText("Throughput");
        this.fThroughputTab.setToolTipText("Throughput");
        Composite throughputComposite = new Composite((Composite)this.tabFolder, 0);
        throughputComposite.setLayout((Layout)new FillLayout());
        this.fThroughputTab.setControl((Control)throughputComposite);
        Table table = new Table(throughputComposite, 65540);
        TableColumn actionColumn = new TableColumn(table, 16384);
        actionColumn.setText("Action");
        TableColumn valueColumn = new TableColumn(table, 16384);
        valueColumn.setText("Throughput");
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.fThroughputTableViewer = new TableViewer(table);
        this.fThroughputTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fThroughputTableViewer.setLabelProvider((IBaseLabelProvider)new ThroughputLabelProvider());
        this.fPopulationTab = new TabItem(this.tabFolder, 0);
        this.fPopulationTab.setText("Population");
        this.fPopulationTab.setToolTipText("Population");
        Composite populationComposite = new Composite((Composite)this.tabFolder, 0);
        populationComposite.setLayout((Layout)new FillLayout());
        this.fPopulationTab.setControl((Control)populationComposite);
        Table populationTable = new Table(populationComposite, 65540);
        TableColumn componentColumn = new TableColumn(populationTable, 16384);
        componentColumn.setText("Component Name");
        TableColumn meanColumn = new TableColumn(populationTable, 16384);
        meanColumn.setText("Population");
        populationTable.setHeaderVisible(true);
        populationTable.setLinesVisible(true);
        this.fPopulationTableViewer = new TableViewer(populationTable);
        this.fPopulationTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fPopulationTableViewer.setLabelProvider((IBaseLabelProvider)new PopulationTableProvider());
        this.createActions();
        this.contributeToActionBars();
        this.createContextMenu();
        this.tabFolder.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                UtilisationPage.this.contributeToActionBars();
            }
        });
        this.updateView();
    }

    public Control getControl() {
        return this.parent;
    }

    public void setFocus() {
        this.parent.setFocus();
    }

    private void updateView() {
        this.getControl().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!UtilisationPage.this.model.isSolved()) {
                    UtilisationPage.this.fUtilisationTreeViewer.setInput(null);
                    UtilisationPage.this.fThroughputTableViewer.setInput(null);
                    UtilisationPage.this.fPopulationTableViewer.setInput(null);
                    UtilisationPage.this.expandAllAction.setEnabled(false);
                    UtilisationPage.this.collapseAllAction.setEnabled(false);
                } else {
                    UtilisationPage.this.fUtilisationTreeViewer.setInput((Object)UtilisationPage.this.model.getStateSpace().getUtilisation());
                    ThroughputResult[] throughputResult = UtilisationPage.this.model.getStateSpace().getThroughput();
                    Arrays.sort(throughputResult, UtilisationPage.this.throughputComparator);
                    UtilisationPage.this.fThroughputTableViewer.setInput((Object)throughputResult);
                    PopulationLevelResult[] populationResult = UtilisationPage.this.model.getStateSpace().getPopulationLevels();
                    Arrays.sort(populationResult, UtilisationPage.this.populationComparator);
                    UtilisationPage.this.fPopulationTableViewer.setInput((Object)populationResult);
                    UtilisationPage.this.packTables();
                    UtilisationPage.this.expandAllAction.setEnabled(true);
                    UtilisationPage.this.collapseAllAction.setEnabled(true);
                }
            }
        });
    }

    private void packTables() {
        TableColumn c;
        TableColumn[] tableColumnArray = this.fThroughputTableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            c = tableColumnArray[n2];
            c.pack();
            ++n2;
        }
        tableColumnArray = this.fPopulationTableViewer.getTable().getColumns();
        n = tableColumnArray.length;
        n2 = 0;
        while (n2 < n) {
            c = tableColumnArray[n2];
            c.pack();
            ++n2;
        }
    }

    private void createActions() {
        this.linkToModelAction = new Action(){

            public void run() {
                UtilisationPage.this.performLinkToModel();
            }
        };
        this.linkToModelAction.setChecked(this.alwaysLinkToModel);
        this.linkToModelAction.setText("Sync with model");
        this.linkToModelAction.setToolTipText("Keep in sync with the active PEPA model");
        this.linkToModelAction.setImageDescriptor(ImageManager.getInstance().getImageDescriptor("synced.gif"));
        this.expandAllAction = new Action(){

            public void run() {
                UtilisationPage.this.fUtilisationTreeViewer.expandAll();
            }
        };
        this.expandAllAction.setText("Expand all");
        this.expandAllAction.setToolTipText("Expand all");
        this.expandAllAction.setImageDescriptor(ImageManager.getInstance().getImageDescriptor("expandall.gif"));
        this.collapseAllAction = new Action(){

            public void run() {
                UtilisationPage.this.fUtilisationTreeViewer.collapseAll();
            }
        };
        this.collapseAllAction.setText("Collapse all");
        this.collapseAllAction.setToolTipText("Collapse all");
        this.collapseAllAction.setImageDescriptor(ImageManager.getInstance().getImageDescriptor("collapseall.gif"));
    }

    private void performLinkToModel() {
        this.alwaysLinkToModel = this.linkToModelAction.isChecked();
        if (this.alwaysLinkToModel) {
            this.updateView();
        }
    }

    private void performCreateGraphUtilisation(ISelection selection) {
        IStructuredSelection sel = (IStructuredSelection)selection;
        UtilisationResult data = (UtilisationResult)sel.getFirstElement();
        if (data instanceof LocalState) {
            data = ((LocalState)data).getSequentialComponent();
        }
        InfoWithoutAxes info = Utilities.createGraphData((SequentialComponent)data);
        IChart chart = Plotting.getPlottingTools().createPieChart(info);
        this.showGraphInUI(chart);
    }

    private void performCreateGraphThroughput() {
        ThroughputResult[] inputData = (ThroughputResult[])this.fThroughputTableViewer.getInput();
        InfoWithAxes info = Utilities.createGraphData(inputData);
        info.setShowLegend(true);
        IChart chart = Plotting.getPlottingTools().createBarChart(info);
        this.showGraphInUI(chart);
    }

    private void performCreateGraphPopulation() {
        PopulationLevelResult[] results = (PopulationLevelResult[])this.fPopulationTableViewer.getInput();
        InfoWithAxes info = Utilities.createGraphData(results);
        info.setShowLegend(true);
        IChart chart = Plotting.getPlottingTools().createBarChart(info);
        this.showGraphInUI(chart);
    }

    private void showGraphInUI(final IChart chart) {
        this.getSite().getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    PlotView plotView = (PlotView)UtilisationPage.this.getSite().getPage().showView("uk.ac.ed.inf.common.ui.plotview.views.PlotView");
                    plotView.reveal(chart);
                }
                catch (PartInitException e) {
                    ErrorDialog.openError((Shell)UtilisationPage.this.getSite().getShell(), (String)"Error", (String)"Error displaying graph", (IStatus)e.getStatus());
                }
            }
        });
    }

    private void createContextMenu() {
        this.registerMenu("population", (Viewer)this.fPopulationTableViewer, new GraphCreator(){

            @Override
            public void createGraph(ISelection selection) {
                UtilisationPage.this.performCreateGraphPopulation();
            }
        });
        this.registerMenu("throughput", (Viewer)this.fThroughputTableViewer, new GraphCreator(){

            @Override
            public void createGraph(ISelection selection) {
                UtilisationPage.this.performCreateGraphThroughput();
            }
        });
        this.registerMenu("utilisation", (Viewer)this.fUtilisationTreeViewer, new GraphCreator(){

            @Override
            public void createGraph(ISelection selection) {
                UtilisationPage.this.performCreateGraphUtilisation(selection);
            }
        });
    }

    private void registerMenu(String name, Viewer viewer, GraphCreator creator) {
        MenuManager menuManager = new MenuManager(null);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)new ViewerMenuListener(viewer, creator));
        Menu menu = menuManager.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
    }

    private void contributeToActionBars() {
        IActionBars actionBars = this.getSite().getActionBars();
        this.contributeToLocalToolBar(actionBars.getToolBarManager());
    }

    private void contributeToLocalToolBar(IToolBarManager mng) {
        mng.removeAll();
        mng.update(false);
        int index = this.tabFolder.getSelectionIndex();
        if (index != -1 && this.tabFolder.getItem(index) == this.fUtilisationTab) {
            mng.add((IAction)this.expandAllAction);
            mng.add((IAction)this.collapseAllAction);
        }
        mng.add((IContributionItem)new Separator());
        mng.add((IAction)this.linkToModelAction);
        mng.update(true);
    }
}

