/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import uk.ac.ed.inf.common.ui.wizards.SaveAsPage;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.core.PepaLog;
import uk.ac.ed.inf.pepa.eclipse.core.ResourceUtilities;
import uk.ac.ed.inf.pepa.eclipse.ui.Activator;
import uk.ac.ed.inf.pepa.tools.Latexifier;

public class LatexifierWizard
extends Wizard {
    private static final String EXTENSION = "tex";
    private IPepaModel model;
    private WizardNewFileCreationPage newFilePage;
    private WizardPage previewPage;
    private SettingPage settingPage;

    public LatexifierWizard(IPepaModel model) {
        if (model == null) {
            throw new NullPointerException();
        }
        if (!model.isDerivable()) {
            throw new IllegalArgumentException("The model is not derivable");
        }
        this.model = model;
        this.setForcePreviousAndNextButtons(true);
        this.setNeedsProgressMonitor(true);
    }

    public void createPageControls(Composite parent) {
        super.createPageControls(parent);
    }

    public void addPages() {
        this.addSaveAsPage();
        this.settingPage = new SettingPage("PEPA2Latex Settings");
        this.addPage((IWizardPage)this.settingPage);
        this.previewPage = new PreviewPage("PreviewPage");
        this.addPage((IWizardPage)this.previewPage);
    }

    private void addSaveAsPage() {
        IFile handle = ResourcesPlugin.getWorkspace().getRoot().getFile(ResourceUtilities.changeExtension((IResource)this.model.getUnderlyingResource(), (String)EXTENSION));
        this.newFilePage = new SaveAsPage("newFilePage", (IStructuredSelection)new StructuredSelection((Object)handle), EXTENSION);
        this.newFilePage.setTitle("Latexify");
        this.newFilePage.setDescription("Save LaTeX snippet to");
        this.newFilePage.setFileName(handle.getName());
        this.addPage((IWizardPage)this.newFilePage);
    }

    public boolean performFinish() {
        String source = this.settingPage.getLatexifier().getLatexSource();
        byte[] currentBytes = source.getBytes();
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(currentBytes);
        try {
            this.getContainer().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IFile file = LatexifierWizard.this.newFilePage.createNewFile();
                        file.setContents((InputStream)byteArrayInputStream, true, false, monitor);
                        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            PepaLog.logError((Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error while creating resource", (String)e.getCause().getMessage());
            return false;
        }
        catch (InterruptedException e) {
            PepaLog.logError((Throwable)e);
            return false;
        }
        return true;
    }

    private class PreviewPage
    extends WizardPage {
        private Text snippetText;

        protected PreviewPage(String pageName) {
            super(pageName);
            this.setTitle("Preview");
            this.setDescription("You can copy and paste this snippet into your LaTeX source file");
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new FillLayout());
            this.setControl((Control)composite);
            this.snippetText = new Text(composite, 770);
            this.snippetText.setText(LatexifierWizard.this.settingPage.getLatexifier().getLatexSource());
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                this.snippetText.setText(LatexifierWizard.this.settingPage.getLatexifier().getLatexSource());
            }
        }
    }

    private class SettingPage
    extends WizardPage {
        private static final String SECTION_NAME = "latexifier.settingPage";
        private Button setsOnSeparateLinesButton;
        private static final String SEPARATE_LINES_BUTTON = "latexifier.settingPage.separateLines";
        private Text separateLinesName;
        private static final String SEPARATE_LINES_NAME = "latexifier.settingPage.separateLinesLabel";
        private Button showPreviewButton;
        private static final String SHOW_PREVIEW_BUTTON = "latexifier.settingPage.showPreviewButton";
        private Button allowExtraSpaceButton;
        private static final String ALLOW_EXTRA_SPACE_BUTTON = "latexifier.settingPage.allowExtraSpaceButton";
        private Text allowExtraSpaceText;
        private static final String ALLOW_EXTRA_SPACE_TEXT = "latexifier.settingPage.allowExtraSpaceText";
        private Latexifier latexifier;
        private IDialogSettings settings;

        protected SettingPage(String pageName) {
            super(pageName);
            this.setTitle("Latexify");
            this.setDescription("Select options for the converter");
            this.latexifier = new Latexifier(LatexifierWizard.this.model.getAST());
        }

        public void createControl(Composite parent) {
            int textStyle = 18436;
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            this.setControl((Control)composite);
            this.setsOnSeparateLinesButton = new Button(composite, 32);
            this.setsOnSeparateLinesButton.setText("Synchronisation and hiding set definitions on separate lines");
            this.setsOnSeparateLinesButton.setLayoutData((Object)this.createDefaultGridData());
            this.setsOnSeparateLinesButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SettingPage.this.validate();
                }
            });
            this.separateLinesName = new Text(composite, textStyle);
            this.separateLinesName.setLayoutData((Object)this.createDefaultGridData());
            this.separateLinesName.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    SettingPage.this.validate();
                }
            });
            this.allowExtraSpaceButton = new Button(composite, 32);
            this.allowExtraSpaceButton.setText("Allow extra space between sections");
            this.allowExtraSpaceButton.setToolTipText("Extra space (LaTeX command [ex]) allowed between rate definitions, process definitions and system equation");
            this.allowExtraSpaceButton.setLayoutData((Object)this.createDefaultGridData());
            this.allowExtraSpaceButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SettingPage.this.validate();
                }
            });
            this.allowExtraSpaceText = new Text(composite, textStyle);
            this.allowExtraSpaceText.setLayoutData((Object)this.createDefaultGridData());
            this.allowExtraSpaceText.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    SettingPage.this.validate();
                }
            });
            this.showPreviewButton = new Button(composite, 32);
            this.showPreviewButton.setText("Show preview");
            GridData previewData = this.createDefaultGridData();
            previewData.horizontalSpan = 2;
            this.showPreviewButton.setLayoutData((Object)previewData);
            this.showPreviewButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SettingPage.this.validate();
                }
            });
            this.initContents();
            this.validate();
        }

        private void initContents() {
            IDialogSettings uiSettings = Activator.getDefault().getDialogSettings();
            this.settings = uiSettings.getSection(SECTION_NAME);
            if (this.settings == null) {
                this.settings = uiSettings.addNewSection(SECTION_NAME);
            }
            this.setsOnSeparateLinesButton.setSelection(this.settings.getBoolean(SEPARATE_LINES_BUTTON));
            String value = this.settings.get(SEPARATE_LINES_NAME);
            this.separateLinesName.setText(value != null ? value : this.latexifier.getLabel());
            this.allowExtraSpaceButton.setSelection(this.settings.getBoolean(ALLOW_EXTRA_SPACE_BUTTON));
            value = this.settings.get(ALLOW_EXTRA_SPACE_TEXT);
            this.allowExtraSpaceText.setText(value != null ? value : String.valueOf(this.latexifier.getExtraSpace()));
            this.showPreviewButton.setSelection(this.settings.getBoolean(SHOW_PREVIEW_BUTTON));
        }

        public void validate() {
            block11: {
                this.setErrorMessage(null);
                this.setPageComplete(false);
                this.separateLinesName.setEnabled(this.setsOnSeparateLinesButton.getSelection());
                this.allowExtraSpaceText.setEnabled(this.allowExtraSpaceButton.getSelection());
                if (this.allowExtraSpaceButton.getSelection()) {
                    boolean extraSpaceOk = true;
                    try {
                        try {
                            double extraSpace = Double.valueOf(this.allowExtraSpaceText.getText());
                            if (extraSpace < 0.0) {
                                extraSpaceOk = false;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            extraSpaceOk = false;
                            if (!extraSpaceOk) {
                                this.setErrorMessage("Value not allowed");
                                return;
                            }
                            break block11;
                        }
                    }
                    catch (Throwable throwable) {
                        if (!extraSpaceOk) {
                            this.setErrorMessage("Value not allowed");
                            return;
                        }
                        throw throwable;
                    }
                    if (!extraSpaceOk) {
                        this.setErrorMessage("Value not allowed");
                        return;
                    }
                }
            }
            if (this.setsOnSeparateLinesButton.getSelection() && this.separateLinesName.getText().equals("")) {
                this.setErrorMessage("Insert a valid label");
                return;
            }
            this.setPageComplete(true);
        }

        public Latexifier getLatexifier() {
            if (!this.isPageComplete()) {
                throw new IllegalStateException("Cannot get the latexifier when the page is not complete");
            }
            this.setLatexifierOptions();
            return this.latexifier;
        }

        public boolean canFlipToNextPage() {
            if (super.canFlipToNextPage()) {
                if (this.isControlCreated()) {
                    return this.showPreviewButton.getSelection();
                }
                return true;
            }
            return false;
        }

        private void setLatexifierOptions() {
            double extraSpace;
            boolean setSetsOnSeparateLines = this.setsOnSeparateLinesButton.getSelection();
            this.latexifier.setSetsOnSeparateLines(setSetsOnSeparateLines);
            this.settings.put(SEPARATE_LINES_BUTTON, setSetsOnSeparateLines);
            if (setSetsOnSeparateLines) {
                String label = this.separateLinesName.getText().trim();
                this.latexifier.setLabel(label);
                this.settings.put(SEPARATE_LINES_NAME, label);
            }
            if (this.allowExtraSpaceButton.getSelection()) {
                extraSpace = Double.parseDouble(this.allowExtraSpaceText.getText());
                this.settings.put(ALLOW_EXTRA_SPACE_TEXT, String.valueOf(extraSpace));
            } else {
                extraSpace = 0.0;
            }
            this.latexifier.setExtraSpace(extraSpace);
            this.settings.put(ALLOW_EXTRA_SPACE_BUTTON, this.allowExtraSpaceButton.getSelection());
            this.settings.put(SHOW_PREVIEW_BUTTON, this.showPreviewButton.getSelection());
        }

        private GridData createDefaultGridData() {
            return new GridData(4, 0x1000000, true, false);
        }
    }
}

