/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.wizards;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import uk.ac.ed.inf.common.ui.plotting.IChart;
import uk.ac.ed.inf.common.ui.plotting.Plotting;
import uk.ac.ed.inf.common.ui.plotting.data.InfoWithAxes;
import uk.ac.ed.inf.common.ui.plotting.data.Series;
import uk.ac.ed.inf.common.ui.plotview.PlotViewPlugin;
import uk.ac.ed.inf.pepa.analysis.IAlphabetProvider;
import uk.ac.ed.inf.pepa.analysis.StaticAnalyser;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.solution.PepaJHydra;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.ui.Activator;
import uk.ac.ed.inf.pepa.jhydra.driver.passagetimesolver.PassageTimeResults;
import uk.ac.ed.inf.pepa.parsing.ASTFactory;
import uk.ac.ed.inf.pepa.parsing.ASTNode;
import uk.ac.ed.inf.pepa.parsing.ASTSupport;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.parsing.RateDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.RateDefinitions;
import uk.ac.ed.inf.pepa.parsing.RateDoubleNode;
import uk.ac.ed.inf.pepa.parsing.RateNode;

public class PassageTimeWizard
extends Wizard {
    private IPepaModel model;
    private SettingPage settingPage;
    private PassageExperimentPage experimentPage;

    private String[] getModelRateNames() {
        ModelNode modelNode = this.model.getAST();
        RateDefinitions rateDefs = modelNode.rateDefinitions();
        LinkedList<String> result = new LinkedList<String>();
        for (RateDefinitionNode rateDef : rateDefs) {
            result.add(rateDef.getName().getName());
        }
        return result.toArray(new String[result.size()]);
    }

    public PassageTimeWizard(IPepaModel model) {
        if (model == null) {
            throw new NullPointerException();
        }
        if (!model.isDerivable()) {
            throw new IllegalArgumentException("The model is not derivable");
        }
        this.model = model;
        this.setForcePreviousAndNextButtons(true);
        this.setNeedsProgressMonitor(true);
        String[] allRates = this.getModelRateNames();
        this.settingPage = new SettingPage("Passage-Time Analysis");
        this.experimentPage = new PassageExperimentPage("Experimentation", allRates);
    }

    public void createPageControls(Composite parent) {
        super.createPageControls(parent);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.settingPage);
        this.addPage((IWizardPage)this.experimentPage);
    }

    public boolean canFinish() {
        if (!this.settingPage.isPageComplete()) {
            return false;
        }
        return this.experimentPage.isPageComplete();
    }

    private PassageTimeResults rateOverridePassageTime(String rateName, double newRateValue) throws IOException, DerivationException {
        ModelNode revisedModel = (ModelNode)ASTSupport.copy((ASTNode)this.model.getAST());
        String resultsName = String.valueOf(rateName) + " = " + newRateValue;
        boolean found = false;
        for (RateDefinitionNode rd : revisedModel.rateDefinitions()) {
            if (!rd.getName().getName().equals(rateName)) continue;
            RateDoubleNode newRate = ASTFactory.createRate();
            newRate.setValue(newRateValue);
            rd.setRate((RateNode)newRate);
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("Setting not found");
        }
        return this.evaluatePassageTime(resultsName, resultsName, revisedModel);
    }

    private PassageTimeResults evaluatePassageTime(String cdfName, String pdfName, ModelNode modelNode) throws IOException, DerivationException {
        PepaJHydra passageSolver = new PepaJHydra("myfile.pepa", modelNode);
        passageSolver.setStartTime(this.settingPage.getStartTime());
        passageSolver.setTimeStep(this.settingPage.getTimeStep());
        passageSolver.setStopTime(this.settingPage.getStopTime());
        passageSolver.setSourceActions(this.settingPage.getSourceActs());
        passageSolver.setTargetActions(this.settingPage.getTargetActs());
        PassageTimeResults ptResults = passageSolver.performPassageTime(cdfName, pdfName);
        return ptResults;
    }

    private void drawPassageGraphs(PassageTimeResults[] ptResultsArray) {
        PassageTimeResults ptResults;
        int n;
        int n2;
        PassageTimeResults[] passageTimeResultsArray;
        if (this.settingPage.getCdfChecked()) {
            InfoWithAxes info = new InfoWithAxes();
            info.setXSeries(Series.create((double[])ptResultsArray[0].getTimePoints(), (String)"Time"));
            info.setShowLegend(true);
            info.setYLabel("Probability");
            info.setGraphTitle("Passage-time analysis Cumulative Distribution Function");
            info.setHas3DEffect(false);
            info.setShowMarkers(false);
            passageTimeResultsArray = ptResultsArray;
            n2 = ptResultsArray.length;
            n = 0;
            while (n < n2) {
                ptResults = passageTimeResultsArray[n];
                info.getYSeries().add(Series.create((double[])ptResults.getCdfPoints(), (String)ptResults.getCdfName()));
                ++n;
            }
            IChart chart = Plotting.getPlottingTools().createTimeSeriesChart(info);
            PlotViewPlugin.getDefault().reveal(chart);
        }
        if (this.settingPage.getPdfChecked()) {
            InfoWithAxes infoPdf = new InfoWithAxes();
            infoPdf.setXSeries(Series.create((double[])ptResultsArray[0].getTimePoints(), (String)"Time"));
            infoPdf.setShowLegend(true);
            infoPdf.setYLabel("Probability Density");
            infoPdf.setGraphTitle("Passage-time analysis Probability Density Function");
            infoPdf.setHas3DEffect(false);
            infoPdf.setShowMarkers(false);
            passageTimeResultsArray = ptResultsArray;
            n2 = ptResultsArray.length;
            n = 0;
            while (n < n2) {
                ptResults = passageTimeResultsArray[n];
                infoPdf.getYSeries().add(Series.create((double[])ptResults.getPdfPoints(), (String)ptResults.getPdfName()));
                ++n;
            }
            IChart chartPdf = Plotting.getPlottingTools().createTimeSeriesChart(infoPdf);
            PlotViewPlugin.getDefault().reveal(chartPdf);
        }
    }

    public boolean performFinish() {
        try {
            double[] values = this.experimentPage.getRateValues();
            String selectedRate = this.experimentPage.getSelected();
            if (values.length == 0 || selectedRate == null) {
                PassageTimeResults[] ptResultsArray = new PassageTimeResults[]{this.evaluatePassageTime("cdf", "pdf", this.model.getAST())};
                this.drawPassageGraphs(ptResultsArray);
            } else {
                PassageTimeResults[] ptResultsArray = new PassageTimeResults[values.length];
                int i = 0;
                while (i < values.length) {
                    ptResultsArray[i] = this.rateOverridePassageTime(selectedRate, values[i]);
                    ++i;
                }
                this.drawPassageGraphs(ptResultsArray);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Shell activeShell = Display.getDefault().getActiveShell();
            MessageDialog.openError((Shell)activeShell, (String)"Error during passage-time", (String)e.getCause().getMessage());
        }
        catch (DerivationException e) {
            e.printStackTrace();
            Shell activeShell = Display.getDefault().getActiveShell();
            MessageDialog.openError((Shell)activeShell, (String)"Error derivation of state space", (String)e.getCause().getMessage());
        }
        return true;
    }

    private class PassageExperimentPage
    extends WizardPage {
        private String[] allModelRateNames;
        private Text rateValuesText;
        private Button[] rateCheckBoxes;
        private Listener commonListener;

        protected PassageExperimentPage(String pageName, String[] allRates) {
            super(pageName);
            this.commonListener = new Listener(){

                public void handleEvent(Event event) {
                    PassageExperimentPage.this.validate();
                }
            };
            this.setTitle("Passage-Time Experimentation");
            this.setDescription("Set up a passage-time experiment");
            this.allModelRateNames = allRates;
        }

        public String getSelected() {
            int i = 0;
            while (i < this.rateCheckBoxes.length) {
                if (this.rateCheckBoxes[i].getSelection()) {
                    return this.allModelRateNames[i];
                }
                ++i;
            }
            return null;
        }

        public void createControl(Composite parent) {
            int textStyle = 18436;
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            this.setControl((Control)composite);
            Label tmpLabel = new Label(composite, 32);
            tmpLabel.setText("Please select the rate you wish to modify?");
            tmpLabel.setLayoutData((Object)this.createDefaultGridData());
            Composite checksParent = new Composite(composite, 0);
            checksParent.setLayout((Layout)new GridLayout(1, false));
            this.rateCheckBoxes = new Button[this.allModelRateNames.length];
            int i = 0;
            while (i < this.allModelRateNames.length) {
                Button checkBox;
                String rateName = this.allModelRateNames[i];
                this.rateCheckBoxes[i] = checkBox = new Button(checksParent, 32);
                checkBox.setText(rateName);
                checkBox.setLayoutData((Object)this.createDefaultGridData());
                checkBox.addListener(13, this.commonListener);
                ++i;
            }
            Label rateValuesLabel = new Label(composite, 0);
            rateValuesLabel.setText("Comma separated list of rate values (eg 1.0)");
            rateValuesLabel.setLayoutData((Object)this.createDefaultGridData());
            this.rateValuesText = new Text(composite, textStyle);
            this.rateValuesText.setLayoutData((Object)this.createDefaultGridData());
            this.rateValuesText.addListener(24, this.commonListener);
            this.validate();
        }

        private void validate() {
            this.setPageComplete(false);
            this.setErrorMessage(null);
            int checked = 0;
            Button[] buttonArray = this.rateCheckBoxes;
            int n = this.rateCheckBoxes.length;
            int n2 = 0;
            while (n2 < n) {
                Button checkBox = buttonArray[n2];
                if (checkBox.getSelection()) {
                    ++checked;
                }
                ++n2;
            }
            if (checked != 0) {
                if (checked > 1) {
                    this.setPageComplete(false);
                    this.setErrorMessage("Currently we can only range over one rate");
                    return;
                }
                if (this.getRateValues().length == 0) {
                    this.setPageComplete(false);
                    this.setErrorMessage("If you are ranging over a rate you must provide values");
                    return;
                }
                this.setPageComplete(true);
                return;
            }
            this.setPageComplete(true);
        }

        public double[] getRateValues() {
            String[] values = this.rateValuesText.getText().trim().split("(\\s)*,(\\s)*");
            double[] errorResult = new double[]{};
            if (values.length == 0) {
                return errorResult;
            }
            double[] list = new double[values.length];
            int i = 0;
            while (i < values.length) {
                try {
                    list[i] = Double.parseDouble(values[i]);
                    if (list[i] <= 0.0) {
                        return errorResult;
                    }
                    if (i > 0 && list[i] <= list[i - i]) {
                        return errorResult;
                    }
                }
                catch (Exception exception) {
                    return errorResult;
                }
                ++i;
            }
            return list;
        }

        private GridData createDefaultGridData() {
            return new GridData(4, 0x1000000, true, false);
        }
    }

    private class SettingPage
    extends WizardPage {
        private static final String SECTION_NAME = "passagetime.settingPage";
        private Label startTimeLabel;
        private Text startTimeText;
        private double startTime;
        private Label timeStepLabel;
        private Text timeStepText;
        private double timeStep;
        private Label stopTimeLabel;
        private Text stopTimeText;
        private double stopTime;
        private Label sourceActsLabel;
        private Text sourceActsText;
        private String[] sourceActs;
        private Label targetActsLabel;
        private Text targetActsText;
        private String[] targetActs;
        private Label srcAvailableList;
        private Label targetAvailableList;
        private Button cdfCheckButton;
        private Button pdfCheckButton;
        private Listener commonListener;
        private IDialogSettings settings;

        public double getStartTime() {
            return this.startTime;
        }

        public double getTimeStep() {
            return this.timeStep;
        }

        public double getStopTime() {
            return this.stopTime;
        }

        public String[] getSourceActs() {
            return this.sourceActs;
        }

        public String[] getTargetActs() {
            return this.targetActs;
        }

        public boolean getCdfChecked() {
            return this.cdfCheckButton.getSelection();
        }

        public boolean getPdfChecked() {
            return this.pdfCheckButton.getSelection();
        }

        protected SettingPage(String pageName) {
            super(pageName);
            this.startTime = 0.1;
            this.timeStep = 0.1;
            this.stopTime = 10.0;
            this.sourceActs = new String[0];
            this.targetActs = new String[0];
            this.commonListener = new Listener(){

                public void handleEvent(Event event) {
                    SettingPage.this.validate();
                }
            };
            this.setTitle("Passage-Time");
            this.setDescription("Select options for the passage-time analysis");
        }

        private HashSet<String> getModelActionsSet() {
            StaticAnalyser staticAnalyser = new StaticAnalyser(PassageTimeWizard.this.model.getAST());
            IAlphabetProvider alphabetProv = staticAnalyser.getAlphabetProvider();
            HashSet actionSet = alphabetProv.getModelAlphabet();
            return actionSet;
        }

        private String getAvailableActionString(HashSet<String> exempts) {
            HashSet<String> modelActions = this.getModelActionsSet();
            for (String action : exempts) {
                modelActions.remove(action);
            }
            Iterator<String> actionIter = modelActions.iterator();
            String result = new String();
            while (actionIter.hasNext()) {
                String next = actionIter.next();
                result = result.concat(next);
                if (!actionIter.hasNext()) continue;
                result = result.concat(", ");
            }
            return result;
        }

        public void createControl(Composite parent) {
            int textStyle = 18436;
            Composite outerRows = new Composite(parent, 0);
            outerRows.setLayout((Layout)new GridLayout(1, false));
            this.setControl((Control)outerRows);
            Composite composite = new Composite(outerRows, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            String availableActions = new String();
            HashSet<String> actionSet = this.getModelActionsSet();
            for (String actionName : actionSet) {
                availableActions = availableActions.concat(actionName);
            }
            this.startTimeLabel = new Label(composite, 32);
            this.startTimeLabel.setText("Start Time");
            this.startTimeLabel.setLayoutData((Object)this.createDefaultGridData());
            this.startTimeText = new Text(composite, textStyle);
            this.startTimeText.setLayoutData((Object)this.createDefaultGridData());
            this.startTimeText.addListener(24, this.commonListener);
            this.timeStepLabel = new Label(composite, 32);
            this.timeStepLabel.setText("Time Step");
            this.timeStepLabel.setLayoutData((Object)this.createDefaultGridData());
            this.timeStepText = new Text(composite, textStyle);
            this.timeStepText.setLayoutData((Object)this.createDefaultGridData());
            this.timeStepText.addListener(24, this.commonListener);
            this.stopTimeLabel = new Label(composite, 32);
            this.stopTimeLabel.setText("Stop Time");
            this.stopTimeLabel.setLayoutData((Object)this.createDefaultGridData());
            this.stopTimeText = new Text(composite, textStyle);
            this.stopTimeText.setLayoutData((Object)this.createDefaultGridData());
            this.stopTimeText.addListener(24, this.commonListener);
            this.sourceActsLabel = new Label(composite, 32);
            this.sourceActsLabel.setText("Source Actions");
            this.sourceActsLabel.setLayoutData((Object)this.createDefaultGridData());
            this.sourceActsText = new Text(composite, textStyle);
            this.sourceActsText.setLayoutData((Object)this.createDefaultGridData());
            this.sourceActsText.addListener(24, this.commonListener);
            this.targetActsLabel = new Label(composite, 32);
            this.targetActsLabel.setText("Target Actions");
            this.targetActsLabel.setLayoutData((Object)this.createDefaultGridData());
            this.targetActsText = new Text(composite, textStyle);
            this.targetActsText.setLayoutData((Object)this.createDefaultGridData());
            this.targetActsText.addListener(24, this.commonListener);
            int marginLeft = 20;
            Group availActionsGroup = new Group(outerRows, -1);
            availActionsGroup.setText("Available Action Names");
            GridLayout availLayout = new GridLayout();
            availLayout.numColumns = 2;
            availLayout.marginLeft = marginLeft;
            availActionsGroup.setLayout((Layout)availLayout);
            availActionsGroup.setLayoutData((Object)new GridData(768));
            availActionsGroup.setEnabled(true);
            HashSet<String> exempts = new HashSet<String>();
            Label srcAvailableLabel = new Label((Composite)availActionsGroup, 32);
            srcAvailableLabel.setText("Available source actions:");
            srcAvailableLabel.setLayoutData((Object)this.createDefaultGridData());
            this.srcAvailableList = new Label((Composite)availActionsGroup, 32);
            this.srcAvailableList.setText(this.getAvailableActionString(exempts));
            this.srcAvailableList.setLayoutData((Object)this.createDefaultGridData());
            Label targetAvailableLabel = new Label((Composite)availActionsGroup, 32);
            targetAvailableLabel.setText("Available target actions:");
            targetAvailableLabel.setLayoutData((Object)this.createDefaultGridData());
            this.targetAvailableList = new Label((Composite)availActionsGroup, 32);
            this.targetAvailableList.setText(this.getAvailableActionString(exempts));
            this.targetAvailableList.setLayoutData((Object)this.createDefaultGridData());
            Composite graphChecks = new Composite(composite, 0);
            graphChecks.setLayout((Layout)new GridLayout(1, false));
            this.cdfCheckButton = new Button(graphChecks, 32);
            this.cdfCheckButton.setText("Graph CDF");
            this.cdfCheckButton.setLayoutData((Object)this.createDefaultGridData());
            this.cdfCheckButton.addListener(13, this.commonListener);
            this.cdfCheckButton.setSelection(true);
            this.pdfCheckButton = new Button(graphChecks, 32);
            this.pdfCheckButton.setText("Graph PDF");
            this.pdfCheckButton.setLayoutData((Object)this.createDefaultGridData());
            this.pdfCheckButton.addListener(13, this.commonListener);
            this.pdfCheckButton.setSelection(false);
            this.initContents();
            this.validate();
        }

        private void updateAvailableActions(String[] srcActs, String[] tgtActs) {
            String action;
            HashSet<String> exempts = new HashSet<String>();
            String[] stringArray = srcActs;
            int n = srcActs.length;
            int n2 = 0;
            while (n2 < n) {
                action = stringArray[n2];
                exempts.add(action);
                ++n2;
            }
            this.srcAvailableList.setText(this.getAvailableActionString(exempts));
            stringArray = tgtActs;
            n = tgtActs.length;
            n2 = 0;
            while (n2 < n) {
                action = stringArray[n2];
                exempts.add(action);
                ++n2;
            }
            this.targetAvailableList.setText(this.getAvailableActionString(exempts));
        }

        private void initContents() {
            IDialogSettings uiSettings = Activator.getDefault().getDialogSettings();
            this.settings = uiSettings.getSection(SECTION_NAME);
            if (this.settings == null) {
                this.settings = uiSettings.addNewSection(SECTION_NAME);
            }
            this.startTimeText.setText("0.1");
            this.timeStepText.setText("0.1");
            this.stopTimeText.setText("10.0");
            this.sourceActsText.setText("");
            this.targetActsText.setText("");
        }

        public void validate() {
            String actionName;
            this.setErrorMessage(null);
            this.setPageComplete(false);
            boolean isComplete = true;
            String splitRegExp = "(\\s)*,(\\s)*";
            String sourceActsString = this.sourceActsText.getText().trim();
            this.sourceActs = sourceActsString.split(splitRegExp);
            String targetActsString = this.targetActsText.getText().trim();
            this.targetActs = targetActsString.split(splitRegExp);
            this.updateAvailableActions(this.sourceActs, this.targetActs);
            try {
                double start = Double.parseDouble(this.startTimeText.getText().trim());
                if (start < 0.0) {
                    this.setErrorMessage("Start time must be positive");
                    isComplete = false;
                    return;
                }
                this.startTime = start;
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage("Start time is not a valid double");
                isComplete = false;
                return;
            }
            try {
                double step = Double.parseDouble(this.timeStepText.getText().trim());
                if (step <= 0.0) {
                    this.setErrorMessage("Time Step must be positive");
                    isComplete = false;
                    return;
                }
                this.timeStep = step;
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage("Time Step is not a valid double");
                isComplete = false;
                return;
            }
            try {
                double stop = Double.parseDouble(this.stopTimeText.getText().trim());
                if (stop <= 0.0) {
                    this.setErrorMessage("Stop time must be positive");
                    isComplete = false;
                    return;
                }
                this.stopTime = stop;
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage("Stop time is not a valid double");
                isComplete = false;
                return;
            }
            HashSet<String> actionSet = this.getModelActionsSet();
            if (sourceActsString.length() == 0) {
                this.setErrorMessage("Source actions are empty");
                isComplete = false;
                return;
            }
            if (targetActsString.length() == 0) {
                this.setErrorMessage("Target actions are empty");
                isComplete = false;
                return;
            }
            String[] stringArray = this.sourceActs;
            int n = this.sourceActs.length;
            int n2 = 0;
            while (n2 < n) {
                actionName = stringArray[n2];
                if (!actionSet.contains(actionName)) {
                    this.setErrorMessage("The source action: " + actionName + " is not performed by the model");
                    isComplete = false;
                    return;
                }
                ++n2;
            }
            stringArray = this.targetActs;
            n = this.targetActs.length;
            n2 = 0;
            while (n2 < n) {
                actionName = stringArray[n2];
                if (!actionSet.contains(actionName)) {
                    this.setErrorMessage("The target action: " + actionName + " is not performed by the model");
                    isComplete = false;
                    return;
                }
                ++n2;
            }
            stringArray = this.sourceActs;
            n = this.sourceActs.length;
            n2 = 0;
            while (n2 < n) {
                String sAction = stringArray[n2];
                String[] stringArray2 = this.targetActs;
                int n3 = this.targetActs.length;
                int n4 = 0;
                while (n4 < n3) {
                    String tAction = stringArray2[n4];
                    if (sAction.equals(tAction)) {
                        this.setErrorMessage(String.valueOf(sAction) + " cannot be both a source and target action");
                        isComplete = false;
                        return;
                    }
                    ++n4;
                }
                ++n2;
            }
            if (!this.cdfCheckButton.getSelection() && !this.pdfCheckButton.getSelection()) {
                this.setErrorMessage("You must graph at least either the cdf or the pdf");
                isComplete = false;
                return;
            }
            this.setPageComplete(isComplete);
        }

        private GridData createDefaultGridData() {
            return new GridData(4, 0x1000000, true, false);
        }
    }
}

