/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.wizards.ctmcsolver.resourceless;

import java.util.Collection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.eclipse.core.PepaCore;
import uk.ac.ed.inf.pepa.eclipse.ui.dialogs.AbstractConfigurationWizardPage;
import uk.ac.ed.inf.pepa.eclipse.ui.dialogs.DoubleConfigurationText;
import uk.ac.ed.inf.pepa.eclipse.ui.dialogs.IntegerConfigurationText;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.ctmcsolver.resourceless.ISolverPageProxy;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.ctmcsolver.resourceless.PreconditionerPageFactory;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.ctmcsolver.resourceless.Preconditioners;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.ctmcsolver.resourceless.SolverWizard;

public class MTJIterativeSolverPage
implements ISolverPageProxy {
    protected int fSolverId;
    protected int fPreconditionerId;

    public MTJIterativeSolverPage(int solverId, int preconditionerId) {
        this.fSolverId = solverId;
        this.fPreconditionerId = preconditionerId;
    }

    @Override
    public boolean isNeedPage() {
        return true;
    }

    @Override
    public AbstractConfigurationWizardPage getPage() {
        return new MTJPage(this.fSolverId, this.fPreconditionerId);
    }

    protected static class MTJPage
    extends AbstractConfigurationWizardPage {
        private Combo comboPreconditioners;
        private IntegerConfigurationText maxIterText;
        private DoubleConfigurationText rTolText;
        private DoubleConfigurationText aTolText;
        private DoubleConfigurationText dTolText;
        private String currentSelectedPreconditioner = null;
        private int fPreconditionerId;

        protected MTJPage(int solverId, int preconditionerId) {
            super("MTJIterativeSolverPage");
            this.fPreconditionerId = preconditionerId;
            this.setTitle("Iteration monitor parameter settings");
            this.setDescription("Set solver parameters");
        }

        @Override
        public void setOptions(OptionMap map) {
            super.setOptions(map);
            map.put((Object)"ctmc.solver.preconditioner", (Object)this.fPreconditionerId);
        }

        @Override
        protected void fillSettingPanel() {
            Label iterLabel = new Label(this.settingPanel, this.labelStyle);
            iterLabel.setText("");
            GridData iterData = new GridData();
            iterData.horizontalSpan = 2;
            iterLabel.setLayoutData((Object)iterData);
            Label labelMaxIter = new Label(this.settingPanel, this.labelStyle);
            labelMaxIter.setText("Maximum number of iterations");
            this.maxIterText.createControl(this.settingPanel);
            Label labelRTol = new Label(this.settingPanel, this.labelStyle);
            labelRTol.setText("Relative tolerance");
            this.rTolText.createControl(this.settingPanel);
            Label labelATol = new Label(this.settingPanel, this.labelStyle);
            labelATol.setText("Absolute tolerance");
            this.aTolText.createControl(this.settingPanel);
            Label labelDTol = new Label(this.settingPanel, this.labelStyle);
            labelDTol.setText("Divergence tolerance");
            this.dTolText.createControl(this.settingPanel);
            labelMaxIter.setLayoutData((Object)new GridData());
            this.maxIterText.control.setLayoutData((Object)new GridData(this.gridDataStyle));
            labelRTol.setLayoutData((Object)new GridData());
            this.rTolText.control.setLayoutData((Object)new GridData(this.gridDataStyle));
            labelATol.setLayoutData((Object)new GridData());
            this.aTolText.control.setLayoutData((Object)new GridData(this.gridDataStyle));
            labelDTol.setLayoutData((Object)new GridData());
            this.dTolText.control.setLayoutData((Object)new GridData(this.gridDataStyle));
            Label precondLabel = new Label(this.settingPanel, 0);
            precondLabel.setText("Select the preconditioner");
            precondLabel.setLayoutData((Object)new GridData());
            this.comboPreconditioners = new Combo(this.settingPanel, 8);
            this.populatePreconditionerCombo();
            this.comboPreconditioners.setLayoutData((Object)new GridData(this.gridDataStyle));
            this.setPreconditioner(this.fPreconditionerId);
        }

        private void setPreconditioner(int id) {
            this.comboPreconditioners.setText(Preconditioners.getInstance().getPreconditionerName(id));
            this.newPreconditionerSelected(this.comboPreconditioners.getText());
        }

        @Override
        protected void resetToDefaults() {
            super.resetToDefaults();
            this.setDefaultPreconditioner();
        }

        private void setDefaultPreconditioner() {
            this.setPreconditioner(PepaCore.getDefault().getPluginPreferences().getDefaultInt("ctmc.solver.preconditioner"));
        }

        @Override
        protected void createConfigurationWidgets() {
            OptionMap map = ((SolverWizard)this.getWizard()).getOptionMap();
            this.maxIterText = new IntegerConfigurationText(map, "iteration.monitor.max_iter", this);
            this.rTolText = new DoubleConfigurationText(map, "iteration.monitor.rtol", this);
            this.aTolText = new DoubleConfigurationText(map, "iteration.monitor.atol", this);
            this.dTolText = new DoubleConfigurationText(map, "iteration.monitor.dtol", this);
            this.configurationWidgets.add(this.maxIterText);
            this.configurationWidgets.add(this.rTolText);
            this.configurationWidgets.add(this.aTolText);
            this.configurationWidgets.add(this.dTolText);
        }

        private void populatePreconditionerCombo() {
            Collection<String> precondStrings = Preconditioners.getInstance().getAvailablePreconditioners();
            for (String element : precondStrings) {
                this.comboPreconditioners.add(element);
            }
            this.comboPreconditioners.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    MTJPage.this.newPreconditionerSelected(MTJPage.this.comboPreconditioners.getText());
                }
            });
        }

        private void newPreconditionerSelected(String textPreconditioner) {
            this.setPageComplete(false);
            this.fPreconditionerId = Preconditioners.getInstance().getPreconditionerId(textPreconditioner);
            ISolverPageProxy preconditionerPage = PreconditionerPageFactory.createPreconditionerPageFor(this.fPreconditionerId);
            if (preconditionerPage == null) {
                this.setMessage(null);
                String error = "No Preconditioner available";
                this.setErrorMessage(error);
                return;
            }
            if (!textPreconditioner.equals(this.currentSelectedPreconditioner)) {
                AbstractConfigurationWizardPage newPage;
                ((SolverWizard)this.getWizard()).fPreconditionerPage = newPage = preconditionerPage.getPage();
                if (newPage != null) {
                    newPage.setWizard(this.getWizard());
                }
            }
            this.currentSelectedPreconditioner = textPreconditioner;
            this.setMessage(null);
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }
}

