/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.wizards.ctmcsolver.resourceless;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Preconditioners {
    private HashMap<String, Integer> availablePreconditioners = new HashMap(5);
    private static final Preconditioners instance = new Preconditioners();

    private Preconditioners() {
        this.availablePreconditioners.put("Algebraic Multigrid (AMG)", 1);
        this.availablePreconditioners.put("Incomplete Cholesky (ICC)", 3);
        this.availablePreconditioners.put("Incomplete LU Decomposition (ILU)", 6);
        this.availablePreconditioners.put("Incomplete LU with fill-in (ILUT)", 7);
        this.availablePreconditioners.put("Symmetrical Sucessive Overrelaxation (SSOR)", 4);
        this.availablePreconditioners.put("-", 0);
    }

    public static Preconditioners getInstance() {
        return instance;
    }

    public Collection<String> getAvailablePreconditioners() {
        ArrayList<String> l = new ArrayList<String>(this.availablePreconditioners.keySet());
        Collections.sort(l);
        return l;
    }

    public Integer getPreconditionerId(String key) {
        return this.availablePreconditioners.get(key);
    }

    public String getPreconditionerName(Integer value) {
        for (Map.Entry<String, Integer> entry : this.availablePreconditioners.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }
}

